// -*- C++ -*-

// ダイクストラ法のデモ

#include "RS_FHeap.hh"
#include "RS_Dijkstra.hh"

#include <cstdlib>
#include <iostream>
#include <sstream>

using std :: cin ;
using std :: ostream ;
using std :: ostringstream ;


const int LARGENUM = 10000 ;


class Sujic_Weight
{
  int _time ;
  int _transfers ;
  int _time_walk ;
  int _time_wait ;

public :

  Sujic_Weight ()
    : _time ( 0 ) ,
      _transfers ( 0 ) ,
      _time_walk ( 0 ) ,
      _time_wait ( 0 ) {}

  Sujic_Weight ( int _t, int _tf , int _twk , int _twt )
    : _time ( _t ) ,
      _transfers ( _tf ) ,
      _time_walk ( _twk ) ,
      _time_wait ( _twt ) {}
  
  Sujic_Weight ( Sujic_Weight const & x )
    : _time ( x . _time ) ,
      _transfers ( x . _transfers ) ,
      _time_walk ( x . _time_walk ) ,
      _time_wait ( x . _time_wait ) {}

  friend ostream & operator<< ( ostream & , Sujic_Weight const & ) ;
  friend bool operator< ( Sujic_Weight const & , Sujic_Weight const & ) ;
  friend Sujic_Weight operator+
  ( Sujic_Weight const & , Sujic_Weight const & ) ;

  Sujic_Weight & operator+= ( Sujic_Weight const & ) ;

} ;


ostream &
operator<<
( ostream & out ,
  Sujic_Weight const & x )
{
  out << x . _time << "(" << x . _transfers << "/" << x . _time_walk
      << "/" << x . _time_wait << ")" ;
  return out ;
}


bool
operator<
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  if ( x . _time < y . _time )
  {
    return true ;
  }
  else if ( x . _time == y . _time )
  {
    if ( x . _transfers < y . _transfers )
    {
      return true ;
    }
    else if ( x . _transfers == y . _transfers )
    {
      if ( x . _time_walk < y . _time_walk )
      {
        return true ;
      }
      else if ( x . _time_walk == y . _time_walk )
      {
        if ( x . _time_wait < y . _time_wait )
        {
          return true ;
        }
        else
        {
          return false ;
        }
      }
      else
      {
        return false ;
      }
    }
    else
    {
      return false ;
    }
  }
  else
  {
    return false ;
  }
}



Sujic_Weight
operator+
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  return Sujic_Weight
    ( x . _time + y . _time ,
      x . _transfers + y . _transfers ,
      x . _time_walk + y . _time_walk ,
      x . _time_wait + y . _time_wait ) ;
}


Sujic_Weight &
Sujic_Weight :: operator+=
( Sujic_Weight const & x )
{
  _time += x . _time ;
  _transfers += x . _transfers ;
  _time_walk += x . _time_walk ;
  _time_wait += x . _time_wait ;
  return * this ;
}




int
main
()
{
  // Dijkstra's Algorithm: Starting from Node i
  // Creating nodes
  RS_Dijkstra < Sujic_Weight , string > *
    x = new RS_Dijkstra < Sujic_Weight , string >
    ( Sujic_Weight ( LARGENUM , 0 , 0 , 0 ) ) ;
  ostringstream sx ;

  // Creating nodes
  for ( int j = 0 ; j < 15 ; ++ j )
  {
    sx << j ;
    x -> setNode ( sx . str () , sx . str () ) ;
    sx . clear () ;
    sx . str ( "" ) ;
  }

  // Creating branches
  x -> setBidirectionalBranches
    ( "0" , "1" , Sujic_Weight ( 14 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "0" , "2" , Sujic_Weight ( 9 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "0" , "3" , Sujic_Weight ( 31 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "1" , "10" , Sujic_Weight ( 16 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "1" , "13" , Sujic_Weight ( 20 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "2" , "3" , Sujic_Weight ( 20 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "2" , "4" , Sujic_Weight (  6 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "2" , "5" , Sujic_Weight ( 18 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "3" , "11" , Sujic_Weight ( 26 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "3" , "14" , Sujic_Weight ( 27 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "4" , "7" , Sujic_Weight ( 29 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "4" , "8" , Sujic_Weight (  1 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "5" , "6" , Sujic_Weight (  5 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "5" , "10" , Sujic_Weight (  2 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "6" , "7" , Sujic_Weight ( 15 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "6" , "11" , Sujic_Weight ( 10 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "6" , "12" , Sujic_Weight (  3 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "7" , "8" , Sujic_Weight ( 16 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "7" , "9" , Sujic_Weight (  1 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "8" , "9" , Sujic_Weight ( 30 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "8" , "10" , Sujic_Weight (  2 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "9" , "13" , Sujic_Weight ( 15 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "9" , "14" , Sujic_Weight (  3 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "10" , "11" , Sujic_Weight ( 14 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "11" , "12" , Sujic_Weight (  2 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "12" , "13" , Sujic_Weight (  7 , 0 , 0 , 0 ) ) ;
  x -> setBidirectionalBranches
    ( "13" , "14" , Sujic_Weight ( 26 , 0 , 0 , 0 ) ) ;

  x -> run ( "0" , Sujic_Weight ( 0 , 0 , 0 , 0 ) ) ;

  // Printing
  for ( int j = 0 ; j < 15 ; ++ j )
  {
    sx << j ;
    x -> printRoute ( sx . str () ) ;
    sx . clear () ;
    sx . str ( "" ) ;
  }

  delete x ;
}
