// -*- C++ -*-

// ダイクストラ法のデモ

#include "RS_FHeap.hh"
#include "RS_Dijkstra.hh"

#include <cstdlib>
#include <iostream>
#include <sstream>

using std :: cin ;
using std :: ostream ;
using std :: ostringstream ;


const int LARGENUM = 10000 ;


int
main
()
{
  // Dijkstra's Algorithm: Starting from Node i
  // Creating nodes
  RS_Dijkstra < int , string > *
    x = new RS_Dijkstra < int , string > ( LARGENUM ) ;
  ostringstream sx ;

  // Creating nodes
  for ( int j = 0 ; j < 15 ; ++ j )
  {
    sx << j ;
    x -> setNode ( sx . str () , sx . str () ) ;
    sx . clear () ;
    sx . str ( "" ) ;
  }

  // Creating branches
  x -> setBidirectionalBranches ( "0" , "1" , 14 ) ;
  x -> setBidirectionalBranches ( "0" , "2" ,  9 ) ;
  x -> setBidirectionalBranches ( "0" , "3" , 31 ) ;
  x -> setBidirectionalBranches ( "1" , "10" , 16 ) ;
  x -> setBidirectionalBranches ( "1" , "13" , 20 ) ;
  x -> setBidirectionalBranches ( "2" , "3" , 20 ) ;
  x -> setBidirectionalBranches ( "2" , "4" ,  6 ) ;
  x -> setBidirectionalBranches ( "2" , "5" , 18 ) ;
  x -> setBidirectionalBranches ( "3" , "11" , 26 ) ;
  x -> setBidirectionalBranches ( "3" , "14" , 27 ) ;
  x -> setBidirectionalBranches ( "4" , "7" , 29 ) ;
  x -> setBidirectionalBranches ( "4" , "8" ,  1 ) ;
  x -> setBidirectionalBranches ( "5" , "6" ,  5 ) ;
  x -> setBidirectionalBranches ( "5" , "10" ,  2 ) ;
  x -> setBidirectionalBranches ( "6" , "7" , 15 ) ;
  x -> setBidirectionalBranches ( "6" , "11" , 10 ) ;
  x -> setBidirectionalBranches ( "6" , "12" ,  3 ) ;
  x -> setBidirectionalBranches ( "7" , "8" , 16 ) ;
  x -> setBidirectionalBranches ( "7" , "9" ,  1 ) ;
  x -> setBidirectionalBranches ( "8" , "9" , 30 ) ;
  x -> setBidirectionalBranches ( "8" , "10" ,  2 ) ;
  x -> setBidirectionalBranches ( "9" , "13" , 15 ) ;
  x -> setBidirectionalBranches ( "9" , "14" ,  3 ) ;
  x -> setBidirectionalBranches ( "10" , "11" , 14 ) ;
  x -> setBidirectionalBranches ( "11" , "12" ,  2 ) ;
  x -> setBidirectionalBranches ( "12" , "13" ,  7 ) ;
  x -> setBidirectionalBranches ( "13" , "14" , 26 ) ;

  x -> run ( "0" , 0 ) ;

  // Printing
  for ( int j = 0 ; j < 15 ; ++ j )
  {
    sx << j ;
    x -> printRoute ( sx . str () ) ;
    sx . clear () ;
    sx . str ( "" ) ;
  }

  delete x ;
}
