// -*- C++ -*-

// ダイクストラ法のデモ

#include "RS_FHeap.hh"
#include "RS_Dijkstra.hh"

#include <cstdlib>
#include <iostream>
#include <sstream>
#include <vector>
#include <algorithm>
#include <string>
#include <map>

using std :: cerr ;
using std :: endl ;
using std :: ostream ;
using std :: ostringstream ;
using std :: string ;
using std :: sort ;
using std :: map ;



const int LARGENUM = 10000 ;


const bool DEP = true ;
const bool ARR = false ;


class Sujic_Weight
{
  int _time ;
  int _transfers ;
  int _time_walk ;
  int _time_wait ;

public :

  Sujic_Weight ()
    : _time ( 0 ) ,
      _transfers ( 0 ) ,
      _time_walk ( 0 ) ,
      _time_wait ( 0 ) {}

  Sujic_Weight ( int _t, int _tf , int _twk , int _twt )
    : _time ( _t ) ,
      _transfers ( _tf ) ,
      _time_walk ( _twk ) ,
      _time_wait ( _twt ) {}
  
  Sujic_Weight ( Sujic_Weight const & x )
    : _time ( x . _time ) ,
      _transfers ( x . _transfers ) ,
      _time_walk ( x . _time_walk ) ,
      _time_wait ( x . _time_wait ) {}

  Sujic_Weight getHalf () const
  { return Sujic_Weight
      ( _time / 2 , _transfers / 2 , _time_walk / 2 , _time_wait / 2 ) ; }

  friend ostream & operator<< ( ostream & , Sujic_Weight const & ) ;
  friend bool operator< ( Sujic_Weight const & , Sujic_Weight const & ) ;
  friend bool operator== ( Sujic_Weight const & , Sujic_Weight const & ) ;
  friend Sujic_Weight operator+
  ( Sujic_Weight const & , Sujic_Weight const & ) ;
  friend Sujic_Weight operator-
  ( Sujic_Weight const & , Sujic_Weight const & ) ;

  Sujic_Weight & operator+= ( Sujic_Weight const & ) ;

} ;


ostream &
operator<<
( ostream & out ,
  Sujic_Weight const & x )
{
  out << x . _time << "(" << x . _transfers << "/" << x . _time_walk
      << "/" << x . _time_wait << ")" ;
  return out ;
}


bool
operator<
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  if ( x . _time < y . _time )
  {
    return true ;
  }
  else if ( x . _time == y . _time )
  {
    if ( x . _transfers < y . _transfers )
    {
      return true ;
    }
    else if ( x . _transfers == y . _transfers )
    {
      if ( x . _time_walk < y . _time_walk )
      {
        return true ;
      }
      else if ( x . _time_walk == y . _time_walk )
      {
        if ( x . _time_wait < y . _time_wait )
        {
          return true ;
        }
        else
        {
          return false ;
        }
      }
      else
      {
        return false ;
      }
    }
    else
    {
      return false ;
    }
  }
  else
  {
    return false ;
  }
}


bool
operator==
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  return
    x . _time == y . _time
    && x . _transfers == y . _transfers
    && x . _time_walk == y . _time_walk
    && x . _time_wait == y . _time_wait ;
}



Sujic_Weight
operator+
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  return Sujic_Weight
    ( x . _time + y . _time ,
      x . _transfers + y . _transfers ,
      x . _time_walk + y . _time_walk ,
      x . _time_wait + y . _time_wait ) ;
}


Sujic_Weight
operator-
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  return Sujic_Weight
    ( x . _time - y . _time ,
      x . _transfers - y . _transfers ,
      x . _time_walk - y . _time_walk ,
      x . _time_wait - y . _time_wait ) ;
}


Sujic_Weight &
Sujic_Weight :: operator+=
( Sujic_Weight const & x )
{
  _time += x . _time ;
  _transfers += x . _transfers ;
  _time_walk += x . _time_walk ;
  _time_wait += x . _time_wait ;
  return * this ;
}



class X_Train ;
class X_Station ;


class X_SpaceTimeNode
{
public :
  static int CYCLE_TIME ;             // cycle time
  static bool DO_CYCLIC_SIMULATION ;  // true if cyclic schedule is assumed

  bool _dep ;                         // true if departing
  int _t_ ;                           // Time (of arrival or departure)
  int _cd_ ;                          // Cycle delay number
  bool _is_trn ;                      // True if on the train side
  X_Train const * _trn ;              // Train
  X_Station const * _sta ;            // Station

public :
  explicit X_SpaceTimeNode
  ( bool _dep_in , int _t_in , X_Train * _trn_in , bool _sw = true )
    : _dep ( _dep_in ) , _t_ ( _t_in ) , _cd_ ( 0 ) , _is_trn ( _sw ) ,
      _trn ( _trn_in ) , _sta ( 0 )
  { if ( DO_CYCLIC_SIMULATION ) {
      while ( _t_ < 0 ) { _t_ += CYCLE_TIME ; -- _cd_ ; }
      while ( _t_ >= CYCLE_TIME ) { _t_ -= CYCLE_TIME ; ++ _cd_ ; } } }

  explicit X_SpaceTimeNode ( X_Station const * _sta_in , bool _dep_in )
    : _dep ( _dep_in ) , _t_ ( 0 ) , _cd_ ( 0 ) , _is_trn ( false ) ,
      _trn ( 0 ) , _sta ( _sta_in ) {}

  X_SpaceTimeNode
  ( X_SpaceTimeNode const & x , bool _sw )
    : _dep ( x . _dep ) , _t_ ( x . _t_ ) , _cd_ ( x . _cd_ ) ,
      _is_trn ( _sw ) , _trn ( x . _trn ) , _sta ( x . _sta ) {}

  X_SpaceTimeNode ( X_SpaceTimeNode const & x )
    : _dep ( x . _dep ) , _t_ ( x . _t_ ) , _cd_ ( x . _cd_ ) ,
      _is_trn ( x . _is_trn ) , _trn ( x . _trn ) , _sta ( x . _sta ) {}

  X_SpaceTimeNode & operator= ( X_SpaceTimeNode const & x )
  { if ( & x == this ) return * this ;
    _dep = x . _dep ; _t_ = x . _t_ ; _cd_ = x . _cd_ ;
    _is_trn = x . _is_trn ; _trn = x . _trn ; _sta = x . _sta ;
    return * this ; }

  bool isDeparting () const { return _dep ; }
  int getTime () const { return _t_ ; }
  int getCycleDelay () const { return _cd_ ; }

  void setStation ( X_Station const * x ) { _sta = x ; }
  X_Station const * getStation () const { return _sta ; }

  string getName () const ;
} ;


class LessSTN
{
public :
  bool operator() ( X_SpaceTimeNode const * _l ,
                    X_SpaceTimeNode const * _r ) const
  { return _l -> getTime () < _r -> getTime () ; }
} ;



class X_Station
{
  string _name ;
  vector < X_SpaceTimeNode * > _stn ;
  map < X_SpaceTimeNode const * , X_SpaceTimeNode const * > _stn_a ;
  map < X_Station const * , double > _demand ;
  X_SpaceTimeNode const * _myexit ;

public :
  explicit X_Station ( string _n_in )
    : _name ( _n_in ) , _stn () , _stn_a () , _demand () , _myexit ( 0 )
  { _myexit = new X_SpaceTimeNode ( this , true ) ; }
  explicit X_Station ( X_Station const & x )
    : _name ( x . _name ) , _stn ( x . _stn ) , _stn_a ( x . _stn_a ) ,
      _demand ( x . _demand ) , _myexit ( x . _myexit ) {}
  X_Station & operator= ( X_Station const & x )
  { if ( & x == this ) return * this ;
    _name = x . _name ; _stn = x . _stn ; _stn_a = x . _stn_a ;
    _demand = x . _demand ; _myexit = x . _myexit ; return * this ; }

  void setTime ( X_SpaceTimeNode * x )
  { x -> setStation ( this ) ;
    X_SpaceTimeNode * y = new X_SpaceTimeNode ( * x , false ) ;
    _stn . push_back ( y ) ; _stn_a [ x ] = y ; }

  X_SpaceTimeNode const *
  getCorrespondingNode ( X_SpaceTimeNode const * x ) const
  { map < X_SpaceTimeNode const * , X_SpaceTimeNode const * >
      :: const_iterator ii = _stn_a . find ( x ) ;
    if ( ii == _stn_a . end () ) {
      cerr << "Error: SpaceTimeNode not found in getCorrespondingNode"
           << endl ; exit ( 1 ) ; } return ii -> second ; }

  void setDemand ( X_Station const * x , double _d_in )
  { _demand [ x ] = _d_in ; }

  void sortTimes ()
  { sort ( _stn . begin () , _stn . end () , LessSTN () ) ; }

  string const & getName () const { return _name ; }

  X_SpaceTimeNode const * getExit () const { return _myexit ; }

  vector < X_SpaceTimeNode * > :: iterator firstNode ()
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: iterator lastNode ()
  { return _stn . end () ; }
  vector < X_SpaceTimeNode * > :: const_iterator firstNode () const
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: const_iterator lastNode () const
  { return _stn . end () ; }

  map < X_Station const * , double > :: iterator firstOD ()
  { return _demand . begin () ; }
  map < X_Station const * , double > :: iterator lastOD ()
  { return _demand . end () ; }
  map < X_Station const * , double > :: const_iterator firstOD () const
  { return _demand . begin () ; }
  map < X_Station const * , double > :: const_iterator lastOD () const
  { return _demand . end () ; }
} ;


class X_Train
{
  string _name ;
  vector < X_SpaceTimeNode * > _stn ;

public :
  explicit X_Train ( string _n_in )
    : _name ( _n_in ) , _stn () {}
  X_Train ( X_Train const & x )
    : _name ( x . _name ) , _stn ( x . _stn ) {}
  X_Train & operator= ( X_Train const & x )
  { if ( & x == this ) return * this ;
    _name = x . _name ; _stn = x . _stn ; return * this ; }

  X_SpaceTimeNode * setTime ( bool _dep_ , int _t_ )
  { X_SpaceTimeNode * ret_val = new X_SpaceTimeNode ( _dep_ , _t_ , this ) ;
    _stn . push_back ( ret_val ) ; return ret_val ; }

  string const & getName () const { return _name ; }

  vector < X_SpaceTimeNode * > :: iterator firstNode ()
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: iterator lastNode ()
  { return _stn . end () ; }
  vector < X_SpaceTimeNode * > :: const_iterator firstNode () const
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: const_iterator lastNode () const
  { return _stn . end () ; }
} ;


string
X_SpaceTimeNode :: getName
()
  const
{
  string _ret_val = "NOSTN" ;
  if ( _sta )
  {
    _ret_val = _sta -> getName () ;
  }
  if ( _trn )
  {
    if ( _dep )
    {
      _ret_val += "_DP_" ;
    }
    else
    {
      _ret_val += "_AR_" ;
    }
    _ret_val += _trn -> getName () ;
  }
  else
  {
    if ( _dep )
    {
      _ret_val += "_EXIT" ;
    }
    else
    {
      _ret_val += "_PASSENGER" ;
    }
  }
  if ( _is_trn )
  {
    _ret_val += "_T" ;
  }
  return _ret_val ;
}



class X_SpaceTimeBranch ;


class X_STB_Key
{
  X_SpaceTimeNode const * __from ;
  X_SpaceTimeNode const * __to ;

public :
  X_STB_Key ( X_SpaceTimeNode const * _f , X_SpaceTimeNode const * _t )
    : __from ( _f ) , __to ( _t )
  { if ( ! __from || ! __to ) {
      cerr << "Error: null pointer used to initialise X_SpaceTimeBranch"
           << endl ; exit ( 1 ) ; } }
  X_STB_Key ( X_STB_Key const & x )
    : __from ( x . __from ) , __to ( x . __to ) {}
  X_STB_Key & operator= ( X_STB_Key const & x )
  { if ( & x == this ) return * this ;
    __from = x . __from ; __to = x . __to ; return * this ; }

  X_SpaceTimeNode const * getStartSTN () const { return __from ; }
  X_SpaceTimeNode const * getEndSTN () const { return __to ; }

  bool operator< ( X_STB_Key const & x ) const
  { return __from < x . __from || __from == x . __from && __to < x . __to ; }
  bool operator== ( X_STB_Key const & x ) const
  { return __from == x . __from && __to == x . __to ; }
} ;
  


class X_Passengers_F1 ;



class X_SpaceTimeBranch
  : public X_STB_Key
{
  Sujic_Weight _weight ;
  vector < X_Passengers_F1 const * > _pas_i ;
  vector < X_Passengers_F1 const * > _pas ;
  X_SpaceTimeNode * _p_arrivals ;

public :
  explicit X_SpaceTimeBranch
  ( X_SpaceTimeNode const * _bf_in , X_SpaceTimeNode const * _af_in ,
    Sujic_Weight const & _w_in )
    : X_STB_Key ( _bf_in , _af_in ) , _weight ( _w_in ) , _pas_i () ,
      _pas () , _p_arrivals ( 0 ) {}
  X_SpaceTimeBranch ( X_SpaceTimeBranch const & x )
    : X_STB_Key ( x ) , _weight ( x . _weight ) , _pas_i ( x . _pas_i ) ,
      _pas ( x . _pas ) , _p_arrivals ( x . _p_arrivals ) {}
  X_SpaceTimeBranch & operator= ( X_SpaceTimeBranch const & x )
  { if ( this == & x ) return * this ;
    X_STB_Key :: operator= ( x ) ; _weight = x . _weight ;
    _pas = x . _pas ; _p_arrivals = x . _p_arrivals ; return * this ; }

  void setPassengerArrivalNode ()
  { _p_arrivals = new X_SpaceTimeNode
      ( getStartSTN () -> getStation () , false ) ; }
  X_SpaceTimeNode const * getPassengerArrivalNode () const 
  { return _p_arrivals ; }

  Sujic_Weight const & getWeight () const { return _weight ; }

  void addPassenger ( X_Passengers_F1 const * x ) 
  { _pas . push_back ( x ) ; }

  void addInitiatingPassenger ( X_Passengers_F1 const * x ) 
  { _pas_i . push_back ( x ) ; }

  string getMiddleName () const
  { string ret_val = "MIDDLE_" ; ret_val += getStartSTN () -> getName () ;
    ret_val += "_" ; ret_val += getEndSTN () -> getName () ; return ret_val ; }

  string const & getStartStationName () const 
  { return getStartSTN () -> getStation () -> getName () ; }

  string const & getEndStationName () const 
  { return getEndSTN () -> getStation () -> getName () ; }

  vector < X_Passengers_F1 const * > :: const_iterator
  firstInitialPassenger () const { return _pas_i . begin () ; }
  vector < X_Passengers_F1 const * > :: const_iterator
  lastInitialPassenger () const { return _pas_i . end () ; }

  vector < X_Passengers_F1 const * > :: const_iterator
  firstPassenger () const { return _pas . begin () ; }
  vector < X_Passengers_F1 const * > :: const_iterator
  lastPassenger () const { return _pas . end () ; }
} ;





class X_Passengers_F1
{
  X_SpaceTimeBranch const * _stb_st ;
  X_Station const * _sta_dest ;
  int _t_ ;
  int _cd_ ;
  double _num_passen ;

public :
  X_Passengers_F1
  ( X_SpaceTimeBranch const * _stb_in ,
    X_Station const * _sta_d_in , int _t_in , int _cd_in , double _np_in )
    : _stb_st ( _stb_in ) , _sta_dest ( _sta_d_in ) ,
      _t_ ( _t_in ) , _cd_ ( _cd_in ) , _num_passen ( _np_in ) {}

  X_SpaceTimeBranch const * getStartSTB () const { return _stb_st ; }
  double getPassengerNumber () const { return _num_passen ; }
  int getTime () const { return _t_ ; }
  int getCycleDelay () const { return _cd_ ; }
  X_Station const * getDestination () const { return _sta_dest ; }
} ;



int X_SpaceTimeNode :: CYCLE_TIME = 300 ;
bool X_SpaceTimeNode :: DO_CYCLIC_SIMULATION = true ;



int
main
()
{

  // Stations container
  map < string , X_Station * > _sta ;

  // Trains container
  map < string , X_Train * > _trn ;

  // Create stations
  _sta [ "Sta_A" ] = new X_Station ( "Sta_A" ) ;
  _sta [ "Sta_B" ] = new X_Station ( "Sta_B" ) ;
  _sta [ "Sta_C" ] = new X_Station ( "Sta_C" ) ;
  _sta [ "Sta_D" ] = new X_Station ( "Sta_D" ) ;
  _sta [ "Sta_E" ] = new X_Station ( "Sta_E" ) ;

  // Set OD demand data
  _sta [ "Sta_A" ] -> setDemand ( _sta [ "Sta_B" ] ,   30 ) ;
  _sta [ "Sta_A" ] -> setDemand ( _sta [ "Sta_C" ] ,  300 ) ;
  _sta [ "Sta_A" ] -> setDemand ( _sta [ "Sta_D" ] ,   30 ) ;
  _sta [ "Sta_A" ] -> setDemand ( _sta [ "Sta_E" ] , 1000 ) ;
  _sta [ "Sta_B" ] -> setDemand ( _sta [ "Sta_C" ] ,   30 ) ;
  _sta [ "Sta_B" ] -> setDemand ( _sta [ "Sta_D" ] ,    3 ) ;
  _sta [ "Sta_B" ] -> setDemand ( _sta [ "Sta_E" ] ,  100 ) ;
  _sta [ "Sta_C" ] -> setDemand ( _sta [ "Sta_D" ] ,   30 ) ;
  _sta [ "Sta_C" ] -> setDemand ( _sta [ "Sta_E" ] , 1000 ) ;
  _sta [ "Sta_D" ] -> setDemand ( _sta [ "Sta_E" ] ,  100 ) ;

  // Create trains
  _trn [ "Local_01" ] = new X_Train ( "Local_01" ) ;
  _sta [ "Sta_A" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( DEP , 1000 ) ) ;
  _sta [ "Sta_B" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( ARR , 1090 ) ) ;
  _sta [ "Sta_B" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( DEP , 1120 ) ) ;
  _sta [ "Sta_C" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( ARR , 1240 ) ) ;
  _sta [ "Sta_C" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( DEP , 1390 ) ) ;
  _sta [ "Sta_D" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( ARR , 1540 ) ) ;
  _sta [ "Sta_D" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( DEP , 1570 ) ) ;
  _sta [ "Sta_E" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( ARR , 1660 ) ) ;

  _trn [ "Express_01" ] = new X_Train ( "Express_01" ) ;
  _sta [ "Sta_A" ] -> setTime
    ( _trn [ "Express_01" ] -> setTime ( DEP , 1120 ) ) ;
  _sta [ "Sta_C" ] -> setTime
    ( _trn [ "Express_01" ] -> setTime ( ARR , 1300 ) ) ;
  _sta [ "Sta_C" ] -> setTime
    ( _trn [ "Express_01" ] -> setTime ( DEP , 1330 ) ) ;
  _sta [ "Sta_E" ] -> setTime
    ( _trn [ "Express_01" ] -> setTime ( ARR , 1540 ) ) ;

  //////////////////////////////////////////////////////////////////////

  // ----
  // Sorting Space Time Nodes in X_Station objects.
  // ----
  for ( map < string , X_Station * > :: iterator ii = _sta . begin () ;
        ii != _sta . end () ; ++ ii )
  {
    ii -> second -> sortTimes () ;
  }

  // ----
  // Create and populate a vector of SpaceTimeBranch for starting the path
  // search, and a vector of passenger tokens.
  // ----
  map < X_STB_Key , X_SpaceTimeBranch * > _stb_map ;
  vector < X_SpaceTimeBranch * > _stb_st ;
  vector < X_Passengers_F1 * > _pas_f1 ;
  for ( map < string , X_Station * > :: iterator ii = _sta . begin () ;
        ii != _sta . end () ; ++ ii )
  {
    for ( vector < X_SpaceTimeNode * > :: const_iterator
            ix = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () - 1 ; ++ ix )
    {
      // ----
      // Creation of a SpaceTimeBranch_Station object. This will be the
      // starting point of the path search using the Dijkstra's algorithm.
      // ----
      X_SpaceTimeNode const * _stn_s = * ix ;
      X_SpaceTimeNode const * _stn_e = * ( ix + 1 ) ;
      int _tx = _stn_e -> getTime () - _stn_s -> getTime () ;
      if ( _tx < 0 )
      {
        _tx += X_SpaceTimeNode :: CYCLE_TIME ;
      }
      if ( _tx < 0 || _tx >= X_SpaceTimeNode :: CYCLE_TIME )
      {
        cerr << "Error: internal error 1." << endl ;
        exit ( 1 ) ;
      }
      cerr << "Branch: " << _tx << ", " << _stn_s -> getName () << " ["
           << _stn_s -> getTime () << "/" << _stn_s -> getCycleDelay ()
           << "] -> " << _stn_e -> getName () << " ["
           << _stn_e -> getTime () << "/" << _stn_e -> getCycleDelay ()
           << "]" << endl ;
      X_SpaceTimeBranch * _sx = new X_SpaceTimeBranch
        ( _stn_s , _stn_e , Sujic_Weight ( _tx , 0 , 0 , _tx ) ) ;
      _sx -> setPassengerArrivalNode () ;
      _stb_st . push_back ( _sx ) ;
      if ( _stb_map . find ( X_STB_Key ( _stn_s , _stn_e ) )
           != _stb_map . end () )
      {
        cerr << "Error: already an element in _stb_map." << endl ;
        exit ( 2 ) ;
      }
      _stb_map [ X_STB_Key ( _stn_s , _stn_e ) ] = _sx ;

      // ----
      // Creation of X_Passengers_F1 objects. If there is a demand data
      // from this particular station, then a X_Passengers_F1 object per
      // destination station will be created. Each object will represent
      // ( D / C * T ) passengers, where D is the demand (number of
      // passengers) per cycle, C is the cycle time in [sec] and T is the
      // length in [sec] of the SpaceTimeBranch _stb_x.
      // ----
      X_SpaceTimeNode const * _n_s = _sx -> getStartSTN () ;
      X_SpaceTimeNode const * _n_e = _sx -> getEndSTN () ;
      int _t_s = _n_s -> getTime () ;
      int _cd_s = _n_s -> getCycleDelay () ;
      int _t_e = _n_e -> getTime () ;
      int _t_x = _t_e - _t_s ;
      _t_s += _t_x / 2 ;
      while ( _t_s >= X_SpaceTimeNode :: CYCLE_TIME )
      {
        _t_s -= X_SpaceTimeNode :: CYCLE_TIME ;
        ++ _cd_s ;
      }
      for ( map < X_Station const * , double > :: const_iterator
              iy = ii -> second -> firstOD () ;
            iy != ii -> second -> lastOD () ; ++ iy )
      {
        double _dem_x = iy -> second ;
        X_Station const * _sta_dest = iy -> first ;
        _dem_x *= _t_x ;
        _dem_x /= X_SpaceTimeNode :: CYCLE_TIME ;
        cerr << "  Passenger: \"" << _n_s -> getName () << "\"-|-\""
             << _n_e -> getName () << "\" -> \"" << _sta_dest -> getName ()
             << "\"" << endl << "    [" << _t_s << "/" << _cd_s << "]: "
             << _dem_x << " = " << _t_x << " / "
             << X_SpaceTimeNode :: CYCLE_TIME << " * " << iy -> second
             << endl ;
        X_Passengers_F1 *
          _x_pfi = new X_Passengers_F1
          ( _sx , _sta_dest , _t_s , _cd_s , _dem_x ) ;
        _pas_f1 . push_back ( _x_pfi ) ;
        _sx -> addInitiatingPassenger ( _x_pfi ) ;
      }
    }
    // ----
    // DO_CYCLIC_SIMULATION ** MUST ** be true...
    // ----
    if ( X_SpaceTimeNode :: DO_CYCLIC_SIMULATION )
    {
      vector < X_SpaceTimeNode * > :: const_iterator
        i_last = ii -> second -> lastNode () - 1 ;
      vector < X_SpaceTimeNode * > :: const_iterator
        i_first = ii -> second -> firstNode () ;
      // ----
      // Creation of a cyclic SpaceTimeBranch object.
      // ----
      X_SpaceTimeNode const * _stn_s = * i_last ;
      X_SpaceTimeNode const * _stn_e = * i_first ;
      int _tx = _stn_e -> getTime () - _stn_s -> getTime () ;
      if ( _tx < 0 )
      {
        _tx += X_SpaceTimeNode :: CYCLE_TIME ;
      }
      if ( _tx < 0 || _tx >= X_SpaceTimeNode :: CYCLE_TIME )
      {
        cerr << "Error: internal error 1." << endl ;
        exit ( 1 ) ;
      }
      cerr << "Branch: " << _tx << ", " << _stn_s -> getName () << " ["
           << _stn_s -> getTime () << "/" << _stn_s -> getCycleDelay ()
           << "] -> " << _stn_e -> getName () << " ["
           << _stn_e -> getTime () << "/" << _stn_e -> getCycleDelay ()
           << "]" << endl ;
      X_SpaceTimeBranch * _sx = new X_SpaceTimeBranch
        ( _stn_s , _stn_e , Sujic_Weight ( _tx , 0 , 0 , _tx ) ) ;
      _sx -> setPassengerArrivalNode () ;
      _stb_st . push_back ( _sx ) ;
      if ( _stb_map . find ( X_STB_Key ( _stn_s , _stn_e ) )
           != _stb_map . end () )
      {
        cerr << "Error: already an element in _stb_map." << endl ;
        exit ( 3 ) ;
      }
      _stb_map [ X_STB_Key ( _stn_s , _stn_e ) ] = _sx ;

      // ----
      // Creation of a "cyclic" X_Passengers_F1 object.
      // ----
      X_SpaceTimeNode const * _n_s = _sx -> getStartSTN () ;
      X_SpaceTimeNode const * _n_e = _sx -> getEndSTN () ;
      int _t_s = _n_s -> getTime () ;
      int _cd_s = _n_s -> getCycleDelay () ;
      int _t_e = _n_e -> getTime () ;
      int _t_x = _t_e - _t_s + X_SpaceTimeNode :: CYCLE_TIME ;
      _t_s += _t_x / 2 ;
      while ( _t_s >= X_SpaceTimeNode :: CYCLE_TIME )
      {
        _t_s -= X_SpaceTimeNode :: CYCLE_TIME ;
        ++ _cd_s ;
      }
      for ( map < X_Station const * , double > :: const_iterator
              iy = ii -> second -> firstOD () ;
            iy != ii -> second -> lastOD () ; ++ iy )
      {
        double _dem_x = iy -> second ;
        X_Station const * _sta_dest = iy -> first ;
        _dem_x *= _t_x ;
        _dem_x /= X_SpaceTimeNode :: CYCLE_TIME ;
        cerr << "  Passenger: \"" << _n_s -> getName () << "\"-|-\""
             << _n_e -> getName () << "\" -> \"" << _sta_dest -> getName ()
             << "\"" << endl << "    [" << _t_s << "/" << _cd_s << "]: "
             << _dem_x << " = " << _t_x << " / "
             << X_SpaceTimeNode :: CYCLE_TIME << " * " << iy -> second
             << endl ;
        X_Passengers_F1 *
          _x_pfi = new X_Passengers_F1
          ( _sx , _sta_dest , _t_s , _cd_s , _dem_x ) ;
        _pas_f1 . push_back ( _x_pfi ) ;
        _sx -> addInitiatingPassenger ( _x_pfi ) ;
      }
    }
  }

  // ----
  // Create and populate the X_SpaceTimeBranch vector. This will contain
  // branches other than those linking X_SpaceTimeNodes at the same station.
  // ----
  vector < X_SpaceTimeBranch * > _stb_n ;

  // ----
  // Between every SpaceTimeNode at station and station exit.
  // ----
  for ( map < string , X_Station * > :: iterator ii = _sta . begin () ;
        ii != _sta . end () ; ++ ii )
  {
    for ( vector < X_SpaceTimeNode * > :: const_iterator
            ix = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () ; ++ ix )
    {
      cerr << "Branch (dummy): " << ( * ix ) -> getName () << " -> "
           << ii -> second -> getExit () -> getName () << endl ;
      X_SpaceTimeBranch * _sx = new X_SpaceTimeBranch
        ( * ix , ii -> second -> getExit () ,
          Sujic_Weight ( 0 , 0 , 0 , 0 ) ) ;
      _stb_n . push_back ( _sx ) ;
      if ( _stb_map . find ( X_STB_Key ( * ix , ii -> second -> getExit () ) )
           != _stb_map . end () )
      {
        cerr << "Error: already an element in _stb_map." << endl ;
        exit ( 1 ) ;
      }
      _stb_map [ X_STB_Key ( * ix , ii -> second -> getExit () ) ] = _sx ;
    }
  }

  // ----
  // Between passenger arrival and exit of the same station (meaningless, but
  // necessary (?) in calculation).
  // ----
  for ( vector < X_SpaceTimeBranch * > :: iterator
          istb = _stb_st . begin () ; istb != _stb_st . end () ; ++ istb )
  {
    X_SpaceTimeNode const *
      _stb_ptr = ( * istb ) -> getPassengerArrivalNode () ;
    X_SpaceTimeNode const *
      _own_exit
      = ( * istb ) -> getStartSTN () -> getStation () -> getExit () ;
    cerr << "Branch (dummy): " << _stb_ptr -> getName ()
         << " -> " << _own_exit -> getName () << endl ;
    X_SpaceTimeBranch * _sx = new X_SpaceTimeBranch
      ( _stb_ptr , _own_exit , Sujic_Weight ( 0 , 0 , 0 , 0 ) ) ;
    if ( _stb_map . find ( X_STB_Key ( _stb_ptr , _own_exit ) )
         != _stb_map . end () )
    {
      cerr << "Error: already an element in _stb_map." << endl ;
      exit ( 4 ) ;
    }
    _stb_map [ X_STB_Key ( _stb_ptr , _own_exit ) ] = _sx ;
  }

  // ----
  // Creating train branches.
  // ----
  for ( map < string , X_Train * > :: iterator ii = _trn . begin () ;
        ii != _trn . end () ; ++ ii )
  {
    for ( vector < X_SpaceTimeNode * > :: const_iterator ix
            = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () - 1 ; ++ ix )
    {
      X_SpaceTimeNode const * _nns = * ix ;
      X_SpaceTimeNode const * _nne = * ( ix + 1 ) ;
      int _ts = ( * ix ) -> getTime () ;
      int _cds = ( * ix ) -> getCycleDelay () ;
      int _te = ( * ( ix + 1 ) ) -> getTime () ;
      int _cde = ( * ( ix + 1 ) ) -> getCycleDelay () ;
      int _tb = ( _te + _cde * X_SpaceTimeNode :: CYCLE_TIME )
        - ( _ts + _cds * X_SpaceTimeNode :: CYCLE_TIME ) ;
      cerr << "Branch (train): " << _nns -> getName ()
           << " -> " << _nne -> getName () << endl ;
      X_SpaceTimeBranch * _sx = new X_SpaceTimeBranch
        ( _nns , _nne , Sujic_Weight ( _tb , 0 , 0 , 0 ) ) ;
      _stb_n . push_back ( _sx ) ;
      if ( _stb_map . find ( X_STB_Key ( _nns , _nne ) )
           != _stb_map . end () )
      {
        cerr << "Error: already an element in _stb_map." << endl ;
        exit ( 5 ) ;
      }
      _stb_map [ X_STB_Key ( _nns , _nne ) ] = _sx ;
    }

    for ( vector < X_SpaceTimeNode * > :: const_iterator ix
            = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () ; ++ ix )
    {
      X_SpaceTimeNode const * _nns = * ix ;
      X_SpaceTimeNode const * _nne = _nns ;
      if ( _nns -> isDeparting () )
      {
        _nns = _nne -> getStation () -> getCorrespondingNode ( _nne ) ;
      }
      else
      {
        _nne = _nns -> getStation () -> getCorrespondingNode ( _nns ) ;
      }
      cerr << "Branch (transfer): " << _nns -> getName ()
           << " -> " << _nne -> getName () << endl ;
      X_SpaceTimeBranch * _sx = new X_SpaceTimeBranch
        ( _nns , _nne , Sujic_Weight ( 0 , 1 , 0 , 0 ) ) ;
      _stb_n . push_back ( _sx ) ;
      if ( _stb_map . find ( X_STB_Key ( _nns , _nne ) )
           != _stb_map . end () )
      {
        cerr << "Error: already an element in _stb_map." << endl ;
        exit ( 6 ) ;
      }
      _stb_map [ X_STB_Key ( _nns , _nne ) ] = _sx ;
    }
  }

  // ----
  // For each SpaceTimeBranch in vector _stb_st, perform path search
  // using a Dijkstra's algorithm solver. Solvers must be kept on the memory
  // after the algorithm has been run.
  // ----
  map < X_SpaceTimeBranch const * ,
    RS_Dijkstra < Sujic_Weight , X_SpaceTimeNode const * > * > _dk_solvers ;

  for ( vector < X_SpaceTimeBranch * > :: iterator
          istb = _stb_st . begin () ; istb != _stb_st . end () ; ++ istb )
  {
    // ----
    // Setting names.
    // ----
    string _stb_name = ( * istb ) -> getMiddleName () ;
    X_SpaceTimeNode const *
      _stb_ptr = ( * istb ) -> getPassengerArrivalNode () ;
    X_SpaceTimeNode const * _own_exit
      = ( * istb ) -> getStartSTN () -> getStation () -> getExit () ;

    // ----
    // Creating a Dijkstra's Algorithm solver.
    // ----
    RS_Dijkstra < Sujic_Weight , X_SpaceTimeNode const * > *
      _x_slv = new RS_Dijkstra < Sujic_Weight , X_SpaceTimeNode const * >
      ( Sujic_Weight ( LARGENUM , 0 , 0 , 0 ) ) ;
    _dk_solvers [ * istb ] = _x_slv ;

    // ----
    // Creating nodes in the Dijkstra's algorithm solver.
    // ----
    for ( map < string , X_Station * > :: iterator ii = _sta . begin () ;
          ii != _sta . end () ; ++ ii )
    {
      for ( vector < X_SpaceTimeNode * > :: const_iterator ix
              = ii -> second -> firstNode () ;
            ix != ii -> second -> lastNode () ; ++ ix )
      {
        _x_slv -> setNode ( ( * ix ) , ( * ix ) -> getName () ) ;
      }
      X_SpaceTimeNode const * _exit = ii -> second -> getExit () ;
      _x_slv -> setNode ( _exit , _exit -> getName () ) ;
    }

    // ----
    // Creating the node representing passengers' arrival at the originating
    // station.
    // ----
    _x_slv -> setNode ( _stb_ptr , _stb_name ) ;

    // ----
    // Trains must have their own nodes at stations.
    // ----
    for ( map < string , X_Train * > :: iterator ii = _trn . begin () ;
          ii != _trn . end () ; ++ ii )
    {
      for ( vector < X_SpaceTimeNode * > :: const_iterator ix
              = ii -> second -> firstNode () ;
            ix != ii -> second -> lastNode () ; ++ ix )
      {
        _x_slv -> setNode ( ( * ix ) , ( * ix ) -> getName () ) ;
      }
    }

    // ----
    // Creating branches at stations.
    // Note::: at stations, branch time length does not need consideration
    // of cycle delays.
    // ----
    for ( vector < X_SpaceTimeBranch * > :: iterator ii = _stb_st . begin () ;
          ii != _stb_st . end () ; ++ ii )
    {
      X_SpaceTimeNode const * _nns = ( * ii ) -> getStartSTN () ;
      X_SpaceTimeNode const * _nne = ( * ii ) -> getEndSTN () ;
      if ( ( * ii ) == ( * istb ) )
      {
        Sujic_Weight _wt_half = ( * ii ) -> getWeight () . getHalf () ;
        X_SpaceTimeNode const * _nnm = _stb_ptr ;
        _x_slv -> setBranch ( _nns , _nnm , _wt_half ) ;
        _x_slv -> setBranch
          ( _nnm , _nne , ( * ii ) -> getWeight () - _wt_half ) ;
        _x_slv -> setBranch
          ( _stb_ptr , _own_exit , Sujic_Weight ( 0 , 0 , 0 , 0 ) ) ;
      }
      else
      {
        _x_slv -> setBranch ( _nns , _nne , ( * ii ) -> getWeight () ) ;
      }
    }

    // ----
    // Creating other branches.
    // ----
    for ( vector < X_SpaceTimeBranch * > :: iterator ii = _stb_n . begin () ;
          ii != _stb_n . end () ; ++ ii )
    {
      X_SpaceTimeNode const * _nns = ( * ii ) -> getStartSTN () ;
      X_SpaceTimeNode const * _nne = ( * ii ) -> getEndSTN () ;
      _x_slv -> setBranch ( _nns , _nne , ( * ii ) -> getWeight () ) ;
    }

    // ----
    // Solver complete. Run the algorithm.
    // ----
    cerr << endl << "Solver complete: " << _stb_name << endl ;
    _x_slv -> run ( _stb_ptr , Sujic_Weight ( 0 , 0 , 0 , 0 ) ) ;

    // ----
    // Printing paths.
    // ----
    for ( map < string , X_Station * > :: iterator ii = _sta . begin () ;
          ii != _sta . end () ; ++ ii )
    {
      _x_slv -> printRoute ( ii -> second -> getExit () ) ;
    }

    // ----
    // Putting passengers in containers.
    // ----
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * istb ) -> firstInitialPassenger () ;
          ix != ( * istb ) -> lastInitialPassenger () ; ++ ix )
    {
      deque < X_SpaceTimeNode const * > _pth = _x_slv -> getRoute
        ( ( * ix ) -> getDestination () -> getExit () ) ;
      for ( deque < X_SpaceTimeNode const * > :: const_iterator
              ipth = _pth . begin () ; ipth != _pth . end () - 1 ; ++ ipth )
      {
        map < X_STB_Key , X_SpaceTimeBranch * > :: iterator
          ibr = _stb_map . find ( X_STB_Key ( * ipth , * ( ipth + 1 ) ) ) ;
        if ( ibr != _stb_map . end () )
        {
          ibr -> second -> addPassenger ( * ix ) ;
        }
      }
    }
  }

  // ----
  // Checking passengers in the containers.
  // ----
  cerr << endl ;
  for ( vector < X_SpaceTimeBranch * > :: iterator
          ii = _stb_n . begin () ; ii != _stb_n . end () ; ++ ii )
  {
    double _pas_s = 0 ;
    double _pas_e = 0 ;
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * ii ) -> firstInitialPassenger () ;
          ix != ( * ii ) -> lastInitialPassenger () ; ++ ix )
    {
      _pas_e += ( * ix ) -> getPassengerNumber () ;
    }
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * ii ) -> firstPassenger () ;
          ix != ( * ii ) -> lastPassenger () ; ++ ix )
    {
      _pas_s += ( * ix ) -> getPassengerNumber () ;
      _pas_e += ( * ix ) -> getPassengerNumber () ;
    }
    cerr << "Branch \"" << ( * ii ) -> getStartSTN () -> getName ()
         << "\" -> \"" << ( * ii ) -> getEndSTN () -> getName ()
         << "\": " << _pas_s << " -|- " << _pas_e << endl ;
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * ii ) -> firstInitialPassenger () ;
          ix != ( * ii ) -> lastInitialPassenger () ; ++ ix )
    {
      cerr << "  [I] "
           << ( * ix ) -> getStartSTB () -> getStartStationName ()
           << ": [" << ( * ix ) -> getTime () << "/"
           << ( * ix ) -> getCycleDelay () << "] -> "
           << ( * ix ) -> getDestination () -> getName ()
           << ": " << ( * ix ) -> getPassengerNumber () << endl ;
    }
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * ii ) -> firstPassenger () ;
          ix != ( * ii ) -> lastPassenger () ; ++ ix )
    {
      cerr << "  [P] "
           << ( * ix ) -> getStartSTB () -> getStartStationName ()
           << ": [" << ( * ix ) -> getTime () << "/"
           << ( * ix ) -> getCycleDelay () << "] -> "
           << ( * ix ) -> getDestination () -> getName ()
           << ": " << ( * ix ) -> getPassengerNumber () << endl ;
    }
  }
  for ( vector < X_SpaceTimeBranch * > :: iterator
          ii = _stb_st . begin () ; ii != _stb_st . end () ; ++ ii )
  {
    double _pas_s = 0 ;
    double _pas_e = 0 ;
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * ii ) -> firstInitialPassenger () ;
          ix != ( * ii ) -> lastInitialPassenger () ; ++ ix )
    {
      _pas_e += ( * ix ) -> getPassengerNumber () ;
    }
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * ii ) -> firstPassenger () ;
          ix != ( * ii ) -> lastPassenger () ; ++ ix )
    {
      _pas_s += ( * ix ) -> getPassengerNumber () ;
      _pas_e += ( * ix ) -> getPassengerNumber () ;
    }
    cerr << "Branch \"" << ( * ii ) -> getStartSTN () -> getName ()
         << "\" -> \"" << ( * ii ) -> getEndSTN () -> getName ()
         << "\": " << _pas_s << " -|- " << _pas_e << endl ;
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * ii ) -> firstInitialPassenger () ;
          ix != ( * ii ) -> lastInitialPassenger () ; ++ ix )
    {
      cerr << "  [I] "
           << ( * ix ) -> getStartSTB () -> getStartStationName ()
           << ": [" << ( * ix ) -> getTime () << "/"
           << ( * ix ) -> getCycleDelay () << "] -> "
           << ( * ix ) -> getDestination () -> getName ()
           << ": " << ( * ix ) -> getPassengerNumber () << endl ;
    }
    for ( vector < X_Passengers_F1 const * > :: const_iterator
            ix = ( * ii ) -> firstPassenger () ;
          ix != ( * ii ) -> lastPassenger () ; ++ ix )
    {
      cerr << "  [P] "
           << ( * ix ) -> getStartSTB () -> getStartStationName ()
           << ": [" << ( * ix ) -> getTime () << "/"
           << ( * ix ) -> getCycleDelay () << "] -> "
           << ( * ix ) -> getDestination () -> getName ()
           << ": " << ( * ix ) -> getPassengerNumber () << endl ;
    }
  }
}
