// This may look like C code, but it is really -*- C++ -*-


#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <pcre.h>
#include <unistd.h>
#include <vector>

#include "rtss_path.hh"
#include "Test_TalkingAnimalContainer.hh"

using std :: cin ;
using std :: cout ;
using std :: cerr ;
using std :: endl ;
using std :: string ;
using std :: vector ;
using std :: ostream ;



#ifndef FILENAME_MAX
#define FILENAME_MAX 512	// ファイル名文字列の最大長さ
#endif /* ! FILENAME_MAX */

string current_directory = "" ;
string current_drive = "" ;
bool is_backslash = false ;

double RS_Object :: t_sim = 0 ;
double RS_Object :: delta_t = 0.25 ;


int
main
( int argc ,
  char * argv [] )
{
  RS_XmlReader xread ;
  Test_TalkingAnimalContainer ta_c ;
  xread [ "talking_animal" ] = & ta_c ;

  // -----
  // Get the "current working directory" for this program.
  // 現在のワーキングディレクトリを取得。
  // -----
  char * curpath = getcwd ( NULL , 0 ) ;
  if ( curpath == NULL )
  {
    cerr << "Error: Getting present working directory failed" << endl ;
    exit ( 1 ) ;
  }
  else
  {
    cerr << "CWD: " << curpath << endl ;
  }
  current_directory = curpath ;
  current_drive = "" ;

  // -----
  // Check if the directory is "Windows" style. If windows, then separate the
  // drive name and the file path.
  // ディレクトリ名がウィンドウズスタイルかどうか判定。ウィンドウズなら，ドラ
  // イブ名とディレクトリ部を分離。
  // -----
  RTSS_Path_String check_win_path ( curpath ) ;
  free ( curpath ) ;
  is_backslash = check_win_path . isWindowsStyleFullPath ( current_drive ) ;
  if ( is_backslash )
  {
    current_directory = check_win_path ;
    cerr << "Windows path, dir = " << current_directory << ", drive = "
          << current_drive << "!" << endl ;
  }
  else
  {
    cerr << "Unix path, dir = " << current_directory << ", drive = "
          << current_drive << "!" << endl ;
  }

  // ----
  // There must be at least one command-line argument.
  // コマンド行引数は少なくともひとつ必要。
  // ----
  if ( argc == 1 )
  {
    cerr << "Error: There must be at least one command-line argument."
         << endl ;
    exit ( 1 ) ;
  }

  // -----
  // Assume the command-line arguments are file names, and process them.
  // コマンド行引数はすべてファイル名であると仮定し，処理する。
  // -----
  vector < string > _files ;
  for ( -- argc ; argc ; -- argc )
  {
    RTSS_Path_String control_file ( * ++ argv ) ;
    // -----
    // Filename check (2 and thereafter) ... all processed here.
    // ファイル名チェック(2 以降)… すべてここで.
    // -----
    string controlfiledrive = "" ;
    string controlfiledir = "" ;
    string controlfilename = "" ;
    if ( ! control_file . processPath
         ( is_backslash , current_drive , current_directory ,
           controlfiledrive , controlfiledir , controlfilename ) )
    {
      cerr << "ERROR: unknown error in processPath (control file)" << endl ;
      exit ( 1 ) ;
    }
    current_drive = controlfiledrive ;
    current_directory = controlfiledir ;
    string _fname_in = controlfiledrive ;
    _fname_in += controlfiledir ;
    if ( is_backslash )
    {
      _fname_in += "\\" ;
    }
    else
    {
      _fname_in += "/" ;
    }
    _fname_in += controlfilename ;
    _files . push_back ( _fname_in ) ;
    cerr << "Control file: " << _fname_in << endl << " dir = "
         << current_directory << ", drive = " << current_drive << endl ;
    xread . openXmlDocument ( _fname_in , current_drive , current_directory ) ;
    do
    {
      xread . processElement () ;
    } while ( xread . hasNextElement () ) ;
  }
  cerr << endl << endl << "Read Finished." << endl << endl ;
  while ( 1 ) 
  {
    string key_in ;
    cout << "There are several animals here." << endl
         << "Each of them has a thing to talk to you." << endl
         << "Guess one of their names: " ;
    cin >> key_in ;
    cout << endl ;
    ta_c . talk ( key_in ) ;
    cout << endl << endl << endl ;
  }
}
