// -*- C++ -*-

#ifndef REFLIST2_BOOKENTRY_H
#define REFLIST2_BOOKENTRY_H

#include <iostream>
#include <string>
#include <vector>
#include "tinyxml.h"
#include "reflist2-ReferenceEntry.h"
#include "reflist2-Author.h"
#include "reflist2-YearMonth.h"

using std :: ostream ;
using std :: string ;
using std :: vector ;
using std :: cout ;
using std :: cerr ;
using std :: endl ;



// ----
// Declaration of class BookEntry.
// BookEntry クラスの宣言.
// ----

class BookEntry
  : public ReferenceEntry ,
    public RefEntryExpander
{

  // ******** //
  // Friends  //
  // フレンド //
  // ******** //

  // ----
  // Writing out to stdout.
  // 標準出力への書き出し。
  // ----
  friend ostream & operator<< ( ostream & , const BookEntry & ) ;

  // ************************ //
  // Private member variables //
  // 非公開メンバ変数         //
  // ************************ //

  // ----
  // Title.
  // タイトル。
  // ----
  string title_str ;

  // ----
  // Authors.
  // 著者。
  // ----
  vector < Author * > authors ;

  // ----
  // Publisher.
  // 出版社。
  // ----
  string publisher_str ;

  // ----
  // Address of the publisher.
  // 出版社の住所。
  // ----
  string paddr_str ;

  // ----
  // Year and month of publication.
  // 出版年月。
  // ----
  YearMonth * ym ;

  // ************************ //
  // Private member functions //
  // 非公開メンバ関数         //
  // ************************ //

  // ----
  // Prohibiting the default and the copy constructors.
  // デフォルトコンストラクタとコピーコンストラクタの使用禁止
  // ----
  explicit BookEntry () ;
  explicit BookEntry ( const BookEntry & ) ;

  // ----
  // Writing out to stdout. Pure virtual function.
  // 標準出力への書き出し。純粋仮想関数。
  // ----
  ostream & outputToStream ( ostream & ) const ;

public :

  // *********************** //
  // Public member functions //
  // 公開メンバ関数          //
  // *********************** //

  // ----
  // Constructor. Argument is XMLNodePointer that contains <book_entry>.
  // コンストラクタ。引数は <book_entry> を含む XMLNodePointer.
  // ----
  explicit BookEntry ( const XMLNodePointer & ) ;

  // ----
  // Virtual functions that must be implemented.
  // 実装が必要な仮想関数。
  // ----
  void printAuthors ( ostream & ) const ;
  void printTitle ( ostream & ) const ;
  void printPublishedYearMonth ( ostream & ) const ;
  void printOtherBibInfo ( ostream & ) const ;


  // ----
  // Destructor.
  // デストラクタ。
  // ----
  ~BookEntry () ;

} ;


// ----
// Operator << for writing out the entire BookEntry class object.
// BookEntry クラスオブジェクト全体を書き出すための << 演算子。
// ----
ostream & operator<< ( ostream & , const BookEntry & ) ;



// -----
// Creator of class BookEntry
// BookEntry クラスの Creator.
// -----
class BookEntryCreator
  : public RefEntryExpander :: ObjectCreator
{
public :
  BookEntryCreator () { add_to_creators_list ( "book_entry" ) ; }
  BookEntryCreator ( const char * x )
    : RefEntryExpander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  BookEntry * create () const
  {
    cerr << "Error: BookEntry... default constructor prohibited"
         << endl ;
    exit ( 1 ) ;
  }
  BookEntry * create ( const XMLNodePointer & x ) const
  { return new BookEntry ( x ) ; }
} ;



#endif // REFLIST2_BOOKENTRY_H
