// -*- C++ -*-

#ifndef REFLIST2_JOURNALPAPERENTRY_H
#define REFLIST2_JOURNALPAPERENTRY_H

#include <iostream>
#include <string>
#include <vector>
#include "tinyxml.h"
#include "reflist2-ReferenceEntry.h"
#include "reflist2-Author.h"
#include "reflist2-YearMonth.h"

using std :: ostream ;
using std :: string ;
using std :: vector ;
using std :: cout ;
using std :: cerr ;
using std :: endl ;


// ----
// Declaration of class JournalPaperEntry.
// JournalPaperEntry クラスの宣言.
// ----

class JournalPaperEntry
  : public ReferenceEntry ,
    public RefEntryExpander
{

  // ******** //
  // Friends  //
  // フレンド //
  // ******** //

  // ----
  // Writing out to stdout.
  // 標準出力への書き出し。
  // ----
  friend ostream & operator<< ( ostream & , const JournalPaperEntry & ) ;

  // ************************ //
  // Private member variables //
  // 非公開メンバ変数         //
  // ************************ //

  // ----
  // Title.
  // タイトル。
  // ----
  string title_str ;

  // ----
  // Authors.
  // 著者。
  // ----
  vector < Author * > authors ;

  // ----
  // Journal name.
  // 論文誌名。
  // ----
  string journal_str ;

  // ----
  // Volume and number.
  // 巻号。
  // ----
  int j_vol ;
  int j_num ;

  // ----
  // Start and end pages.
  // 開始・終了ページ。
  // ----
  int page_start ;
  int page_end ;

  // ----
  // Year and month of publication.
  // 出版年月。
  // ----
  YearMonth * ym ;

  // ************************ //
  // Private member functions //
  // 非公開メンバ関数         //
  // ************************ //

  // ----
  // Prohibiting the default and the copy constructors.
  // デフォルトコンストラクタとコピーコンストラクタの使用禁止
  // ----
  explicit JournalPaperEntry () ;
  explicit JournalPaperEntry ( const JournalPaperEntry & ) ;

  // ----
  // Writing out to stdout. Pure virtual function.
  // 標準出力への書き出し。純粋仮想関数。
  // ----
  ostream & outputToStream ( ostream & ) const ;

public :

  // *********************** //
  // Public member functions //
  // 公開メンバ関数          //
  // *********************** //

  // ----
  // Constructor. Argument is XMLNodePointer that contains
  // <journal_paper_entry>.
  // コンストラクタ。引数は <journal_paper_entry> を含む XMLNodePointer.
  // ----
  explicit JournalPaperEntry ( const XMLNodePointer & ) ;

  // ----
  // Virtual functions that must be implemented.
  // 実装が必要な仮想関数。
  // ----
  void printAuthors ( ostream & ) const ;
  void printTitle ( ostream & ) const ;
  void printPublishedYearMonth ( ostream & ) const ;
  void printOtherBibInfo ( ostream & ) const ;


  // ----
  // Destructor.
  // デストラクタ。
  // ----
  ~JournalPaperEntry () ;

} ;


// ----
// Operator << for writing out the entire JournalPaperEntry class object.
// JournalPaperEntry クラスオブジェクト全体を書き出すための << 演算子。
// ----
ostream & operator<< ( ostream & , const JournalPaperEntry & ) ;



// -----
// Creator of class JournalPaperEntry
// JournalPaperEntry クラスの Creator.
// -----
class JournalPaperEntryCreator
  : public RefEntryExpander :: ObjectCreator
{
public :
  JournalPaperEntryCreator () { add_to_creators_list ( "journal_paper_entry" ) ; }
  JournalPaperEntryCreator ( const char * x )
    : RefEntryExpander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  JournalPaperEntry * create () const
  {
    cerr << "Error: JournalPaperEntry... default constructor prohibited"
         << endl ;
    exit ( 1 ) ;
  }
  JournalPaperEntry * create ( const XMLNodePointer & x ) const
  { return new JournalPaperEntry ( x ) ; }
} ;



#endif // REFLIST2_JOURNALPAPERENTRY_H
