// -*- C++ -*-

#ifndef REFLIST2_REFERENCESLIST_H
#define REFLIST2_REFERENCESLIST_H

#include <iostream>
#include <vector>
#include "tinyxml.h"
#include "reflist2-ReferenceEntry.h"

using std :: ostream ;
using std :: vector ;


// ----
// Declaration of class ReferencesList.
// ReferencesList クラスの宣言.
// ----

class ReferencesList
  : public vector < ReferenceEntry * >
{

  // ******** //
  // Friends  //
  // フレンド //
  // ******** //

  // ----
  // Writing out to stdout.
  // 標準出力への書き出し。
  // ----
  friend ostream & operator<< ( ostream & , const ReferencesList & ) ;

  // ************************ //
  // Private member functions //
  // 非公開メンバ関数         //
  // ************************ //

  // ----
  // Prohibiting the default and the copy constructors.
  // デフォルトコンストラクタとコピーコンストラクタの使用禁止
  // ----
  explicit ReferencesList () ;
  explicit ReferencesList ( const ReferencesList & ) ;

public :

  // *********************** //
  // Public member functions //
  // 公開メンバ関数          //
  // *********************** //

  // ----
  // Constructor. Argument is DOM node for tag <references_list>.
  // コンストラクタ。引数は <references_list> タグに対応する DOM ノード。
  // ----
  explicit ReferencesList ( const TiXmlNode * ) ;

  // ----
  // Destructor.
  // デストラクタ。
  // ----
  ~ReferencesList () ;

} ;


// ----
// Operator << for writing out the entire ReferencesList class object.
// ReferencesList クラスオブジェクト全体を書き出すための << 演算子。
// ----
ostream & operator<< ( ostream & , const ReferencesList & ) ;


#endif // REFLIST2_REFERENCESLIST_H
