// -*- C++ -*-

#include <iostream>
#include "reflist2-Author.h"

using std :: ostream ;
using std :: cout ;
using std :: cerr ;
using std :: endl ;



// ----
// Constructor of class Author.
// Author クラスのコンストラクタ.
// ----
Author :: Author
( const TiXmlNode * n_in )
  : title_str () ,
    firstname_str () ,
    familyname_str ()
{
  // ----
  // Search for children nodes. Actually there must be no ELEMENT child node.
  // 子ノードを探索。実際には子ノード中に ELEMENT ノードはあってはならない。
  // ----
  for ( const TiXmlNode * n_ch = n_in -> FirstChild () ;
        n_ch ; n_ch = n_ch -> NextSibling () )
  {
    if ( n_ch -> Type () != TiXmlNode :: ELEMENT )
    {
      continue ;
    }
    cerr << "Error: no child element is allowed in <author> tag." << endl ;
    exit ( 1 ) ;
  }

  bool sw_t = false ;
  bool sw_g = false ;
  bool sw_f = false ;
  for ( const TiXmlAttribute * t_a
          = n_in -> ToElement () -> FirstAttribute () ;
        t_a ; t_a = t_a -> Next () )
  {
    if ( string ( t_a -> Name () ) == "atitle" )
    {
      if ( sw_t )
      {
        cerr << "Error: duplicate \"atitle\" attribute to tag <author>"
             << "... internal error?" << endl ;
        exit ( 1 ) ;
      }
      sw_t = true ;
      title_str = t_a -> ValueStr () ;
    }
    else if ( string ( t_a -> Name () ) == "firstname" )
    {
      if ( sw_g )
      {
        cerr << "Error: duplicate \"firstname\" attribute to tag <author>"
             << "... internal error?" << endl ;
        exit ( 1 ) ;
      }
      sw_g = true ;
      firstname_str = t_a -> ValueStr () ;
    }
    else if ( string ( t_a -> Name () ) == "familyname" )
    {
      if ( sw_f )
      {
        cerr << "Error: duplicate \"familyname\" attribute to tag <author>"
             << "... internal error?" << endl ;
        exit ( 1 ) ;
      }
      sw_f = true ;
      familyname_str = t_a -> ValueStr () ;
    }
    else
    {
      cerr << "Error: attribute \"" << t_a -> Name ()
           << "\" not allowed in tag <author>" << endl ;
      exit ( 1 ) ;
    }
  }
}



// ----
// Get full name.
// フルネームを得る。
// ----
string
Author :: getFullName
()
  const
{
  return title_str + string ( " " ) + firstname_str + string ( " " )
    + familyname_str ;
}


// ----
// Writing out contents of class Author.
// Author クラスの内容の書き出し。
// ----
ostream &
operator<<
( ostream & str_out ,
  const Author & rl_out )
{
  str_out << rl_out . getFullName () ;
  return str_out ;
}
