// -*- C++ -*-

#ifndef REFLIST2_AUTHOR_H
#define REFLIST2_AUTHOR_H

#include <iostream>
#include <string>
#include "tinyxml.h"

using std :: ostream ;
using std :: string ;


// ----
// Declaration of class Author.
// Author クラスの宣言.
// ----
class Author
{

  // ******** //
  // Friends  //
  // フレンド //
  // ******** //

  // ----
  // Writing out to stdout.
  // 標準出力への書き出し。
  // ----
  friend ostream & operator<< ( ostream & , const Author & ) ;

  // ************************ //
  // Private member variables //
  // 非公開メンバ変数         //
  // ************************ //
  string title_str ;
  string firstname_str ;
  string familyname_str ;

  // ************************ //
  // Private member functions //
  // 非公開メンバ関数         //
  // ************************ //

  // ----
  // Prohibiting the default and the copy constructors.
  // デフォルトコンストラクタとコピーコンストラクタの使用禁止
  // ----
  explicit Author () ;
  explicit Author ( const Author & ) ;

public :

  // *********************** //
  // Public member functions //
  // 公開メンバ関数          //
  // *********************** //

  // ----
  // Constructor. Argument is const TiXmlNode * that contains <author>.
  // コンストラクタ。引数は <author> を含む const TiXmlNode *.
  // ----
  explicit Author ( const TiXmlNode * ) ;

  // ----
  // Returns the full name as a string.
  // フルネームを string 型として返す。
  // ----
  string getFullName () const ;

} ;



// ----
// Operator << for writing out the entire Author class object.
// Author クラスオブジェクト全体を書き出すための << 演算子。
// ----
ostream & operator<< ( ostream & , const Author & ) ;



#endif // REFLIST2_AUTHOR_H
