// -*- C++ -*-

#ifndef REFLIST2_REFERENCEENTRY_H
#define REFLIST2_REFERENCEENTRY_H

#include <iostream>
#include <vector>
#include "tinyxml.h"
#include "reflist2-ReferenceEntry.h"
#include "Expandable.h"

using std :: ostream ;
using std :: vector ;


// ----
// Declaration of abstract class ReferenceEntry.
// 抽象クラス ReferenceEntry の宣言.
// ----

class ReferenceEntry
{

  // ******** //
  // Friends  //
  // フレンド //
  // ******** //

  // ----
  // Writing out to stdout.
  // 標準出力への書き出し。
  // ----
  friend ostream & operator<< ( ostream & , const ReferenceEntry & ) ;

  // ************************ //
  // Private member functions //
  // 非公開メンバ関数         //
  // ************************ //

  // ----
  // Writing out to stdout. Pure virtual function.
  // 標準出力への書き出し。純粋仮想関数。
  // ----
  virtual ostream & outputToStream ( ostream & ) const = 0 ;

public :

  // *********************** //
  // Public member functions //
  // 公開メンバ関数          //
  // *********************** //

  virtual void printAuthors ( ostream & ) const = 0 ;
  virtual void printTitle ( ostream & ) const = 0 ;
  virtual void printPublishedYearMonth ( ostream & ) const = 0 ;
  virtual void printOtherBibInfo ( ostream & ) const = 0 ;

  virtual ~ReferenceEntry () {}

} ;



// ----
// Operator << for writing out the entire ReferenceEntry class object.
// ReferenceEntry クラスオブジェクト全体を書き出すための << 演算子。
// ----
ostream & operator<< ( ostream & , const ReferenceEntry & ) ;



// ----
// Define XMLNodePointer as typedef of const TiXmlNode *.
// const TiXmlNode * の typedef として XMLNodePointer を定義
// ----
typedef const TiXmlNode * XMLNodePointer ;



// ----
// Define RefEntryExpander as a typedef.
// RefEntryExpander を typedef で定義。
// ----
typedef Expandable < ReferenceEntry , XMLNodePointer > RefEntryExpander ;



#endif // REFLIST2_REFERENCEENTRY_H
