// -*- C++ -*-

#include <iostream>
#include <sstream>
#include "reflist2-YearMonth.h"

using std :: ostream ;
using std :: istringstream ;
using std :: ostringstream ;
using std :: cout ;
using std :: cerr ;
using std :: endl ;



// ----
// Constructor of class YearMonth.
// YearMonth クラスのコンストラクタ.
// ----
YearMonth :: YearMonth
( const TiXmlNode * n_in )
  : year_i ( 0 ) ,
    month_i ( 0 )
{
  // ----
  // Search for children nodes. Actually there must be no ELEMENT child node.
  // 子ノードを探索。実際には子ノード中に ELEMENT ノードはあってはならない。
  // ----
  for ( const TiXmlNode * n_ch = n_in -> FirstChild () ;
        n_ch ; n_ch = n_ch -> NextSibling () )
  {
    if ( n_ch -> Type () != TiXmlNode :: ELEMENT )
    {
      continue ;
    }
    cerr << "Error: no child element is allowed in <author> tag." << endl ;
    exit ( 1 ) ;
  }

  bool sw_y = false ;
  bool sw_m = false ;
  for ( const TiXmlAttribute * t_a
          = n_in -> ToElement () -> FirstAttribute () ;
        t_a ; t_a = t_a -> Next () )
  {
    if ( string ( t_a -> Name () ) == "year" )
    {
      if ( sw_y )
      {
        cerr << "Error: duplicate \"year\" attribute to tag <year_month>"
             << "... internal error?" << endl ;
        exit ( 1 ) ;
      }
      sw_y = true ;
      istringstream iss_y ( t_a -> ValueStr () ) ;
      iss_y >> year_i ;
    }
    else if ( string ( t_a -> Name () ) == "month" )
    {
      if ( sw_m )
      {
        cerr << "Error: duplicate \"month\" attribute to tag <author>"
             << "... internal error?" << endl ;
        exit ( 1 ) ;
      }
      sw_m = true ;
      istringstream iss_m ( t_a -> ValueStr () ) ;
      iss_m >> month_i ;
      if ( month_i <= 0 || month_i > 12 )
      {
        cerr << "Error: month should be between 1 and 12" << endl ;
        exit ( 1 ) ;
      }
    }
    else
    {
      cerr << "Error: attribute \"" << t_a -> Name ()
           << "\" not allowed in tag <year_month>" << endl ;
      exit ( 1 ) ;
    }
  }
  if ( ! ( sw_y && sw_m ) )
  {
    cerr << "Error: not all attributes are specified in tag "
         << "<volume_number>" << endl ;
    exit ( 1 ) ;
  }
}



// ----
// Get "Month Year" string, such as June 2008.
// "June 2008" のような「月 年」文字列を得る。
// ----
string
YearMonth :: getMonthYearString
()
  const
{
  string x = "" ;
  switch ( month_i )
  {
  case 1 :
    x += "January " ; break ;
  case 2 :
    x += "February " ; break ;
  case 3 :
    x += "March " ; break ;
  case 4 :
    x += "April " ; break ;
  case 5 :
    x += "May " ; break ;
  case 6 :
    x += "June " ; break ;
  case 7 :
    x += "July " ; break ;
  case 8 :
    x += "August " ; break ;
  case 9 :
    x += "September " ; break ;
  case 10 :
    x += "October " ; break ;
  case 11 :
    x += "November " ; break ;
  case 12 :
    x += "December " ; break ;
  default :
    cerr << "Error: month not correct ... internal error" << endl ;
    exit ( 1 ) ;
  }
  ostringstream y ;
  y << year_i ;
  return x + y . str () ;
}
// ----
// Writing out contents of class YearMonth.
// YearMonth クラスの内容の書き出し。
// ----
ostream &
operator<<
( ostream & str_out ,
  const YearMonth & rl_out )
{
  str_out << rl_out . getMonthYearString () ;
  return str_out ;
}
