// -*- C++ -*-

#ifndef REFLIST2_YEARMONTH_H
#define REFLIST2_YEARMONTH_H

#include <iostream>
#include <string>
#include "tinyxml.h"

using std :: ostream ;
using std :: string ;


// ----
// Declaration of class YearMonth.
// YearMonth クラスの宣言.
// ----
class YearMonth
{

  // ******** //
  // Friends  //
  // フレンド //
  // ******** //

  // ----
  // Writing out to stdout.
  // 標準出力への書き出し。
  // ----
  friend ostream & operator<< ( ostream & , const YearMonth & ) ;

  // ************************ //
  // Private member variables //
  // 非公開メンバ変数         //
  // ************************ //
  int year_i ;
  int month_i ;

  // ************************ //
  // Private member functions //
  // 非公開メンバ関数         //
  // ************************ //

  // ----
  // Prohibiting the default and the copy constructors.
  // デフォルトコンストラクタとコピーコンストラクタの使用禁止
  // ----
  explicit YearMonth () ;
  explicit YearMonth ( const YearMonth & ) ;

public :

  // *********************** //
  // Public member functions //
  // 公開メンバ関数          //
  // *********************** //

  // ----
  // Constructor. Argument is const TiXmlNode * that contains <author>.
  // コンストラクタ。引数は <author> を含む const TiXmlNode *.
  // ----
  explicit YearMonth ( const TiXmlNode * ) ;

  // ----
  // Get "Month Year" string, such as June 2008.
  // "June 2008" のような「月 年」文字列を得る。
  // ----
  string getMonthYearString () const ;

} ;



// ----
// Operator << for writing out the entire YearMonth class object.
// YearMonth クラスオブジェクト全体を書き出すための << 演算子。
// ----
ostream & operator<< ( ostream & , const YearMonth & ) ;


#endif // REFLIST2_YEARMONTH_H
