// -*- C++ -*-

#include <iostream>
#include <string>
#include <cstdlib>
#include "tinyxml.h"
#include "reflist2-ReferencesList.h"

using std :: cout ;
using std :: cerr ;
using std :: endl ;
using std :: string ;


// The name of the XML file to be read
const char * XML_file_name = "references-list.xml" ;


void
printUsage
( const char * argzero )
{
  cerr << "Usage:" << endl << " " << argzero << endl
       << " No command line arguments allowed." << endl ;
}


int
main
( int argc ,
  char * * argv )
{
  if ( argc != 1 )
  {
    cerr << "Error: too many arguments." << endl ;
    printUsage ( argv [ 0 ] ) ;
    return 1 ;
  }

  TiXmlDocument doc ( XML_file_name ) ;
  bool loadOkay = doc . LoadFile () ;
  if ( ! loadOkay )
  {
    cerr << "Failed to load file \"" << XML_file_name << "\"" << endl ;
    exit ( 1 ) ;
  }

  // -----
  // The file must have one "root" element of tag <references_list>.
  // If multiple <references_list> tags exist, only the first one is read.
  // このXMLファイルには <references_list> というタグがなければならない。
  // <references_list> タグが複数あれば最初のだけを読む。
  // -----
  const TiXmlNode * doc_ch = doc . FirstChild () ;
  while ( doc_ch && doc_ch -> Type () != TiXmlNode :: ELEMENT )
  {
    doc_ch = doc_ch -> NextSibling () ;
  }

  // -----
  // If the file is correct, doc_ch must now be the first ELEMENT node.
  // Now verify if this is of tag <references_list>.
  // XMLファイルが正しければ，doc_ch は最初の ELEMENT（要素）ノードを指してい
  // るはずである。これがほんとうに <references_list> タグのノードか確認する。
  // -----
  if ( ! doc_ch || doc_ch -> Type () != TiXmlNode :: ELEMENT
       || string ( doc_ch -> Value () ) != "references_list" )
  {
    cerr << "Error: failed to find element \"references_list\""
         << " in file \"" << XML_file_name << "\"." << endl ;
    exit ( 1 ) ;
  }

  // -----
  // Initialise a ReferencesList object using this verified doc_ch.
  // 正しいことを確認した doc_ch で ReferencesList クラスを初期化する。
  // -----
  ReferencesList * x = new ReferencesList ( doc_ch ) ;
  cout << "Created a ReferencesList object." << endl << ( * x ) << endl ;
  
  exit ( 0 ) ;
}
