// -*- C++ -*-

#include <iostream>
#include <cstdlib>
#include <vector>
#include <string>
#include "reflist2-ReferencesList.h"

using std :: ostream ;
using std :: vector ;
using std :: cerr ;
using std :: endl ;
using std :: string ;


// ----
// Constructor of class ReferencesList.
// ReferencesList クラスのコンストラクタ.
// ----
ReferencesList :: ReferencesList
( const TiXmlNode * n_in )
{
  for ( const TiXmlNode * n_ch = n_in -> FirstChild () ;
        n_ch ; n_ch = n_ch -> NextSibling () )
  {
    if ( n_ch -> Type () != TiXmlNode :: ELEMENT )
    {
      continue ;
    }
    if ( string ( n_ch -> Value () ) != "reference_entry" )
    {
      cerr << "Error: tags other than <reference_entry> not allowed as "
           << "children of <references_list>" << endl ;
      exit ( 1 ) ;
    }
    bool sw_end = false ;
    for ( const TiXmlNode * n_gc = n_ch -> FirstChild () ;
          n_gc ; n_gc = n_gc -> NextSibling () )
    {
      if ( n_ch -> Type () != TiXmlNode :: ELEMENT )
      {
        continue ;
      }
      if ( sw_end )
      {
        cerr << "Error: two or more tags not allowed within <reference_entry>"
             << endl ;
        exit ( 1 ) ;
      }
      sw_end = true ;
      ReferenceEntry * x
        = RefEntryExpander :: create ( string ( n_gc -> Value () ) , n_gc ) ;
      push_back ( x ) ;
    }
  }
}


// ----
// Writing out contents of class ReferencesList.
// ReferencesList クラスの内容の書き出し。
// ----
ostream &
operator<<
( ostream & str_out ,
  const ReferencesList & rl_out )
{
  ReferencesList :: size_type rl_size = rl_out . size () ;
  if ( rl_size == 0 )
  {
    str_out << "ReferencesList : No entry." << endl ;
  }
  else
  {
    str_out << "ReferencesList : " << rl_size ;
    if ( rl_size == 1 )
    {
      str_out << " entry." << endl ;
    }
    else
    {
      str_out << " entries." << endl ;
    }
    int i = 0 ;
    for ( ReferencesList :: const_iterator ii = rl_out . begin () ;
          ii != rl_out . end () ; ++ ii )
    {
      ++ i ;
      str_out << "[" << i << "] " << ( * ( * ii ) ) ;
    }
  }
  return str_out ;
}



// ----
// Destructor of class ReferencesList.
// ReferencesList クラスのデストラクタ.
// ----
ReferencesList :: ~ReferencesList
()
{
  for ( ReferencesList :: iterator ii = begin () ;
        ii != end () ; ++ ii )
  {
    delete ( * ii ) ;
  }
}
