// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// RS_Object.cpp --- class RS_XmlReader functions
// -----
// ChangeLog:
// 2009. 7. 10
//  File created.
// -----

#include "RS_Object.h"
#include <cstdlib>
#include <vector>

using std :: cerr ;
using std :: endl ;
using std :: vector ;



/**********************************************************************
 * RS_ObjectContainer :: locate ( const string & key_in )
 * : locates an object.
 *  key_in : key to the object.
 **********************************************************************/
RS_Object const *
RS_ObjectContainer :: locate
( string const & x )
const
{
  map < string , RS_Object * > :: const_iterator ii = this -> find ( x ) ;
  if ( ii == this -> end () )
  {
    return 0 ;
  }
  return ii -> second ;
}

RS_Object *
RS_ObjectContainer :: locate
( string const & x )
{
  map < string , RS_Object * > :: iterator ii = this -> find ( x ) ;
  if ( ii == this -> end () )
  {
    return 0 ;
  }
  return ii -> second ;
}
