// This may look like C code, but it is really -*- C++ -*-


#include "Test_TalkingAnimalContainer.h"

using std :: cerr ;
using std :: endl ;
using std :: cin ;



bool
Test_TalkingAnimalContainer :: create
( TiXmlNode const * & _n_in ,
  vector < string > const & _s_in ,
  vector < RS_Object * > const & _o_in )
{
  string xxx = getClassString ( _n_in ) ;
  string yyy = getNameString ( _n_in ) ;
  Test_TalkingAnimal * x = TA_Expander :: create ( xxx , _n_in ) ;
  ( * this ) [ yyy ] = x ;
  vector < string > :: const_iterator ii = _s_in . begin () ;
  vector < RS_Object * > :: const_iterator jj = _o_in . begin () ;
  while ( ii < _s_in . end () || jj < _o_in . end () )
  {
    if ( x -> acceptInitObject ( * ii , * jj ) )
    {
      ++ ii ;
      ++ jj ;
    }
    else
    {
      cerr << "Error: acceptInitObject failed, type = "
           << * ii << endl ;
      exit ( 1 ) ;
    }
  }
  return true ;
}



void
Test_TalkingAnimalContainer :: talk
( const string & _k_in )
{
  string key_in = _k_in ;
  string key_orig = _k_in ;
  RS_Object * x = this -> locate ( key_in ) ;
  if ( ! x )
  {
    cout << "Oops, your guess was wrong." << endl
         << "Could not find any animal named \"" << _k_in << "\" here."
         << endl ;
    return ;
  }
  Test_TalkingAnimal const *
    xa = dynamic_cast < Test_TalkingAnimal * > ( x ) ;
  if ( ! xa )
  {
    cerr << "Error: dynamic cast failed." << endl ;
    exit ( 1 ) ;
  }
  while ( xa )
  {
    cout << "Hello, this is " << xa -> getName () << " speaking!" << endl
         << "Please listen to what I have to say:" << endl << endl
         << "********" << endl << "  " ;
    xa -> talk () ;
    cout << "********" << endl ;
    if ( xa -> hasSibling () )
    {
      cout << endl << "By the way, I have " ;
      if ( xa -> hasSiblings () )
      {
        cout << "siblings. Guess one of their names: " ;
      }
      else
      {
        cout << "a sibling. Guess his/her name: " ;
      }
      key_orig = key_in ;
      cin >> key_in ;
      cout << endl << endl ;
      xa = xa -> locateSibling ( key_in ) ;
      if ( ! xa )
      {
        cout << "Oops, your guess was wrong." << endl
             << "Could not find any sibling named \"" << key_in
             << "\" here." << endl << endl ;
        key_in = key_orig ;
      }
    }
    else
    {
      cout << endl << "By the way, I have no siblings." << endl << endl ;
      xa = 0 ;
    }
  }
  cout << "Goodbye from " << key_in << ". See you soon!" << endl << endl ;
  return ;
}
