// This may look like C code, but it is really -*- C++ -*-


#include "Test_TalkingAnimals.h"
#include <cstdlib>

using std :: cerr ;
using std :: endl ;



Test_TalkingAnimal :: Test_TalkingAnimal
( TiXmlNode const * const & curnode )
  : siblings ()
{
  if ( ! curnode )
  {
    cerr << "Error: node not set in Test_TalkingAnimal constructor."
         << endl ;
    exit ( 1 ) ;
  }
  if ( curnode -> ValueStr () != "data" )
  {
    cerr << "Error: <" << curnode -> ValueStr ()
         << "> tag not allowed in Test_TalkingAnimal constructor." << endl ;
    exit ( 1 ) ;
  }
  const TiXmlAttribute * attr = curnode -> ToElement () -> FirstAttribute () ;
  bool sw_talk = false ;
  bool sw_name = false ;
  while ( attr )
  {
    if ( string ( attr -> Name () ) == "name" )
    {
      // Attribute "name"
      if ( sw_name )
      {
        // Strange ... two attributes of same name?
        // 同じ属性が2つある？... エラー
        cerr << "Error: two \"name\" attributes?" << endl ;
        exit ( 2 ) ;
      }
      setName ( attr -> ValueStr () ) ;
      sw_name = true ;
    }
    else if ( string ( attr -> Name () ) == "text" )
    {
      // Attribute "text"
      if ( sw_talk )
      {
        // Strange ... two attributes of same name?
        // 同じ属性が2つある？... エラー
        cerr << "Error: two \"text\" attributes?" << endl ;
        exit ( 2 ) ;
      }
      setTalk ( attr -> ValueStr () ) ;
      sw_talk = true ;
    }
    attr = attr -> Next () ;
  }
  if ( ! ( sw_talk && sw_name ) )
  {
    cerr << "Error: <data> tag without attribute \"name\" or \"text\"."
         << endl ;
    exit ( 1 ) ;
  }
}



bool
Test_TalkingAnimal :: acceptInitObject
( string const & _type_in ,
  RS_Object * _obj_in )
{
  if ( _type_in != "sibling" )
  {
    cerr << "Error: <using> tag with incorrect type \"" << _type_in
         << "\", not accepted by Test_TalkikngAnimal object." << endl ;
    exit ( 1 ) ;
  }
  Test_TalkingAnimal const * _ta_obj
    = dynamic_cast < Test_TalkingAnimal * > ( _obj_in ) ;
  if ( ! _ta_obj )
  {
    cerr << "Error: dynamic cast failed in acceptInitObject, type = \""
         << _type_in << "\"." << endl ;
    exit ( 1 ) ;
  }
  siblings [ _ta_obj -> getName () ] = _ta_obj ;
  return true ;
}


Test_TalkingAnimal const *
Test_TalkingAnimal :: locateSibling
( string const & key_in )
  const
{
  map < string , Test_TalkingAnimal const * > :: const_iterator
    ii = siblings . find ( key_in ) ;
  if ( ii == siblings . end () )
  {
    return 0 ;
  }
  else
  {
    return ii -> second ;
  }
}

