// -*- C++ -*-

#include <string>
#include <iostream>
#include "RS_Object.h"
#include "RS_XmlReader.h"
#include "Expandable.h"
#include "tinyxml.h"

using std :: string ;
using std :: cout ;
using std :: endl ;


// -----
// Base class of "talking animals". Pure virtual.
// ubv̊NXBzB
// -----
class Test_TalkingAnimal
  : public virtual RS_Object
{

private :
  explicit Test_TalkingAnimal () ;
  void setTalk ( const string & x ) { _talk = x ; }
  map < string , Test_TalkingAnimal const * > siblings ;

protected :
  string _talk ;

public :
  explicit Test_TalkingAnimal ( TiXmlNode const * const & ) ;
  virtual void talk () const = 0 ;
  virtual ~Test_TalkingAnimal () {}

  // Overriding a virtual function defined in base class RS_Object
  bool acceptInitObject ( string const & , RS_Object * ) ;

  // returns true if there are siblings
  bool hasSibling () const { return ( siblings . size () ) ; }
  bool hasSiblings () const { return ( siblings . size () > 1 ) ; }

  // Locate a sibling.
  Test_TalkingAnimal const * locateSibling ( string const & ) const ;
  
} ;


typedef Expandable < Test_TalkingAnimal , TiXmlNode const * > TA_Expander ;


// -----
// "Talking dogs".
// ubvB
// -----
class Test_TalkingDog
  : public Test_TalkingAnimal ,
    public TA_Expander
{
  explicit Test_TalkingDog () ;
public :
  explicit Test_TalkingDog ( TiXmlNode const * const & x )
    : Test_TalkingAnimal ( x ) {}
  
  void talk () const { cout << _talk << " BOW, WOW!" << endl ; }
  ~Test_TalkingDog () {}
} ;


// -----
// Creator of class Test_TalkingDog.
// Test_TalkingDog NX Creator.
// -----
class Test_TalkingDog_Creator
  : public TA_Expander :: ObjectCreator
{
public :
  Test_TalkingDog_Creator ()
  { add_to_creators_list ( "talking_dog" ) ; }
  Test_TalkingDog_Creator ( const char * x )
    : TA_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  Test_TalkingAnimal * create () const
  {
    cerr << "Error: Test_TalkingDog... default constructor prohibited"
         << endl ;
    exit ( 1 ) ;
  }
  Test_TalkingAnimal * create ( TiXmlNode const * const & x ) const
  { return new Test_TalkingDog ( x ) ; }
} ;


// -----
// "Talking humans".
// ublԁvB
// -----
class Test_TalkingHuman
  : public Test_TalkingAnimal ,
    public TA_Expander
{
  explicit Test_TalkingHuman () ;
public :
  explicit Test_TalkingHuman ( TiXmlNode const * const & x )
    : Test_TalkingAnimal ( x ) {}
  void talk () const { cout << _talk << " HA, HA, HA!" << endl ; }
  ~Test_TalkingHuman () {}
} ;


// -----
// Creator of class Test_TalkingHuman.
// Test_TalkingHuman NX Creator.
// -----
class Test_TalkingHuman_Creator
  : public TA_Expander :: ObjectCreator
{
public :
  Test_TalkingHuman_Creator ()
  { add_to_creators_list ( "talking_human" ) ; }
  Test_TalkingHuman_Creator ( const char * x )
    : TA_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  Test_TalkingAnimal * create () const
  {
    cerr << "Error: Test_TalkingHuman... default constructor prohibited"
         << endl ;
    exit ( 1 ) ;
  }
  Test_TalkingAnimal * create ( TiXmlNode const * const & x ) const
  { return new Test_TalkingHuman ( x ) ; }
} ;



// -----
// "Talking cats".
// ubLvB
// -----
class Test_TalkingCat
  : public Test_TalkingAnimal ,
    public TA_Expander
{
  explicit Test_TalkingCat () ;
public :
  explicit Test_TalkingCat ( TiXmlNode const * const & x )
    : Test_TalkingAnimal ( x ) {}
  
  void talk () const { cout << _talk << " MIAOW!" << endl ; }
  ~Test_TalkingCat () {}
} ;


// -----
// Creator of class Test_TalkingCat.
// Test_TalkingCat NX Creator.
// -----
class Test_TalkingCat_Creator
  : public TA_Expander :: ObjectCreator
{
public :
  Test_TalkingCat_Creator ()
  { add_to_creators_list ( "talking_cat" ) ; }
  Test_TalkingCat_Creator ( const char * x )
    : TA_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  Test_TalkingAnimal * create () const
  {
    cerr << "Error: Test_TalkingCat... default constructor prohibited"
         << endl ;
    exit ( 1 ) ;
  }
  Test_TalkingAnimal * create ( TiXmlNode const * const & x ) const
  { return new Test_TalkingCat ( x ) ; }
} ;
