// This may look like C code, but it is really -*- C++ -*-


#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <pcre.h>
#include <unistd.h>
#include <vector>

#include "RTSS_Path_String.h"
#include "Test_TalkingAnimalContainer.h"

using std :: cin ;
using std :: cout ;
using std :: cerr ;
using std :: endl ;
using std :: string ;
using std :: vector ;
using std :: ostream ;



#ifndef FILENAME_MAX
#define FILENAME_MAX 512	// ե̾ʸκĹ
#endif /* ! FILENAME_MAX */

string current_directory = "" ;
string current_drive = "" ;
bool is_backslash = false ;

double RS_Object :: t_sim = 0 ;
double RS_Object :: delta_t = 0.25 ;


int
main
( int argc ,
  char * argv [] )
{
  RS_XmlReader xread ;
  Test_TalkingAnimalContainer ta_c ;
  xread [ "talking_animal" ] = & ta_c ;

  // -----
  // Get the "current working directory" for this program.
  // ߤΥ󥰥ǥ쥯ȥ
  // -----
  char curpath [ PATH_MAX ] ;

  if ( getcwd ( curpath , PATH_MAX ) == NULL )
  {
    cerr << "Error: Getting present working directory failed" << endl ;
    exit ( 1 ) ;
  }
  else
  {
    cerr << "CWD: " << curpath << endl ;
  }
  current_directory = curpath ;
  current_drive = "" ;

  // -----
  // Check if the directory is "Windows" style. If windows, then separate the
  // drive name and the file path.
  // ǥ쥯ȥ̾ɥ뤫ɤȽꡣɥʤ顤ɥ
  // ̾ȥǥ쥯ȥʬΥ
  // -----
  RTSS_Path_String check_win_path ( curpath ) ;
  is_backslash = check_win_path . isWindowsStyleFullPath ( current_drive ) ;
  if ( is_backslash )
  {
    current_directory = check_win_path ;
    cerr << "Windows path, dir = " << current_directory << ", drive = "
          << current_drive << "!" << endl ;
  }
  else
  {
    cerr << "Unix path, dir = " << current_directory << ", drive = "
          << current_drive << "!" << endl ;
  }

//   char za [] = "-g" ;
//   char zb [ FILENAME_MAX ] ;

  // ----
  // There must be at least one command-line argument.
  // ޥɹ԰ϾʤȤҤȤɬס
  // ----
  if ( argc == 1 )
  {
    cerr << "Error: There must be at least one command-line argument."
         << endl ;
    exit ( 1 ) ;
  }

  // -----
  // Assume the command-line arguments are file names, and process them.
  // ޥɹ԰Ϥ٤ƥե̾ǤȲꤷ롣
  // -----
  vector < string > _files ;
  for ( -- argc ; argc ; -- argc )
  {
    RTSS_Path_String control_file ( * ++ argv ) ;
    // -----
    // Filename check (2 and thereafter) ... all processed here.
    // ե̾å(2 ʹ) ٤Ƥ.
    // -----
    string controlfiledrive = "" ;
    string controlfiledir = "" ;
    string controlfilename = "" ;
    if ( ! control_file . processPath
         ( is_backslash , current_drive , current_directory ,
           controlfiledrive , controlfiledir , controlfilename ) )
    {
      cerr << "ERROR: unknown error in processPath (control file)" << endl ;
      exit ( 1 ) ;
    }
    current_drive = controlfiledrive ;
    current_directory = controlfiledir ;
    string _fname_in = controlfiledrive ;
    _fname_in += controlfiledir ;
    if ( is_backslash )
    {
      _fname_in += "\\" ;
    }
    else
    {
      _fname_in += "/" ;
    }
    _fname_in += controlfilename ;
    _files . push_back ( _fname_in ) ;
    cerr << "Control file: " << _fname_in << endl << " dir = "
         << current_directory << ", drive = " << current_drive << endl ;
    xread . openXmlDocument ( _fname_in , current_drive , current_directory ) ;
    do
    {
      xread . processElement () ;
    } while ( xread . hasNextElement () ) ;
  }
  cerr << endl << endl << "Read Finished." << endl << endl ;
  while ( 1 ) 
  {
    string key_in ;
    cout << "There are several animals here." << endl
         << "Each of them has a thing to talk to you." << endl
         << "Guess one of their names: " ;
    cin >> key_in ;
    cout << endl ;
    ta_c . talk ( key_in ) ;
    cout << endl << endl << endl ;
  }
}
