// -*- C++ -*-

// ダイクストラ法のデモ

#include "RS_FHeap.hh"
#include "RS_Dijkstra.hh"

#include <cstdlib>
#include <iostream>
#include <sstream>
#include <vector>
#include <algorithm>
#include <string>

using std :: cin ;
using std :: ostream ;
using std :: ostringstream ;
using std :: string ;
using std :: sort ;



const int LARGENUM = 10000 ;


const bool DEP = true ;
const bool ARR = false ;


class Sujic_Weight
{
  int _time ;
  int _transfers ;
  int _time_walk ;
  int _time_wait ;

public :

  Sujic_Weight ()
    : _time ( 0 ) ,
      _transfers ( 0 ) ,
      _time_walk ( 0 ) ,
      _time_wait ( 0 ) {}

  Sujic_Weight ( int _t, int _tf , int _twk , int _twt )
    : _time ( _t ) ,
      _transfers ( _tf ) ,
      _time_walk ( _twk ) ,
      _time_wait ( _twt ) {}
  
  Sujic_Weight ( Sujic_Weight const & x )
    : _time ( x . _time ) ,
      _transfers ( x . _transfers ) ,
      _time_walk ( x . _time_walk ) ,
      _time_wait ( x . _time_wait ) {}

  friend ostream & operator<< ( ostream & , Sujic_Weight const & ) ;
  friend bool operator< ( Sujic_Weight const & , Sujic_Weight const & ) ;
  friend Sujic_Weight operator+
  ( Sujic_Weight const & , Sujic_Weight const & ) ;

  Sujic_Weight & operator+= ( Sujic_Weight const & ) ;

} ;


ostream &
operator<<
( ostream & out ,
  Sujic_Weight const & x )
{
  out << x . _time << "(" << x . _transfers << "/" << x . _time_walk
      << "/" << x . _time_wait << ")" ;
  return out ;
}


bool
operator<
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  if ( x . _time < y . _time )
  {
    return true ;
  }
  else if ( x . _time == y . _time )
  {
    if ( x . _transfers < y . _transfers )
    {
      return true ;
    }
    else if ( x . _transfers == y . _transfers )
    {
      if ( x . _time_walk < y . _time_walk )
      {
        return true ;
      }
      else if ( x . _time_walk == y . _time_walk )
      {
        if ( x . _time_wait < y . _time_wait )
        {
          return true ;
        }
        else
        {
          return false ;
        }
      }
      else
      {
        return false ;
      }
    }
    else
    {
      return false ;
    }
  }
  else
  {
    return false ;
  }
}



Sujic_Weight
operator+
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  return Sujic_Weight
    ( x . _time + y . _time ,
      x . _transfers + y . _transfers ,
      x . _time_walk + y . _time_walk ,
      x . _time_wait + y . _time_wait ) ;
}


Sujic_Weight &
Sujic_Weight :: operator+=
( Sujic_Weight const & x )
{
  _time += x . _time ;
  _transfers += x . _transfers ;
  _time_walk += x . _time_walk ;
  _time_wait += x . _time_wait ;
  return * this ;
}



class X_Train ;
class X_Station ;


class X_SpaceTimeNode
{
  bool _dep ;               // true if departing
  int _t_ ;                 // Time (of arrival or departure)
  X_Train const * _trn ;    // Train
  X_Station const * _sta ;  // Station

public :
  explicit X_SpaceTimeNode
  ( bool _dep_in , int _t_in , X_Train * _trn_in )
    : _dep ( _dep_in ) , _t_ ( _t_in ) , _trn ( _trn_in ) ,
      _sta ( 0 ) {}

  X_SpaceTimeNode ( X_SpaceTimeNode const & x )
    : _dep ( x . _dep ) , _t_ ( x . _t_ ) , _trn ( x . _trn ) ,
      _sta ( x . _sta ) {}

  X_SpaceTimeNode & operator= ( X_SpaceTimeNode const & x )
  { if ( & x == this ) return * this ;
    _dep = x . _dep ; _t_ = x . _t_ ; _trn = x . _trn ; _sta = x . _sta ;
    return * this ; }

  bool isDeparting () const { return _dep ; }
  int getTime () const { return _t_ ; }

  void setStation ( X_Station const * x ) { _sta = x ; }

  string getName () const ;
} ;


class LessSTN
{
public :
  bool operator() ( X_SpaceTimeNode const * _l ,
                    X_SpaceTimeNode const * _r ) const
  { return _l -> getTime () < _r -> getTime () ; }
} ;



class X_Station
{
  string _name ;
  vector < X_SpaceTimeNode * > _stn ;

public :
  explicit X_Station ( string _n_in )
    : _name ( _n_in ) , _stn () {}
  X_Station ( X_Station const & x )
    : _name ( x . _name ) , _stn ( x . _stn ) {}
  X_Station & operator= ( X_Station const & x )
  { if ( & x == this ) return * this ;
    _name = x . _name ; _stn = x . _stn ; return * this ; }

  void setTime ( X_SpaceTimeNode * x )
  { _stn . push_back ( x ) ; x -> setStation ( this ) ; }

  void sortTimes ()
  { sort ( _stn . begin () , _stn . end () , LessSTN () ) ; }

  string const & getName () const { return _name ; }

  vector < X_SpaceTimeNode * > :: iterator firstNode ()
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: iterator lastNode ()
  { return _stn . end () ; }
  vector < X_SpaceTimeNode * > :: const_iterator firstNode () const
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: const_iterator lastNode () const
  { return _stn . end () ; }
} ;


class X_Train
{
  string _name ;
  vector < X_SpaceTimeNode * > _stn ;

public :
  explicit X_Train ( string _n_in )
    : _name ( _n_in ) , _stn () {}
  X_Train ( X_Train const & x )
    : _name ( x . _name ) , _stn ( x . _stn ) {}
  X_Train & operator= ( X_Train const & x )
  { if ( & x == this ) return * this ;
    _name = x . _name ; _stn = x . _stn ; return * this ; }

  X_SpaceTimeNode * setTime ( bool _dep_ , int _t_ )
  { X_SpaceTimeNode * ret_val = new X_SpaceTimeNode ( _dep_ , _t_ , this ) ;
    _stn . push_back ( ret_val ) ; return ret_val ; }

  string const & getName () const { return _name ; }

  vector < X_SpaceTimeNode * > :: iterator firstNode ()
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: iterator lastNode ()
  { return _stn . end () ; }
  vector < X_SpaceTimeNode * > :: const_iterator firstNode () const
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: const_iterator lastNode () const
  { return _stn . end () ; }
} ;


string
X_SpaceTimeNode :: getName
()
  const
{
  string _ret_val = "NOSTN" ;
  if ( _sta )
  {
    _ret_val = _sta -> getName () ;
  }
  if ( _dep )
  {
    _ret_val += "_DP_" ;
  }
  else
  {
    _ret_val += "_AR_" ;
  }
  ostringstream sx ;
  _ret_val += sx . str () ;
  sx . clear () ;
  sx . str ( "" ) ;
  if ( _trn )
  {
    _ret_val += _trn -> getName () ;
  }
  else
  {
    _ret_val += "PASSENGER" ;
  }
  return _ret_val ;
}



int
main
()
{
  // Stations container
  map < string , X_Station * > _sta ;

  // Trains container
  map < string , X_Train * > _trn ;

  // Create stations
  _sta [ "Sta_A" ] = new X_Station ( "Sta_A" ) ;
  _sta [ "Sta_B" ] = new X_Station ( "Sta_B" ) ;
  _sta [ "Sta_C" ] = new X_Station ( "Sta_C" ) ;
  _sta [ "Sta_D" ] = new X_Station ( "Sta_D" ) ;
  _sta [ "Sta_E" ] = new X_Station ( "Sta_E" ) ;

  // Create trains
  _trn [ "Local_01" ] = new X_Train ( "Local_01" ) ;
  _sta [ "Sta_A" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( DEP , 1000 ) ) ;
  _sta [ "Sta_B" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( ARR , 1090 ) ) ;
  _sta [ "Sta_B" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( DEP , 1120 ) ) ;
  _sta [ "Sta_C" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( ARR , 1240 ) ) ;
  _sta [ "Sta_C" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( DEP , 1390 ) ) ;
  _sta [ "Sta_D" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( ARR , 1540 ) ) ;
  _sta [ "Sta_D" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( DEP , 1570 ) ) ;
  _sta [ "Sta_E" ] -> setTime
    ( _trn [ "Local_01" ] -> setTime ( ARR , 1660 ) ) ;

//   _trn [ "Local_02" ] = new X_Train ( "Local_02" ) ;
//   _sta [ "Sta_A" ] -> setTime
//     ( _trn [ "Local_02" ] -> setTime ( DEP , 1300 ) ) ;
//   _sta [ "Sta_B" ] -> setTime
//     ( _trn [ "Local_02" ] -> setTime ( ARR , 1390 ) ) ;
//   _sta [ "Sta_B" ] -> setTime
//     ( _trn [ "Local_02" ] -> setTime ( DEP , 1420 ) ) ;
//   _sta [ "Sta_C" ] -> setTime
//     ( _trn [ "Local_02" ] -> setTime ( ARR , 1540 ) ) ;
//   _sta [ "Sta_C" ] -> setTime
//     ( _trn [ "Local_02" ] -> setTime ( DEP , 1690 ) ) ;
//   _sta [ "Sta_D" ] -> setTime
//     ( _trn [ "Local_02" ] -> setTime ( ARR , 1840 ) ) ;
//   _sta [ "Sta_D" ] -> setTime
//     ( _trn [ "Local_02" ] -> setTime ( DEP , 1870 ) ) ;
//   _sta [ "Sta_E" ] -> setTime
//     ( _trn [ "Local_02" ] -> setTime ( ARR , 1960 ) ) ;

  _trn [ "Express_01" ] = new X_Train ( "Express_01" ) ;
  _sta [ "Sta_A" ] -> setTime
    ( _trn [ "Express_01" ] -> setTime ( DEP , 1120 ) ) ;
  _sta [ "Sta_C" ] -> setTime
    ( _trn [ "Express_01" ] -> setTime ( ARR , 1300 ) ) ;
  _sta [ "Sta_C" ] -> setTime
    ( _trn [ "Express_01" ] -> setTime ( DEP , 1330 ) ) ;
  _sta [ "Sta_E" ] -> setTime
    ( _trn [ "Express_01" ] -> setTime ( ARR , 1540 ) ) ;

//   _trn [ "Express_02" ] = new X_Train ( "Express_02" ) ;
//   _sta [ "Sta_A" ] -> setTime
//     ( _trn [ "Express_02" ] -> setTime ( DEP , 1420 ) ) ;
//   _sta [ "Sta_C" ] -> setTime
//     ( _trn [ "Express_02" ] -> setTime ( ARR , 1600 ) ) ;
//   _sta [ "Sta_C" ] -> setTime
//     ( _trn [ "Express_02" ] -> setTime ( DEP , 1630 ) ) ;
//   _sta [ "Sta_E" ] -> setTime
//     ( _trn [ "Express_02" ] -> setTime ( ARR , 1840 ) ) ;

  // Creating a node for a passenger
  X_SpaceTimeNode * _passenger = new X_SpaceTimeNode ( ARR , 1050 , 0 ) ;
  _sta [ "Sta_A" ] -> setTime ( _passenger ) ;
  
  //////////////////////////////////////////////////////////////////////

  // Dijkstra's Algorithm: Starting from Node _passenger
  // Creating a solver
  RS_Dijkstra < Sujic_Weight , string > *
    x = new RS_Dijkstra < Sujic_Weight , string >
    ( Sujic_Weight ( LARGENUM , 0 , 0 , 0 ) ) ;

  // Sorting Space Time Nodes, creating nodes for the Dijkstra's algorithm
  for ( map < string , X_Station * > :: iterator ii = _sta . begin () ;
        ii != _sta . end () ; ++ ii )
  {
    ii -> second -> sortTimes () ;
    for ( vector < X_SpaceTimeNode * > :: const_iterator ix
            = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () ; ++ ix )
    {
      string _nn = ( * ix ) -> getName () ;
      x -> setNode ( _nn , _nn ) ;
    }
    string _stname = ii -> second -> getName () ;
    x -> setNode ( _stname , _stname ) ;
  }
  for ( map < string , X_Train * > :: iterator ii = _trn . begin () ;
        ii != _trn . end () ; ++ ii )
  {
    for ( vector < X_SpaceTimeNode * > :: const_iterator ix
            = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () ; ++ ix )
    {
      string _nn = ( * ix ) -> getName () ;
      _nn += "_T" ;
      x -> setNode ( _nn , _nn ) ;
    }
  }

  // Creating branches
  for ( map < string , X_Station * > :: iterator ii = _sta . begin () ;
        ii != _sta . end () ; ++ ii )
  {
    for ( vector < X_SpaceTimeNode * > :: const_iterator ix
            = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () - 1 ; ++ ix )
    {
      string _nns = ( * ix ) -> getName () ;
      string _nne = ( * ( ix + 1 ) ) -> getName () ;
      int _ts = ( * ix ) -> getTime () ;
      int _te = ( * ( ix + 1 ) ) -> getTime () ;
      x -> setBranch ( _nns , _nne ,
                       Sujic_Weight ( _te - _ts , 0 , 0 , _te - _ts ) ) ;
    }
    string _stname = ii -> second -> getName () ;
    for ( vector < X_SpaceTimeNode * > :: const_iterator ix
            = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () ; ++ ix )
    {
      string _nns = ( * ix ) -> getName () ;
      x -> setBranch ( _nns , _stname ,
                       Sujic_Weight ( 0 , 0 , 0 , 0 ) ) ;
    }
  }

  for ( map < string , X_Train * > :: iterator ii = _trn . begin () ;
        ii != _trn . end () ; ++ ii )
  {
    for ( vector < X_SpaceTimeNode * > :: const_iterator ix
            = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () - 1 ; ++ ix )
    {
      string _nns = ( * ix ) -> getName () ;
      _nns += "_T" ;
      string _nne = ( * ( ix + 1 ) ) -> getName () ;
      _nne += "_T" ;
      int _ts = ( * ix ) -> getTime () ;
      int _te = ( * ( ix + 1 ) ) -> getTime () ;
      x -> setBranch ( _nns , _nne ,
                       Sujic_Weight ( _te - _ts , 0 , 0 , 0 ) ) ;
    }

    for ( vector < X_SpaceTimeNode * > :: const_iterator ix
            = ii -> second -> firstNode () ;
          ix != ii -> second -> lastNode () ; ++ ix )
    {
      string _nns = ( * ix ) -> getName () ;
      string _nne = _nns ;
      if ( ( * ix ) -> isDeparting () )
      {
        _nne += "_T" ;
      }
      else
      {
        _nns += "_T" ;
      }
      x -> setBranch ( _nns , _nne ,
                       Sujic_Weight ( 0 , 1 , 0 , 0 ) ) ;
    }
  }

  string _startnode = _passenger -> getName () ;
  x -> run ( _startnode , Sujic_Weight ( 0 , 0 , 0 , 0 ) ) ;

  // Printing
  for ( map < string , X_Station * > :: iterator ii = _sta . begin () ;
        ii != _sta . end () ; ++ ii )
  {
    string _stname = ii -> second -> getName () ;
    x -> printRoute ( _stname ) ;
  }

  delete x ;
}
