// -*- C++ -*-

#include "Sujic_Weight.hh"



ostream &
operator<<
( ostream & out ,
  Sujic_Weight const & x )
{
  out << x . _time << "(" << x . _transfers << "/" << x . _time_walk
      << "/" << x . _time_wait << ")" ;
  return out ;
}


bool
operator<
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  if ( x . _time < y . _time )
  {
    return true ;
  }
  else if ( x . _time == y . _time )
  {
    if ( x . _transfers < y . _transfers )
    {
      return true ;
    }
    else if ( x . _transfers == y . _transfers )
    {
      if ( x . _time_walk < y . _time_walk )
      {
        return true ;
      }
      else if ( x . _time_walk == y . _time_walk )
      {
        if ( x . _time_wait < y . _time_wait )
        {
          return true ;
        }
        else
        {
          return false ;
        }
      }
      else
      {
        return false ;
      }
    }
    else
    {
      return false ;
    }
  }
  else
  {
    return false ;
  }
}


bool
operator==
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  return
    x . _time == y . _time
    && x . _transfers == y . _transfers
    && x . _time_walk == y . _time_walk
    && x . _time_wait == y . _time_wait ;
}



Sujic_Weight
operator+
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  return Sujic_Weight
    ( x . _time + y . _time ,
      x . _transfers + y . _transfers ,
      x . _time_walk + y . _time_walk ,
      x . _time_wait + y . _time_wait ) ;
}


Sujic_Weight
operator-
( Sujic_Weight const & x ,
  Sujic_Weight const & y )
{
  return Sujic_Weight
    ( x . _time - y . _time ,
      x . _transfers - y . _transfers ,
      x . _time_walk - y . _time_walk ,
      x . _time_wait - y . _time_wait ) ;
}


Sujic_Weight &
Sujic_Weight :: operator+=
( Sujic_Weight const & x )
{
  _time += x . _time ;
  _transfers += x . _transfers ;
  _time_walk += x . _time_walk ;
  _time_wait += x . _time_wait ;
  return * this ;
}
