// -*- C++ -*-

// ダイクストラ法のデモ

#include "RS_Object.hh"


#ifndef X_SpaceTimeNode_HH
#define X_SpaceTimeNode_HH


const bool DEP = true ;
const bool ARR = false ;

class X_Train ;
class X_Station ;

class X_SpaceTimeNode
  : public virtual RS_Object
{
public :
  static int CYCLE_TIME ;             // cycle time
  static bool DO_CYCLIC_SIMULATION ;  // true if cyclic schedule is assumed

protected :
  bool _dep ;                         // true if departing
  int _t_ ;                           // Time (of arrival or departure)
  int _cd_ ;                          // Cycle delay number
  bool _is_trn ;                      // True if on the train side
  X_Train const * _trn ;              // Train
  X_Station const * _sta ;            // Station

public :
  explicit X_SpaceTimeNode
  ( bool _dep_in , int _t_in , X_Train * _trn_in , bool _sw = true )
    : RS_Object () , _dep ( _dep_in ) , _t_ ( _t_in ) , _cd_ ( 0 ) ,
      _is_trn ( _sw ) , _trn ( _trn_in ) , _sta ( 0 )
  { if ( DO_CYCLIC_SIMULATION ) {
      while ( _t_ < 0 ) { _t_ += CYCLE_TIME ; -- _cd_ ; }
      while ( _t_ >= CYCLE_TIME ) { _t_ -= CYCLE_TIME ; ++ _cd_ ; } }
    setName () ; }

  explicit X_SpaceTimeNode ( X_Station const * _sta_in , bool _dep_in )
    : RS_Object () , _dep ( _dep_in ) , _t_ ( 0 ) , _cd_ ( 0 ) ,
      _is_trn ( false ) , _trn ( 0 ) , _sta ( _sta_in ) { setName () ; }

  X_SpaceTimeNode
  ( X_SpaceTimeNode const & x , bool _sw )
    : RS_Object ( x ) , _dep ( x . _dep ) , _t_ ( x . _t_ ) ,
      _cd_ ( x . _cd_ ) , _is_trn ( _sw ) , _trn ( x . _trn ) ,
      _sta ( x . _sta ) { setName () ; }

  X_SpaceTimeNode ( X_SpaceTimeNode const & x )
    : RS_Object ( x ) , _dep ( x . _dep ) , _t_ ( x . _t_ ) ,
      _cd_ ( x . _cd_ ) , _is_trn ( x . _is_trn ) , _trn ( x . _trn ) ,
      _sta ( x . _sta ) {}

  X_SpaceTimeNode & operator= ( X_SpaceTimeNode const & x )
  { if ( & x == this ) return * this ;
    RS_Object :: operator= ( x ) ;
    _dep = x . _dep ; _t_ = x . _t_ ; _cd_ = x . _cd_ ;
    _is_trn = x . _is_trn ; _trn = x . _trn ; _sta = x . _sta ;
    return * this ; }

  bool isDeparting () const { return _dep ; }
  int getTime () const { return _t_ ; }
  int getCycleDelay () const { return _cd_ ; }

  void setStation ( X_Station const * x ) { _sta = x ; setName () ; }
  X_Station const * getStation () const { return _sta ; }

  void setName () ;
} ;


#endif  // X_SpaceTimeNode_HH
