// -*- C++ -*-

// ダイクストラ法のデモ

#include "X_Station.hh"


X_Station :: X_Station
( string const & _n_in )
  : X_Station_Base ( _n_in ) ,
    _stn () ,
    _stn_a () ,
    _demand () ,
    _myexit ( 0 ) ,
    _odc ()
{
  _myexit = new X_SpaceTimeNode ( this , true ) ;
  _odc = new X_OD_Station_Container () ;
}



X_Station :: X_Station
( TiXmlNode const * const & curnode )
  : X_Station_Base ( curnode )
{
  if ( ! curnode )
  {
    cerr << "Error: node not set in X_Station constructor." << endl ;
    exit ( 1 ) ;
  }
  if ( curnode -> ValueStr () != "data" )
  {
    cerr << "Error: <" << curnode -> ValueStr ()
         << "> tag not allowed in X_Station constructor." << endl ;
    exit ( 1 ) ;
  }
  const TiXmlAttribute * attr = curnode -> ToElement () -> FirstAttribute () ;
  bool sw_name = false ;
  while ( attr )
  {
    if ( string ( attr -> Name () ) == "name" )
    {
      // Attribute "name"
      if ( sw_name )
      {
        // Strange ... two attributes of same name?
        // 同じ属性が2つある？... エラー
        cerr << "Error: two \"name\" attributes?" << endl ;
        exit ( 2 ) ;
      }
      setName ( attr -> ValueStr () ) ;
      sw_name = true ;
    }
    attr = attr -> Next () ;
  }
  if ( ! sw_name )
  {
    cerr << "Error: <data> tag without attribute \"name\" in initialising "
         << "an X_Station object." << endl ;
    exit ( 1 ) ;
  }

  // ----
  // Setting an exit node.
  // ----
  _myexit = new X_SpaceTimeNode ( this , true ) ;

  // ----
  // Setting an OD data container.
  // ----
  _odc = new X_OD_Station_Container () ;
}



RS_ObjectContainer *
X_Station :: getContainer
( string const & x )
{
  if ( x != "od_data" )
  {
    cerr << "Error: No class \"" << x << "\" found in X_Station" << endl ;
    exit ( 1 ) ;
  }
  return _odc ;
}




RS_ObjectContainer const *
X_Station :: getContainer
( string const & x )
  const
{
  if ( x != "od_data" )
  {
    cerr << "Error: No class \"" << x << "\" found in X_Station" << endl ;
    exit ( 1 ) ;
  }
  return _odc ;
}




bool
X_Station_Container :: create
( TiXmlNode const * & _n_in ,
  vector < string > const & _s_in ,
  vector < RS_Object * > const & _o_in )
{
  string xxx = getClassString ( _n_in ) ;
  string yyy = getNameString ( _n_in ) ;
  X_Station_Base * x = STA_Expander :: create ( xxx , _n_in ) ;
  ( * this ) [ yyy ] = x ;
  vector < string > :: const_iterator ii = _s_in . begin () ;
  vector < RS_Object * > :: const_iterator jj = _o_in . begin () ;
  while ( ii < _s_in . end () || jj < _o_in . end () )
  {
    if ( x -> acceptInitObject ( * ii , * jj ) )
    {
      ++ ii ;
      ++ jj ;
    }
    else
    {
      cerr << "Error: acceptInitObject failed, type = "
           << * ii << endl ;
      exit ( 1 ) ;
    }
  }
  return true ;
}




X_Station_Base const *
X_Station_Container :: locateStation
( string const & x )
  const
{
  RS_Object const * retv = locate ( x ) ;
  return dynamic_cast < X_Station_Base const * > ( retv ) ;
}




X_Station_Base *
X_Station_Container :: locateStation
( string const & x )
{
  RS_Object * retv = locate ( x ) ;
  return dynamic_cast < X_Station_Base * > ( retv ) ;
}



X_OD_Station :: X_OD_Station
( TiXmlNode const * const & curnode )
  : X_OD_Station_Base ( curnode ) ,
    _dest ( 0 )
{
  if ( ! curnode )
  {
    cerr << "Error: node not set in X_OD_Station constructor." << endl ;
    exit ( 1 ) ;
  }
  if ( curnode -> ValueStr () != "data" )
  {
    cerr << "Error: <" << curnode -> ValueStr ()
         << "> tag not allowed in X_OD_Station constructor." << endl ;
    exit ( 1 ) ;
  }
  const TiXmlAttribute * attr = curnode -> ToElement () -> FirstAttribute () ;
  bool sw_demand = false ;
  while ( attr )
  {
    if ( string ( attr -> Name () ) == "demand" )
    {
      // Attribute "demand"
      if ( sw_demand )
      {
        // Strange ... two attributes of same name?
        // 同じ属性が2つある？... エラー
        cerr << "Error: two \"demand\" attributes?" << endl ;
        exit ( 2 ) ;
      }
      sscanf ( attr -> Value () , "%lf" , & _demand ) ;
      sw_demand = true ;
    }
    attr = attr -> Next () ;
  }
  if ( ! sw_demand )
  {
    cerr << "Error: <data> tag without attribute \"demand\" in initialising "
         << "an X_OD_Station object." << endl ;
    exit ( 1 ) ;
  }
}




X_Station_Base const *
X_OD_Station :: getDestination
()
  const
{
  if ( ! _dest )
  {
    cerr << "Error: destination not set in X_OD_Data:" << endl
         << "  Probably improper XML initialisation; check init files."
         << endl ;
    exit ( 1 ) ;
  }
  return _dest ;
}




bool
X_OD_Station :: acceptInitObject
( string const & _t_in ,
  RS_Object * _o_in )
{
  if ( _t_in != "destination" )
  {
    cerr << "Error: <using> tag with incorrect type \"" << _t_in
         << "\", not accepted by X_OD_Station object." << endl ;
    exit ( 1 ) ;
  }
  if ( _dest )
  {
    cerr << "Error: _dest seems to have already been set. "
         << "Duplicate <using> tag?" << endl ;
    exit ( 1 ) ;
  }
  _dest = dynamic_cast < X_Station_Base * > ( _o_in ) ;
  if ( ! _dest )
  {
    cerr << "Error: dynamic cast failed in acceptInitObject, type = \""
         << _t_in << "\"." << endl ;
    exit ( 1 ) ;
  }
  return true ;
}




bool
X_OD_Station_Container :: create
( TiXmlNode const * & _n_in ,
  vector < string > const & _s_in ,
  vector < RS_Object * > const & _o_in )
{
  string xxx = getClassString ( _n_in ) ;
  vector < string > :: const_iterator ii = _s_in . begin () ;
  vector < RS_Object * > :: const_iterator jj = _o_in . begin () ;
  string yyy = "OD_to_" ;
  bool _sw_x = false ;
  while ( ii < _s_in . end () || jj < _o_in . end () )
  {
    if ( _sw_x )
    {
      cerr << "Error: Duplicate <using> tag in initialising "
           << "an X_OD_Station object?" << endl ;
      exit ( 1 ) ;
    }
    _sw_x = true ;
    yyy += ( * jj ) -> getName () ;
    ++ ii ;
    ++ jj ;
  }
  if ( ! _sw_x )
  {
    cerr << "Error: <using> tag not found in initialising "
         << "an X_OD_Station object" << endl ;
    exit ( 1 ) ;
  }
  ii = _s_in . begin () ;
  jj = _o_in . begin () ;
  X_OD_Station_Base * x = ODS_Expander :: create ( xxx , _n_in ) ;
  ( * this ) [ yyy ] = x ;
  if ( ! x -> acceptInitObject ( * ii , * jj ) )
  {
    cerr << "Error: <using> tag not properly interpreted..." << endl ;
    exit ( 1 ) ;
  }
  return true ;
}
