// -*- C++ -*-

// ダイクストラ法のデモ

#include "X_Train.hh"
#include "X_Station.hh"


X_Train :: X_Train
( TiXmlNode const * const & curnode )
  : X_Train_Base ( curnode )
{
  if ( ! curnode )
  {
    cerr << "Error: node not set in X_Train constructor." << endl ;
    exit ( 1 ) ;
  }
  if ( curnode -> ValueStr () != "data" )
  {
    cerr << "Error: <" << curnode -> ValueStr ()
         << "> tag not allowed in X_Train constructor." << endl ;
    exit ( 1 ) ;
  }
  const TiXmlAttribute * attr = curnode -> ToElement () -> FirstAttribute () ;
  bool sw_name = false ;
  while ( attr )
  {
    if ( string ( attr -> Name () ) == "name" )
    {
      // Attribute "name"
      if ( sw_name )
      {
        // Strange ... two attributes of same name?
        // 同じ属性が2つある？... エラー
        cerr << "Error: two \"name\" attributes?" << endl ;
        exit ( 2 ) ;
      }
      setName ( attr -> ValueStr () ) ;
      sw_name = true ;
    }
    attr = attr -> Next () ;
  }
  if ( ! sw_name )
  {
    cerr << "Error: <data> tag without attribute \"name\" in initialising "
         << "an X_Train object." << endl ;
    exit ( 1 ) ;
  }

  // ----
  // Reading timetable data.
  // ----
  for ( TiXmlNode const * curch = curnode -> FirstChild () ;
        curch ; curch = curch -> NextSibling () )
  {
    if ( curch -> Type () != TiXmlNode :: TINYXML_ELEMENT )
    {
      continue ;
    }
    if ( curch -> ValueStr () != "train_time" )
    {
      cerr << "Error: tag <" << curch -> ValueStr ()
           << "> not allowed in initialisation of X_Train object." << endl ;
      exit ( 1 ) ;
    }
    bool sw_sta = false ;
    bool sw_dep = false ;
    bool sw_tim = false ;
    string _s_in ;
    bool _d_in ;
    int _t_in ;
    for ( TiXmlAttribute const *
            _cca = curch -> ToElement () -> FirstAttribute () ;
          _cca ; _cca = _cca -> Next () )
    {
      if ( string ( _cca -> Name () ) == "station" )
      {
        // Attribute "station"
        if ( sw_sta )
        {
          // Strange ... two attributes of same name?
          // 同じ属性が2つある？... エラー
          cerr << "Error: two \"station\" attributes?" << endl ;
          exit ( 1 ) ;
        }
        _s_in = _cca -> ValueStr () ;
        sw_sta = true ;
      }
      else if ( string ( _cca -> Name () ) == "status" )
      {
        // Attribute "status"
        if ( sw_dep )
        {
          // Strange ... two attributes of same name?
          // 同じ属性が2つある？... エラー
          cerr << "Error: two \"status\" attributes?" << endl ;
          exit ( 1 ) ;
        }
        if ( _cca -> ValueStr () == "DEP" )
        {
          _d_in = true ;
        }
        else if ( _cca -> ValueStr () == "ARR" )
        {
          _d_in = false ;
        }
        else
        {
          cerr << "Error: value \"" << _cca -> ValueStr ()
               << "\" not allowed in \"status\" attribute" << endl ;
          exit ( 1 ) ;
        }
        sw_dep = true ;
      }
      else if ( string ( _cca -> Name () ) == "time" )
      {
        // Attribute "time"
        if ( sw_tim )
        {
          // Strange ... two attributes of same name?
          // 同じ属性が2つある？... エラー
          cerr << "Error: two \"time\" attributes?" << endl ;
          exit ( 1 ) ;
        }
        sscanf ( _cca -> Value () , "%d" , & _t_in ) ;
        sw_tim = true ;
      }
      else
      {
        cerr << "Error: attribute \"" << _cca -> Name ()
             << "\" not allowed" << endl ;
        exit ( 1 ) ;
      }
    }
    if ( sw_sta && sw_dep && sw_tim )
    {
      _si . push_back
        ( X_Train_Time_Initialiser ( _s_in , _d_in , _t_in ) ) ;
    }
    else
    {
      cerr << "Error: attribute(s) missing in <train_time> tag" << endl ;
      exit ( 1 ) ;
    }
  }
}



bool
X_Train_Container :: create
( TiXmlNode const * & _n_in ,
  vector < string > const & _s_in ,
  vector < RS_Object * > const & _o_in )
{
  string xxx = getClassString ( _n_in ) ;
  string yyy = getNameString ( _n_in ) ;
  X_Train_Base * x = TRN_Expander :: create ( xxx , _n_in ) ;
  ( * this ) [ yyy ] = x ;
  vector < string > :: const_iterator ii = _s_in . begin () ;
  vector < RS_Object * > :: const_iterator jj = _o_in . begin () ;
  while ( ii < _s_in . end () || jj < _o_in . end () )
  {
    if ( x -> acceptInitObject ( * ii , * jj ) )
    {
      ++ ii ;
      ++ jj ;
    }
    else
    {
      cerr << "Error: acceptInitObject failed, type = "
           << * ii << endl ;
      exit ( 1 ) ;
    }
  }
  return true ;
}




X_Train_Base const *
X_Train_Container :: locateTrain
( string const & x )
  const
{
  RS_Object const * retv = locate ( x ) ;
  return dynamic_cast < X_Train_Base const * > ( retv ) ;
}




X_Train_Base *
X_Train_Container :: locateTrain
( string const & x )
{
  RS_Object * retv = locate ( x ) ;
  return dynamic_cast < X_Train_Base * > ( retv ) ;
}



bool
X_Train_Container :: setTimes
( X_Station_Container * _xsc )
{
  for ( map < string , RS_Object * > :: iterator _itrn = begin () ;
        _itrn != end () ; ++ _itrn )
  {
    X_Train_Base *
      _xtb = dynamic_cast < X_Train_Base * > ( _itrn -> second ) ;
    if ( ! _xtb )
    {
      cerr << "Error: failed to dynamic_cast X_Train_Base in setTimes"
           << endl ;
      exit ( 1 ) ;
    }
    for ( vector < X_Train_Time_Initialiser > :: iterator
            _iti = _xtb -> firstTimeInitialiser () ;
          _iti != _xtb -> lastTimeInitialiser () ; ++ _iti )
    {
      string _sta_name = _iti -> _station ;
      bool _dep_in = _iti -> _dep ;
      int _time_in = _iti -> _t_ ;
      X_Station_Base * _xsb = _xsc -> locateStation ( _sta_name ) ;
      _xsb -> setTime ( _xtb -> setTime ( _dep_in , _time_in ) ) ;
    }
  }
  return true ;
}
