// -*- C++ -*-

// ダイクストラ法のデモ

#include "X_CycleTime_Initialiser.hh"


X_Simple_CTI :: X_Simple_CTI
( TiXmlNode const * const & curnode )
{
  if ( ! curnode )
  {
    cerr << "Error: node not set in X_Train constructor." << endl ;
    exit ( 1 ) ;
  }
  if ( curnode -> ValueStr () != "data" )
  {
    cerr << "Error: <" << curnode -> ValueStr ()
         << "> tag not allowed in X_Train constructor." << endl ;
    exit ( 1 ) ;
  }
  const TiXmlAttribute * attr = curnode -> ToElement () -> FirstAttribute () ;
  bool sw_name = false ;
  bool sw_cycle = false ;
  while ( attr )
  {
    if ( string ( attr -> Name () ) == "name" )
    {
      // Attribute "name"
      if ( sw_name )
      {
        // Strange ... two attributes of same name?
        // 同じ属性が2つある？... エラー
        cerr << "Error: two \"name\" attributes?" << endl ;
        exit ( 2 ) ;
      }
      setName ( attr -> ValueStr () ) ;
      sw_name = true ;
    }
    else if ( string ( attr -> Name () ) == "cycle" )
    {
      // Attribute "name"
      if ( sw_cycle )
      {
        // Strange ... two attributes of same name?
        // 同じ属性が2つある？... エラー
        cerr << "Error: two \"cycle\" attributes?" << endl ;
        exit ( 2 ) ;
      }
      sscanf ( attr -> Value () , "%d" , & _cyc ) ;
      sw_cycle = true ;
    }
    attr = attr -> Next () ;
  }
  if ( ! ( sw_name && sw_cycle ) )
  {
    cerr << "Error: <data> tag without attribute \"name\" or \"cycle\" in "
         << "initialising an X_Simple_CTI object." << endl ;
    exit ( 1 ) ;
  }
}



bool
X_CTI_Container :: create
( TiXmlNode const * & _n_in ,
  vector < string > const & _s_in ,
  vector < RS_Object * > const & _o_in )
{
  if ( size () )
  {
    cerr << "Error: duplicate cycle time initialiser" << endl ;
    exit ( 1 ) ;
  }
  string xxx = getClassString ( _n_in ) ;
  string yyy = getNameString ( _n_in ) ;
  X_CycleTime_Initialiser * x = Cyc_Expander :: create ( xxx , _n_in ) ;
  ( * this ) [ yyy ] = x ;
  vector < string > :: const_iterator ii = _s_in . begin () ;
  vector < RS_Object * > :: const_iterator jj = _o_in . begin () ;
  while ( ii < _s_in . end () || jj < _o_in . end () )
  {
    if ( x -> acceptInitObject ( * ii , * jj ) )
    {
      ++ ii ;
      ++ jj ;
    }
    else
    {
      cerr << "Error: acceptInitObject failed, type = "
           << * ii << endl ;
      exit ( 1 ) ;
    }
  }
  return true ;
}




int
X_CTI_Container :: getCycleTime
()
  const
{
  if ( size () == 0 )
  {
    cerr << "Error: no cycle time initialiser" << endl ;
    exit ( 1 ) ;
  }
  if ( size () > 1 )
  {
    cerr << "Error: more than one cycle time initialisers" << endl ;
    exit ( 1 ) ;
  }
  return
    dynamic_cast < X_CycleTime_Initialiser const * > ( begin () -> second )
    -> getCycleTime () ;
}
