// -*- C++ -*-

// ダイクストラ法のデモ


#include <vector>
#include <iostream>
#include <cstdlib>

#include "RS_Object.hh"
#include "RS_XmlReader.hh"
#include "Expandable.hh"


#ifndef X_CycleTime_HH
#define X_CycleTime_HH


using std :: vector ;
using std :: cerr ;
using std :: endl ;



class X_CycleTime_Initialiser
  : public virtual RS_Object
{
public :
  virtual int getCycleTime () const = 0 ;
} ;


typedef Expandable < X_CycleTime_Initialiser , TiXmlNode const * >
Cyc_Expander ;


class X_Simple_CTI
  : public X_CycleTime_Initialiser ,
    public Cyc_Expander
{
  int _cyc ;

public :

  explicit X_Simple_CTI ( TiXmlNode const * const & ) ;
  int getCycleTime () const { return _cyc ; }
} ;



class X_Simple_CTI_Creator
  : public Cyc_Expander :: ObjectCreator
{
public :
  X_Simple_CTI_Creator ()
  { add_to_creators_list ( "x_simple_cti" ) ; }
  X_Simple_CTI_Creator ( const char * x )
    : Cyc_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  X_CycleTime_Initialiser * create () const
  { cerr << "Error: X_CycleTime_Initialiser... default constructor prohibited"
         << endl ; exit ( 1 ) ; }
  X_CycleTime_Initialiser * create ( TiXmlNode const * const & x ) const
  { return new X_Simple_CTI ( x ) ; }
} ;



class X_CTI_Container
  : public RS_ObjectContainer
{
public :
  bool create ( TiXmlNode const * & , vector < string > const & ,
                vector < RS_Object * > const & ) ;
  int getCycleTime () const ;
  ~X_CTI_Container () {}
} ;



#endif  // X_Train_HH
