// -*- C++ -*-

// ダイクストラ法のデモ

#ifndef X_SpaceTimeBranch_HH
#define X_SpaceTimeBranch_HH

#include "Sujic_Weight.hh"
#include "X_SpaceTimeNode.hh"

#include <vector>

using std :: cerr ;
using std :: endl ;
using std :: vector ;



class X_SpaceTimeBranch ;


class X_STB_Key
  : public virtual RS_Object
{
  X_SpaceTimeNode const * __from ;
  X_SpaceTimeNode const * __to ;

public :
  X_STB_Key ( X_SpaceTimeNode const * _f , X_SpaceTimeNode const * _t )
    : RS_Object () , __from ( _f ) , __to ( _t )
  { if ( ! __from || ! __to ) {
      cerr << "Error: null pointer used to initialise X_SpaceTimeBranch"
           << endl ; exit ( 1 ) ; } }
  X_STB_Key ( X_STB_Key const & x )
    : RS_Object ( x ) , __from ( x . __from ) , __to ( x . __to ) {}
  X_STB_Key & operator= ( X_STB_Key const & x )
  { if ( & x == this ) return * this ; RS_Object :: operator= ( x ) ;
    __from = x . __from ; __to = x . __to ; return * this ; }

  X_SpaceTimeNode const * getStartSTN () const { return __from ; }
  X_SpaceTimeNode const * getEndSTN () const { return __to ; }

  bool operator< ( X_STB_Key const & x ) const
  { return __from < x . __from || __from == x . __from && __to < x . __to ; }
  bool operator== ( X_STB_Key const & x ) const
  { return __from == x . __from && __to == x . __to ; }
} ;
  


class X_Passengers_F1 ;



class X_SpaceTimeBranch
  : public X_STB_Key
{
  Sujic_Weight _weight ;
  vector < X_Passengers_F1 const * > _pas_i ;
  vector < X_Passengers_F1 const * > _pas ;
  X_SpaceTimeNode * _p_arrivals ;

public :
  explicit X_SpaceTimeBranch
  ( X_SpaceTimeNode const * _bf_in , X_SpaceTimeNode const * _af_in ,
    Sujic_Weight const & _w_in )
    : X_STB_Key ( _bf_in , _af_in ) , _weight ( _w_in ) , _pas_i () ,
      _pas () , _p_arrivals ( 0 ) {}
  X_SpaceTimeBranch ( X_SpaceTimeBranch const & x )
    : X_STB_Key ( x ) , _weight ( x . _weight ) , _pas_i ( x . _pas_i ) ,
      _pas ( x . _pas ) , _p_arrivals ( x . _p_arrivals ) {}
  X_SpaceTimeBranch & operator= ( X_SpaceTimeBranch const & x )
  { if ( this == & x ) return * this ;
    X_STB_Key :: operator= ( x ) ; _weight = x . _weight ;
    _pas = x . _pas ; _p_arrivals = x . _p_arrivals ; return * this ; }

  void setPassengerArrivalNode ()
  { _p_arrivals = new X_SpaceTimeNode
      ( getStartSTN () -> getStation () , false ) ; }
  X_SpaceTimeNode const * getPassengerArrivalNode () const 
  { return _p_arrivals ; }

  Sujic_Weight const & getWeight () const { return _weight ; }

  void addPassenger ( X_Passengers_F1 const * x ) 
  { _pas . push_back ( x ) ; }

  void addInitiatingPassenger ( X_Passengers_F1 const * x ) 
  { _pas_i . push_back ( x ) ; }

  string getMiddleName () const
  { string ret_val = "MIDDLE_" ; ret_val += getStartSTN () -> getName () ;
    ret_val += "_" ; ret_val += getEndSTN () -> getName () ; return ret_val ; }

  string const & getStartStationName () const 
  { return getStartSTN () -> getStation () -> getName () ; }

  string const & getEndStationName () const 
  { return getEndSTN () -> getStation () -> getName () ; }

  vector < X_Passengers_F1 const * > :: const_iterator
  firstInitialPassenger () const { return _pas_i . begin () ; }
  vector < X_Passengers_F1 const * > :: const_iterator
  lastInitialPassenger () const { return _pas_i . end () ; }

  vector < X_Passengers_F1 const * > :: const_iterator
  firstPassenger () const { return _pas . begin () ; }
  vector < X_Passengers_F1 const * > :: const_iterator
  lastPassenger () const { return _pas . end () ; }
} ;



#endif   // X_SpaceTimeBranch_HH
