// -*- C++ -*-

// ダイクストラ法のデモ

#include "X_SpaceTimeNode.hh"
#include "Expandable.hh"
#include "RS_XmlReader.hh"

#ifndef X_Station_HH
#define X_Station_HH


#include <algorithm>
#include <iostream>
#include <vector>
#include <map>


using std :: cerr ;
using std :: endl ;
using std :: vector ;
using std :: map ;
using std :: sort ;



class LessSTN
{
public :
  bool operator() ( X_SpaceTimeNode const * _l ,
                    X_SpaceTimeNode const * _r ) const
  { return _l -> getTime () < _r -> getTime () ; }
} ;



class X_Station_Base ;



class X_OD_Station_Base
  : public virtual RS_Object
{
public :
  explicit X_OD_Station_Base ( TiXmlNode const * const & x ) : RS_Object () {}
  explicit X_OD_Station_Base ( string const & _n_in ) : RS_Object ( _n_in ) {}
  explicit X_OD_Station_Base ( X_OD_Station_Base const & x )
    : RS_Object ( x ) {}
  X_OD_Station_Base & operator= ( X_OD_Station_Base const & x )
  { if ( & x == this ) return * this ;
    RS_Object :: operator= ( x ) ; return * this ; }

  virtual ~X_OD_Station_Base () {}

  virtual X_Station_Base const * getDestination () const = 0 ;
  virtual double getDemand () const = 0 ;
} ;



typedef Expandable < X_OD_Station_Base , TiXmlNode const * > ODS_Expander ;


class X_OD_Station
  : public X_OD_Station_Base ,
    public ODS_Expander
{
  X_Station_Base const * _dest ;
  double _demand ;

  // These must be prohibited...
  explicit X_OD_Station ( X_OD_Station const & x ) ;
  X_OD_Station & operator= ( X_OD_Station const & x ) ;
  explicit X_OD_Station ( string const & ) ;

public :
  explicit X_OD_Station ( TiXmlNode const * const & ) ;
  ~X_OD_Station () {}

  X_Station_Base const * getDestination () const ;
  double getDemand () const { return _demand ; }

  bool acceptInitObject ( string const & , RS_Object * ) ;
} ;


class X_OD_Station_Creator
  : public ODS_Expander :: ObjectCreator
{
public :
  X_OD_Station_Creator ()
  { add_to_creators_list ( "x_od_station" ) ; }
  X_OD_Station_Creator ( const char * x )
    : ODS_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  X_OD_Station_Base * create () const
  { cerr << "Error: X_OD_Station... default constructor prohibited" << endl ;
    exit ( 1 ) ; }
  X_OD_Station_Base * create ( TiXmlNode const * const & x ) const
  { return new X_OD_Station ( x ) ; }
} ;



class X_OD_Station_Container
  : public RS_ObjectContainer
{
public :
  bool create ( TiXmlNode const * & , vector < string > const & ,
                vector < RS_Object * > const & ) ;
  ~X_OD_Station_Container () {}
} ;




class X_Station_Base
  : public virtual RS_Object
{
public :
  explicit X_Station_Base ( TiXmlNode const * const & x ) : RS_Object () {}
  explicit X_Station_Base ( string const & _n_in ) : RS_Object ( _n_in ) {}
  explicit X_Station_Base ( X_Station_Base const & x ) : RS_Object ( x ) {}
  X_Station_Base & operator= ( X_Station_Base const & x )
  { if ( & x == this ) return * this ;
    RS_Object :: operator= ( x ) ; return * this ; }
  virtual ~X_Station_Base () {}

  virtual void setTime ( X_SpaceTimeNode * ) = 0 ;

  virtual X_SpaceTimeNode const *
  getCorrespondingNode ( X_SpaceTimeNode const * x ) const = 0 ;

  virtual void sortTimes () = 0 ;

  virtual X_SpaceTimeNode const * getExit () const = 0 ;

  virtual vector < X_SpaceTimeNode * > :: iterator firstNode () = 0 ;
  virtual vector < X_SpaceTimeNode * > :: iterator lastNode () = 0 ;
  virtual vector < X_SpaceTimeNode * > :: const_iterator firstNode () const
  = 0 ;
  virtual vector < X_SpaceTimeNode * > :: const_iterator lastNode () const
  = 0 ;

  virtual X_OD_Station_Container :: iterator firstOD () = 0 ;
  virtual X_OD_Station_Container :: iterator lastOD () = 0 ;
  virtual X_OD_Station_Container :: const_iterator firstOD () const = 0 ;
  virtual X_OD_Station_Container :: const_iterator lastOD () const = 0 ;
} ;



typedef Expandable < X_Station_Base , TiXmlNode const * > STA_Expander ;



class X_Station
  : public X_Station_Base ,
    public STA_Expander
{
  vector < X_SpaceTimeNode * > _stn ;
  map < X_SpaceTimeNode const * , X_SpaceTimeNode const * > _stn_a ;
  map < X_Station_Base const * , double > _demand ;
  X_SpaceTimeNode * _myexit ;
  RS_ObjectContainer * _odc ;

  // These must be prohibited...
  explicit X_Station ( X_Station const & x ) ;
  X_Station & operator= ( X_Station const & x ) ;

public :
  explicit X_Station ( TiXmlNode const * const & ) ;
  explicit X_Station ( string const & ) ;
  ~X_Station () { delete _myexit ; delete _odc ; }

  RS_ObjectContainer * getContainer ( string const & ) ;
  RS_ObjectContainer const * getContainer ( string const & ) const ;

  bool acceptInitObject ( string const & _sx , RS_Object * _ox )
  { return false ; }

  void setTime ( X_SpaceTimeNode * x )
  { x -> setStation ( this ) ;
    X_SpaceTimeNode * y = new X_SpaceTimeNode ( * x , false ) ;
    _stn . push_back ( y ) ; _stn_a [ x ] = y ; }

  X_SpaceTimeNode const *
  getCorrespondingNode ( X_SpaceTimeNode const * x ) const
  { map < X_SpaceTimeNode const * , X_SpaceTimeNode const * >
      :: const_iterator ii = _stn_a . find ( x ) ;
    if ( ii == _stn_a . end () ) {
      cerr << "Error: SpaceTimeNode not found in getCorrespondingNode"
           << endl ; exit ( 1 ) ; } return ii -> second ; }

  void sortTimes ()
  { sort ( _stn . begin () , _stn . end () , LessSTN () ) ; }

  X_SpaceTimeNode const * getExit () const { return _myexit ; }

  vector < X_SpaceTimeNode * > :: iterator firstNode ()
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: iterator lastNode ()
  { return _stn . end () ; }
  vector < X_SpaceTimeNode * > :: const_iterator firstNode () const
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: const_iterator lastNode () const
  { return _stn . end () ; }

  X_OD_Station_Container :: iterator firstOD ()
  { return _odc -> begin () ; }
  X_OD_Station_Container :: iterator lastOD ()
  { return _odc -> end () ; }
  X_OD_Station_Container :: const_iterator firstOD () const
  { return _odc -> begin () ; }
  X_OD_Station_Container :: const_iterator lastOD () const
  { return _odc -> end () ; }
} ;


class X_Station_Creator
  : public STA_Expander :: ObjectCreator
{
public :
  X_Station_Creator ()
  { add_to_creators_list ( "x_station" ) ; }
  X_Station_Creator ( const char * x )
    : STA_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  X_Station_Base * create () const
  { cerr << "Error: X_Station... default constructor prohibited" << endl ;
    exit ( 1 ) ; }
  X_Station_Base * create ( TiXmlNode const * const & x ) const
  { return new X_Station ( x ) ; }
} ;



class X_Station_Container
  : public RS_ObjectContainer
{
public :
  bool create ( TiXmlNode const * & , vector < string > const & ,
                vector < RS_Object * > const & ) ;
  X_Station_Base * locateStation ( string const & ) ;
  X_Station_Base const * locateStation ( string const & ) const ;
  ~X_Station_Container () {}
} ;




#endif // X_Station_HH
