// -*- C++ -*-

#include "Test_TalkingAnimals.hh"

// -----
// "Talking tigers".
// 「話す虎」。
// -----
class Test_TalkingTiger
  : public Test_TalkingAnimal ,
    public TA_Expander
{
  explicit Test_TalkingTiger () ;
public :
  explicit Test_TalkingTiger ( TiXmlNode const * const & x )
    : Test_TalkingAnimal ( x ) {}
  
  void talk () const { cout << _talk << " GRRRRR!" << endl ; }
  ~Test_TalkingTiger () {}
} ;


// -----
// Creator of class Test_TalkingTiger.
// Test_TalkingTiger クラスの Creator.
// -----
class Test_TalkingTiger_Creator
  : public TA_Expander :: ObjectCreator
{
public :
  Test_TalkingTiger_Creator ()
  { add_to_creators_list ( "talking_tiger" ) ; }
  Test_TalkingTiger_Creator ( const char * x )
    : TA_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  Test_TalkingAnimal * create () const
  {
    cerr << "Error: Test_TalkingTiger... default constructor prohibited"
         << endl ;
    exit ( 1 ) ;
  }
  Test_TalkingAnimal * create ( TiXmlNode const * const & x ) const
  { return new Test_TalkingTiger ( x ) ; }
} ;
