// -- This may look like C code, but it's really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// rtss_path.hh --- declaration of class RTSS_Path_String, using PCRE library
// -----
// ChangeLog:
// 2007. 11. 20
//  File created.
// -----


#ifndef ___RTSS_PATH_HH
#define ___RTSS_PATH_HH	// こうしておくと2度インクルードしても大丈夫！

#include <string>

using std :: string ;



// -----
// Variable for PCRE.
// PCRE用の変数.
// -----
const int RP_OVECCOUNT = 30 ;
const int RP_PATHMAX = 16384 ;

class RTSS_Path_String
  : public string
{
private :
  int * ovector ;

public :

  // -----
  // Constructors
  // コンストラクタ
  // -----
  RTSS_Path_String () ;
  RTSS_Path_String ( const char * ) ;
  RTSS_Path_String ( const string & ) ;
  RTSS_Path_String ( const RTSS_Path_String & ) ;

  // -----
  // Substitution operator
  // 代入演算子
  // -----
  RTSS_Path_String & operator= ( const RTSS_Path_String & ) ;

  // -----
  // Destructor
  // デストラクタ
  // -----
  ~RTSS_Path_String () { delete [] ovector ; }

  // -----
  // Returns true if the full path name is of Windows style. If true, the
  // drive name will be set to the argument string variable, and the path
  // name in the class will be truncated.
  // ウィンドウズ・スタイルのフルパス名である場合 true を返す. True なら，
  // そのさい string 引数にドライブ名がセットされ，クラスに格納されている
  // ファイル名はドライブ名を取り去られる.
  // -----
  bool isWindowsStyleFullPath ( string & ) ;

  // -----
  // Returns true if the name has .xml extension.
  // .xml 拡張子を持つ場合 true を返す.
  // -----
  bool hasXmlExtension () const ;

  // -----
  // Process Path. Arguments: whether it is windows-style (bool), current
  // drive (const string &), current directory (const string &), resulting
  // file drive name (string &), resulting file directory name (string &),
  // resulting file name (string &). Returns true if successful.
  // パス名を処理する. 引数: ウィンドウズ・スタイルか否か (bool), カレント
  // ドライブ (const string &), カレントディレクトリ (const string &),
  // 結果的なファイルのドライブ名 (string &), 同ディレクトリ名 (string &),
  // 同ファイル名 (string &). 成功すれば true.
  // -----
  bool processPath ( bool , const string & , const string & ,
                     string & , string & , string & ) ;
} ;

#endif /* ! ___RTSS_PATH_HH */
