// -*- C++ -*-

#ifndef Sujic_Weight_HH
#define Sujic_Weight_HH

#include <iostream>
#include "RS_Object.hh"

using std :: ostream ;


const int LARGENUM = 10000 ;


class Sujic_Weight
  : public virtual RS_Object
{
  int _time ;
  int _transfers ;
  int _time_walk ;
  int _time_wait ;

public :

  Sujic_Weight ()
    : RS_Object () , _time ( 0 ) , _transfers ( 0 ) , _time_walk ( 0 ) ,
      _time_wait ( 0 ) {}

  Sujic_Weight ( int _t, int _tf , int _twk , int _twt )
    : RS_Object () , _time ( _t ) , _transfers ( _tf ) ,
      _time_walk ( _twk ) , _time_wait ( _twt ) {}
  
  Sujic_Weight ( Sujic_Weight const & x )
    : RS_Object ( x ) , _time ( x . _time ) , _transfers ( x . _transfers ) ,
      _time_walk ( x . _time_walk ) , _time_wait ( x . _time_wait ) {}

  Sujic_Weight getHalf () const
  { return Sujic_Weight
      ( _time / 2 , _transfers / 2 , _time_walk / 2 , _time_wait / 2 ) ; }

  friend ostream & operator<< ( ostream & , Sujic_Weight const & ) ;
  friend bool operator< ( Sujic_Weight const & , Sujic_Weight const & ) ;
  friend bool operator== ( Sujic_Weight const & , Sujic_Weight const & ) ;
  friend Sujic_Weight operator+
  ( Sujic_Weight const & , Sujic_Weight const & ) ;
  friend Sujic_Weight operator-
  ( Sujic_Weight const & , Sujic_Weight const & ) ;

  Sujic_Weight & operator+= ( Sujic_Weight const & ) ;

} ;

#endif // Sujic_Weight_HH
