// -*- C++ -*-

// ダイクストラ法のデモ


#include <vector>
#include <iostream>
#include <cstdlib>

#include "RS_Object.hh"
#include "X_SpaceTimeNode.hh"
#include "RS_XmlReader.hh"
#include "Expandable.hh"


#ifndef X_Train_HH
#define X_Train_HH


using std :: vector ;
using std :: cerr ;
using std :: endl ;



struct X_Train_Time_Initialiser
{
  string _station ;
  bool _dep ;
  int _t_ ;

  X_Train_Time_Initialiser
  ( string const & _sx , bool _d_in , int _t_in )
    : _station ( _sx ) , _dep ( _d_in ) , _t_ ( _t_in ) {}
} ;



class X_Train_Base
  : public virtual RS_Object
{
public :
  explicit X_Train_Base ( TiXmlNode const * const & x ) {}
  explicit X_Train_Base ( string const & _n_in ) : RS_Object ( _n_in ) {}
  X_Train_Base ( X_Train_Base const & x ) : RS_Object ( x ) {}
  X_Train_Base & operator= ( X_Train_Base const & x )
  { if ( & x == this ) return * this ;
    RS_Object :: operator= ( x ) ; return * this ; }

  virtual X_SpaceTimeNode * setTime ( bool , int ) = 0 ;
  virtual vector < X_SpaceTimeNode * > :: iterator firstNode () = 0 ;
  virtual vector < X_SpaceTimeNode * > :: iterator lastNode () = 0 ;
  virtual vector < X_SpaceTimeNode * > :: const_iterator
  firstNode () const = 0 ;
  virtual vector < X_SpaceTimeNode * > :: const_iterator
  lastNode () const = 0 ;

  virtual vector < X_Train_Time_Initialiser > :: iterator
  firstTimeInitialiser () = 0 ;
  virtual vector < X_Train_Time_Initialiser > :: iterator
  lastTimeInitialiser () = 0 ;
  virtual vector < X_Train_Time_Initialiser > :: const_iterator
  firstTimeInitialiser () const = 0 ;
  virtual vector < X_Train_Time_Initialiser > :: const_iterator
  lastTimeInitialiser () const = 0 ;
} ;


typedef Expandable < X_Train_Base , TiXmlNode const * > TRN_Expander ;


class X_Train
  : public X_Train_Base ,
    public TRN_Expander
{
  vector < X_SpaceTimeNode * > _stn ;
  vector < X_Train_Time_Initialiser > _si ;

  explicit X_Train ( string const & ) ;
  X_Train ( X_Train const & ) ;
  X_Train & operator= ( X_Train const & ) ;

public :

  explicit X_Train ( TiXmlNode const * const & ) ;

  X_SpaceTimeNode * setTime ( bool _dep_ , int _t_ )
  { X_SpaceTimeNode * ret_val = new X_SpaceTimeNode ( _dep_ , _t_ , this ) ;
    _stn . push_back ( ret_val ) ; return ret_val ; }

  vector < X_SpaceTimeNode * > :: iterator firstNode ()
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: iterator lastNode ()
  { return _stn . end () ; }
  vector < X_SpaceTimeNode * > :: const_iterator firstNode () const
  { return _stn . begin () ; }
  vector < X_SpaceTimeNode * > :: const_iterator lastNode () const
  { return _stn . end () ; }

  vector < X_Train_Time_Initialiser > :: iterator firstTimeInitialiser ()
  { return _si . begin () ; }
  vector < X_Train_Time_Initialiser > :: iterator lastTimeInitialiser ()
  { return _si . end () ; }
  vector < X_Train_Time_Initialiser > :: const_iterator
  firstTimeInitialiser () const { return _si . begin () ; }
  vector < X_Train_Time_Initialiser > :: const_iterator
  lastTimeInitialiser () const { return _si . end () ; }
} ;



class X_Train_Creator
  : public TRN_Expander :: ObjectCreator
{
public :
  X_Train_Creator ()
  { add_to_creators_list ( "x_train" ) ; }
  X_Train_Creator ( const char * x )
    : TRN_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  X_Train_Base * create () const
  { cerr << "Error: X_Train... default constructor prohibited" << endl ;
    exit ( 1 ) ; }
  X_Train_Base * create ( TiXmlNode const * const & x ) const
  { return new X_Train ( x ) ; }
} ;



class X_Station_Container ;



class X_Train_Container
  : public RS_ObjectContainer
{
public :
  bool create ( TiXmlNode const * & , vector < string > const & ,
                vector < RS_Object * > const & ) ;
  bool setTimes ( X_Station_Container * ) ;
  X_Train_Base * locateTrain ( string const & ) ;
  X_Train_Base const * locateTrain ( string const & ) const ;
  ~X_Train_Container () {}
} ;



#endif  // X_Train_HH
