#include <iostream>
#include <unistd.h>
#include "Ref_SOC_Curve_Container.hh"
#include "rtss_path.hh"

using std :: cin ;
using std :: cout ;
using std :: cerr ;
using std :: endl ;
using std :: string ;
using std :: vector ;
using std :: ostream ;



string current_directory = "" ;
string current_drive = "" ;
bool is_backslash = false ;

double RS_Object :: t_sim = 0 ;
double RS_Object :: delta_t = 0.25 ;


int
main
( int argc ,
  char * * argv )
{
  RS_XmlReader xread ;
  Ref_SOC_Curve_Container _soc ;
  xread [ "soc_feedforward_data" ] = & _soc ;


  // -----
  // Get the "current working directory" for this program.
  // ݂̃[LOfBNg擾B
  // -----
  char curpath [ PATH_MAX ] ;

  if ( getcwd ( curpath , PATH_MAX ) == NULL )
  {
    cerr << "Error: Getting present working directory failed" << endl ;
    exit ( 1 ) ;
  }
  else
  {
    cerr << "CWD: " << curpath << endl ;
  }
  current_directory = curpath ;
  current_drive = "" ;

  // -----
  // Check if the directory is "Windows" style. If windows, then separate the
  // drive name and the file path.
  // fBNgEBhEYX^CǂBEBhEYȂCh
  // CuƃfBNg𕪗B
  // -----
  RTSS_Path_String check_win_path ( curpath ) ;
  is_backslash = check_win_path . isWindowsStyleFullPath ( current_drive ) ;
  if ( is_backslash )
  {
    current_directory = check_win_path ;
    cerr << "Windows path, dir = " << current_directory << ", drive = "
          << current_drive << "!" << endl ;
  }
  else
  {
    cerr << "Unix path, dir = " << current_directory << ", drive = "
          << current_drive << "!" << endl ;
  }

  // ----
  // There must be one command-line argument.
  // R}hs͂ЂƂKvB
  // ----
  if ( argc != 2 )
  {
    cerr << "Error: There must be one command-line argument." << endl ;
    exit ( 1 ) ;
  }

  // -----
  // Assume the command-line argument is the file name, and process it.
  // R}hs̓t@CłƉ肵CB
  // -----
  vector < string > _files ;
  for ( -- argc ; argc ; -- argc )
  {
    RTSS_Path_String control_file ( * ++ argv ) ;
    // -----
    // Filename check (2 and thereafter) ... all processed here.
    // t@C`FbN(2 ȍ~)c ׂĂ.
    // -----
    string controlfiledrive = "" ;
    string controlfiledir = "" ;
    string controlfilename = "" ;
    if ( ! control_file . processPath
         ( is_backslash , current_drive , current_directory ,
           controlfiledrive , controlfiledir , controlfilename ) )
    {
      cerr << "ERROR: unknown error in processPath (control file)" << endl ;
      exit ( 1 ) ;
    }
    current_drive = controlfiledrive ;
    current_directory = controlfiledir ;
    string _fname_in = controlfiledrive ;
    _fname_in += controlfiledir ;
    if ( is_backslash )
    {
      _fname_in += "\\" ;
    }
    else
    {
      _fname_in += "/" ;
    }
    _fname_in += controlfilename ;
    _files . push_back ( _fname_in ) ;
    cerr << "Control file: " << _fname_in << endl << " dir = "
         << current_directory << ", drive = " << current_drive << endl ;
    xread . openXmlDocument ( _fname_in , current_drive , current_directory ) ;
    do
    {
      xread . processElement () ;
    } while ( xread . hasNextElement () ) ;
  }
  cerr << endl << endl << "Read Finished." << endl << endl ;

  Ref_SOC_Curve * x
    = dynamic_cast < Ref_SOC_Curve * > ( _soc . begin () -> second ) ;
  double ix ;
  while ( 1 )
  {
    cout << "Key in position: " ;
    cin >> ix ;
    cout << endl ;
    Ref_SOC_Curve :: _Data xx = x -> getData ( ix ) ;
    cout << "Data from the SOC Curve : SOC = " << xx . _soc
	 << ", dSOC/dx = " << xx . _dsoc_dx << endl << endl ;
  }
}
