// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// RS_Object.hh --- classes RS_Object and RS_ObjectCreator
// -----
// ChangeLog:
// 2009. 7. 10
//  File created.
// -----



#ifndef RS_Object_HH
#define RS_Object_HH


#include <cstdlib>
#include <string>
#include <map>
#include <vector>
#include <iostream>
#include "tinyxml.h"

using std :: map ;
using std :: vector ;
using std :: string ;

class RS_ObjectContainer ;

/************************************************************************
 * class RS_Object
 *  Base class of all classes.
 *  饹δ졣
 ************************************************************************/
class RS_Object
{
  string _name ;
  static double t_sim ;
  static double delta_t ;

public :
  RS_Object () : _name () {}
  RS_Object ( string const & _n_in )
    : _name ( _n_in ) {}
  RS_Object ( RS_Object const & _o_in )
    : _name ( _o_in . _name ) {}
  virtual RS_ObjectContainer * getContainer ( string const & _class_in )
  { return 0 ; }
  virtual bool acceptInitObject
  ( string const & _type_in , RS_Object * _obj_in ) { return false ; }
  string const & getName () const { return _name ; }
  void setName ( const string & _n_in ) { _name = _n_in ; }
  virtual ~RS_Object () {}
} ;



/************************************************************************
 * class RS_ObjectContainer
 ************************************************************************/
class RS_ObjectContainer
  : public virtual RS_Object ,
    public map < string , RS_Object * >
{
public :
  /************************************************************************
   * create ( string const & _class_in , vector < string > const & typestr ,
   *          vector < RS_Object * > const & typeobj )
   * : creates an object. Returns true if successful.
   *   _class_in : Name of the class used in calling create().
   *   typestr : vector of type strings, used in calls to acceptor function
   *   typeobj : vector of pointers to objects, used in calls to acceptor
   *             function
   ************************************************************************/
  virtual bool create ( TiXmlNode const * & , vector < string > const & ,
                        vector < RS_Object * > const & ) = 0 ;

  /**********************************************************************
   * locate ( const string & key_in ) : locates an object.
   *  key_in : key to the object.
   **********************************************************************/
  virtual RS_Object const * locate ( string const & ) const ;
  virtual RS_Object * locate ( string const & ) ;

  virtual ~RS_ObjectContainer ()
  {
    for ( map < string , RS_Object * > :: iterator ii = this -> begin () ;
          ii != this -> end () ; ++ ii )
    {
      if ( ii -> second )
      {
        delete ii -> second ;
      }
    }
  }
} ;



#endif	// RS_Object_HH
