// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// rf_gfile.cc --- read data from files: G file
// -----
// ChangeLog:
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <cstring>
#include <cctype>

#include "kidenrt.hh"
#include "StrPrintf.hh"

//#define DEBUG


// gradcurv.dat ɤե
void
feeder :: rf_gfile
()
{
  FILE * gpoint = fopen ( g_file , "r" ) ;
  if ( gpoint == 0 ) err_access ( g_file ) ;
  while ( 1 )
  {
    // ǽ number 򸫤Ĥޤ³
    getcommand ( gpoint , g_file ) ;
    if ( cmpcommand ( "vlimitmikomi" ) )
    {
      getdouble ( gpoint , g_file , g_vlimitmikomi ) ;
    }
    else if ( strcmp ( tmpch , "number" ) == 0 )
      break ;
    else err_eof ( g_file ) ;
  }
  if ( getint ( gpoint , ngrad ) == EOF ) err_eof ( g_file ) ;
  l_ofs << StrPrintf( "number of gradcrv data: %i" , ngrad ) << endl ;

    for ( int i = 0 ; i < ngrad ; ++ i )
    {
      gradcrv * x = new gradcrv ;
      if ( ! x )
      {
	std :: cerr << "Error: memory allocation failed in creating "
		    << "a gradcrv object" << std :: endl ;
	exit ( 40 ) ;
      }
      vec_gcv . push_back ( x ) ;

      // getGCV ( i ) . readfile ΥˤĤʤ
      l_ofs << "No." << i << " " ;
      if ( getGCV ( i ) . readfile ( gpoint ) == EOF )
	err_eof ( g_file ) ;
    }
    fclose ( gpoint ) ;
}
