// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// stn_arrv.cc --- functions for class station_obj: train arrival control
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include "stnobj.hh"
#include "train.hh"
#include "StrPrintf.hh"

using std :: cerr ;
using std :: endl ;



//#define DEBUG



// 
void
station_obj :: from_station_generate
( const train * trptr_arg )
  const
{
  /*********************************************************************
   * g_sw_station_valid  g_sw_disttrain_ended  true Ǥʤ *
   * Ƥ֤褦ݾڤ뤳                                            *
   *********************************************************************/
  station_obj * stox = ( station_obj * ) this ;	// const cast

  // ʬ to_station 塼ȯ
  int imove = stox -> which_in_to_station ( trptr_arg ) ;

  if ( imove != 0 )
  {
    cerr << "Warning: Not the first data in to_station queue removed" << endl ;
  }
  from_station temp_fs ;	// ѿ
  int temp_voie ;		// ѿ

  temp_fs . tr_ptr = data [ imove ] . tr_ptr ;
  temp_voie = temp_fs . voie = data [ imove ] . voie ;
  temp_fs . notrw = data [ imove ] . notrw ;
  temp_fs . olno = data [ imove ] . olno ;
  temp_fs . tarrive = t_sim ;	// ߻롪
  temp_fs . is_pass = data [ imove ] . is_pass ;
  temp_fs . is_at_station = true ;	// ȤꤢαؤˤΤǤ
  temp_fs . do_not_depart = false ;
  temp_fs . tdept = t_sim + data [ imove ] . tstop ;	// ˾ȯֻ
  temp_fs . tdept_delay = 0.0 ;		// Ȥꤢν
    
  if ( stox -> train_departure [ temp_voie ] . is_at_station )
  {
    l_ofs << StrPrintf ( "Error: Stn. No. %d: Track No. %d occupied" ,
                         stnno , temp_voie ) << endl ;
    cerr << StrPrintf ( "Error: Stn. No. %d: Track No. %d occupied" ,
                        stnno , temp_voie ) << endl ;
    l_ofs << StrPrintf
      ( "       Car Nos. %d, %d" ,
        stox -> train_departure [ temp_voie ] . tr_ptr -> car_number () ,
        temp_fs . tr_ptr -> car_number () ) << endl ;
    cerr << StrPrintf
      ( "       Car Nos. %d, %d" ,
        stox -> train_departure [ temp_voie ] . tr_ptr -> car_number () ,
        temp_fs . tr_ptr -> car_number () ) << endl ;
    exit ( 62 ) ;
  }

  // train_departure [ i ] . notrw 򹹿
  // notrwtab [ notrw ] ⹹
  int xnotrw = 0 ;
  for ( int i = 0 ; i < nvoie ; ++ i )
  {
    if ( stox -> notrwtab [ i ] )
    {
      continue ;
    }
    if ( xnotrw < temp_fs . notrw )
    {
      ++ xnotrw ;
      continue ;
    }
    stox -> notrwtab [ i ] = true ;
    temp_fs . notrw = i ;
    break ;
  }

  // ֻʬե饯奨Τε
  stox -> stationstop_variation_func ( temp_fs , imove ) ;

  // train_departure ˥å
  stox -> train_departure [ temp_voie ] = temp_fs ;

  // to_station 󤫤ǡű
  stox -> remove ( imove ) ;

  // ַ׻
  stox -> headway_cal () ;

  for ( int i = 0 ; i < number () ; ++ i )
  {
    // ֤Ф渽Ѳٹ
    data [ i ] . tr_ptr -> tell_signal_change () ;
  }
}



// from_station ֥ȤȤ
// init ʤΤǼȤ
void
station_obj :: from_station_init
( const from_station fsarg )
  const
{
  station_obj * stox = ( station_obj * ) this ;	// const cast
  stox -> train_departure [ fsarg . voie ] = fsarg ;
}



// to_station ֥ȤȤ
// const 򤹤
void
station_obj :: to_station_init
( to_station fsarg )
  const
{
  station_obj * stox = ( station_obj * ) this ;	// const cast
  stox -> operator+= ( fsarg ) ;
}



// ΡVanishing פΥ֥ȤΥפ򰷤
void
station_obj :: from_station_warp
( from_station fsarg )
  const
{
  station_obj * stox = ( station_obj * ) this ;	// const cast

  if ( stox -> train_departure [ fsarg . voie ] . is_at_station )
  {
    // ޤ
    stox -> warp_queue += fsarg ;
    return ;		// Ȥꤢ warp_queue ˼Ǥ
  }

  // train_departure [ i ] . notrw 򹹿
  // notrwtab [ notrw ] ⹹
  int xnotrw = 0 ;
  for ( int i = 0 ; i < nvoie ; ++ i )
  {
    if ( stox -> notrwtab [ i ] )
    {
      continue ;
    }
    if ( xnotrw < fsarg . notrw )
    {
      ++ xnotrw ;
      continue ;
    }
    stox -> notrwtab [ i ] = true ;
    fsarg . notrw = i ;
    break ;
  }

  // train_departure ˥å
  stox -> train_departure [ fsarg . voie ] = fsarg ;

  // ַ׻
  stox -> headway_cal () ;

  for ( int i = 0 ; i < number () ; ++ i )
  {
    // ֤Ф渽Ѳٹ
    data [ i ] . tr_ptr -> tell_signal_change () ;
  }
}
