// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// stn_dept.cc --- functions for class station_obj: train departure control
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>

#include "stnobj.hh"
#include "train.hh"
#include "StrPrintf.hh"

//#define DEBUG

// ֽȯ
void station_obj::this_train_will_depart
( const train* trptr_arg ) const {
    this_train_will_depart_aaa( trptr_arg );	// Ⱦ
    this_train_will_depart_baa( trptr_arg );	// Ⱦ
}	// ʬͳ: ĥ饹Ǥ2Ĥδ֤̤ʤΤ򤤤뤿

// ֽȯΡȾ
void station_obj::this_train_will_depart_aaa
( const train* trptr_arg ) const {
    station_obj* stox = ( station_obj* ) this;	// const cast

    // ʬֹȯ
    int imove = stox->which_in_train_departure( trptr_arg );

    // depart ֤ notrw  0 ǤʤȤᡪ
    if ( stox->train_departure[ imove ].notrw != 0 ) {
      l_ofs << "Error: Departing train does not have zero notrw" << endl ;
      cerr << "Error: Departing train does not have zero notrw" << endl ;
      exit ( 64 ) ;
    }

    // ȯ֤Τǡġ
    stox->train_departure[ imove ].is_at_station = false;

    // ߻ȯ
    stox->train_departure[ imove ].tdept_delay
        = t_sim - stox->train_departure[ imove ].tdept;

    stox->notrwtab[ 0 ] = false;	// notrw = 0 ȯ -> Ȥꤢ

    // train_departure[ i ].notrw 򹹿
    // notrwtab[ notrw ] ⹹
    for ( register int i = 0; i < nvoie; i++ ) {
        if ( i == imove ) continue;
        if ( stox->train_departure[ i ].is_at_station ) {
            int x_notrw
                = stox->train_departure[ i ].notrw--;
            stox->notrwtab[ x_notrw ] = false;
            stox->notrwtab[ stox->train_departure[ i ].notrw ] = true;
        }
    }
}

// ֽȯΡȾ
void station_obj::this_train_will_depart_baa
( const train* trptr_arg ) const {

    station_obj* stox = ( station_obj* ) this;	// const cast

    // ַ׻
    stox->headway_cal();

    for ( register int i = 0; i < number(); i++ ) {	// ֤Ф
        data[ i ].tr_ptr->tell_signal_change();		// Ѳٹ
    }
}

/**********************************************************
// Commented out...
void station_obj::this_train_will_depart
( const train* trptr_arg ) const {
    station_obj* stox = ( station_obj* ) this;	// const cast

    // ʬֹȯ
    int imove = stox->which_in_train_departure( trptr_arg );

    // depart ֤ notrw  0 ǤʤȤᡪ
    if ( stox->train_departure[ imove ].notrw != 0 ) {
        fprintf( stderr,
                 "Error: Departing train does not have zero notrw\n" );
        exit( 64 );
    }

    // ȯ֤Τǡġ
    stox->train_departure[ imove ].is_at_station = false;

    // ߻ȯ
    stox->train_departure[ imove ].tdept_delay
        = t_sim - stox->train_departure[ imove ].tdept;

    stox->notrwtab[ 0 ] = false;	// notrw = 0 ȯ -> Ȥꤢ

    // train_departure[ i ].notrw 򹹿
    // notrwtab[ notrw ] ⹹
    for ( register int i = 0; i < nvoie; i++ ) {
        if ( i == imove ) continue;
        if ( stox->train_departure[ i ].is_at_station ) {
            int x_notrw
                = stox->train_departure[ i ].notrw--;
            stox->notrwtab[ x_notrw ] = false;
            stox->notrwtab[ stox->train_departure[ i ].notrw ] = true;
        }
    }

    // ַ׻
    stox->headway_cal();

    for ( i = 0; i < number(); i++ ) {		// ֤Ф
        data[ i ].tr_ptr->tell_signal_change();	// Ѳٹ
    }
}
*****************************************************************/
