// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// feed_y.cc --- class feed_y functions
// $Id: feed_y.cc,v 2.4 1994/12/27 12:03:47 rt Exp $

#include <cstdio>
#include <cmath>
#include <cstdlib>

#include "feed_y.hh"

feed_y::feed_y
(feed_y& x) {	    // X(X&)
    mmax = 0;
    membercopy(x);
    hh = x.hh;	    dy = x.dy;
    ht = x . ht ;
}

feed_y& feed_y::operator=
(feed_y& x) {	    // 
    if (&x == this) return *this;
    membercopy(x);
    hh = x.hh;	    dy = x.dy;
    ht = x . ht ;
    return *this;
}

diagmatrix& feed_y::diag_y
() {	// ֥ɥߥ󥹹
    dy.renewmn(num);
    for (register int i = 0; i < num; i++) {
	dy(i) = 1.0 / data[i].impedance;
    }
    return dy;
}


matrix& feed_y::h
(int ncss) {	// ݻ³, : ncss
    hh.renewmn(ncss, num);
    for (register int i = 0; i < num; i++) {
	hh( operator[](i).startnode, i ) = 1;
	hh( operator[](i).endnode, i ) = -1;
    }
    return hh;
}



// ٹ, : ncss, ymtx
void
feed_y :: y
( int ncss ,
  matrix & _ymtx )
{
  h ( ncss ) ;	// ³η׻, ̤ hh ˳ǼƤ
  matrix _ht ;
  hh . transpose ( _ht ) ;    // ³ž֤
  matrix _zz = hh * diag_y () ;
  _ymtx = _zz * _ht;	    // Y = H * D * H^T
}
