// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// feed_y.hh --- class feed_y calculating Y matrix from bran_node data
// $Id: feed_y.hh,v 2.4 1994/12/27 12:03:47 rt Exp $

#include "matrix.hh"
#include "NoRefTable.hh"
#include <vector>
#include <stdexcept>


using std :: vector ;



#ifndef ___FEED_Y_HH
#define ___FEED_Y_HH		// Ƥ2٥󥯥롼ɤƤס

// ֥ǡ
struct bran_node
{
  int nfline ;		// Υ֥бֹ
  int startnode ;	// ֥
  int endnode ;	// ֥
  double impedance ;	// ֥ԡ
} ;



class _BN_Container
  : private vector < bran_node >
{
public :
  typedef size_type bn_size_type ;
  typedef iterator bn_iterator ;

  bn_iterator bn_begin () { return begin () ; }
  bn_iterator bn_end () { return end () ; }
  bn_size_type bn_size () { return size () ; }
  void bn_push_back ( bran_node x ) { push_back ( x ) ; }

  bran_node & getElement ( bn_size_type i )
  { try { return at ( i ) ; } catch ( std :: out_of_range )
    { cerr << "Error: subscript out of range (_BN_Container)" << endl ;
      exit ( 26 ) ; } }
  
  bran_node const & getElement ( bn_size_type i ) const
  { try { return at ( i ) ; } catch ( std :: out_of_range )
    { cerr << "Error: subscript out of range (_BN_Container)" << endl ;
      exit ( 26 ) ; } }

  _BN_Container () : vector < bran_node > () {}
  _BN_Container ( _BN_Container const & x ) : vector < bran_node > ( x ) {}

} ;

  

// feedline 饹󶡤ˤٹ
class feed_y
  : public NoRefTable < bran_node >
{

  matrix hh ;		// ݻ³, h(int) ˤ
  matrix ht ;
  diagmatrix dy ;	// ֥ɥߥ󥹹, diag_y() ˤ

  void error26_name () {
    cerr << "Error: subscript out of range in feed_y object "
         << "bran_node data call" << endl ;
  }

  matrix & h (int) ;	// ݻ³, : ncss, y(int) Ƥ
  diagmatrix & diag_y () ;	// ֥ɥߥ󥹹

public :

  feed_y () : NoRefTable < bran_node > () {}		// empty constructor
  ~feed_y () {}		// destructor
  feed_y ( feed_y & x ) ;	// X(X&)
  feed_y & operator= ( feed_y & ) ;	// 
  inline int branch () { return number () ; }	// ֥֤

  matrix & h () { hh . transpose ( ht ) ; return ht ; }

	// hh ž: y(int) θƤ֤
  diagmatrix & branchadmittance () { return dy ; }
	// ֥ɥߥ󥹹: y(int) θƤ֤

  void y ( int , matrix & ) ;	// ٹ, : ncss, ymtx

} ;

#endif /* ! ___FEED_Y_HH */
