// -- This may look like C code, but it's really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// rtss_path.hh --- declaration of class RTSS_Path_String, using PCRE library
// -----
// ChangeLog:
// 2007. 11. 20
//  File created.
// -----


#ifndef ___RTSS_PATH_HH
#define ___RTSS_PATH_HH	// Ƥ2٥󥯥롼ɤƤס

#include <string>

using std :: string ;



// -----
// Variable for PCRE.
// PCREѤѿ.
// -----
const int RP_OVECCOUNT = 30 ;

class RTSS_Path_String
  : public string
{
private :
  int * ovector ;

public :

  // -----
  // Constructors
  // 󥹥ȥ饯
  // -----
  RTSS_Path_String () ;
  RTSS_Path_String ( const char * ) ;
  RTSS_Path_String ( const string & ) ;
  RTSS_Path_String ( const RTSS_Path_String & ) ;

  // -----
  // Substitution operator
  // 黻
  // -----
  RTSS_Path_String & operator= ( const RTSS_Path_String & ) ;

  // -----
  // Destructor
  // ǥȥ饯
  // -----
  ~RTSS_Path_String () { delete [] ovector ; }

  // -----
  // Returns true if the full path name is of Windows style. If true, the
  // drive name will be set to the argument string variable, and the path
  // name in the class will be truncated.
  // ɥΥեѥ̾Ǥ true ֤. True ʤ顤
  // Τ string ˥ɥ饤̾åȤ졤饹˳ǼƤ
  // ե̾ϥɥ饤̾.
  // -----
  bool isWindowsStyleFullPath ( string & ) ;

  // -----
  // Returns true if the name has .xml extension.
  // .xml ĥҤľ true ֤.
  // -----
  bool hasXmlExtension () const ;

  // -----
  // Process Path. Arguments: whether it is windows-style (bool), current
  // drive (const string &), current directory (const string &), resulting
  // file drive name (string &), resulting file directory name (string &),
  // resulting file name (string &). Returns true if successful.
  // ѥ̾. : ɥ뤫ݤ (bool), 
  // ɥ饤 (const string &), ȥǥ쥯ȥ (const string &),
  // ŪʥեΥɥ饤̾ (string &), Ʊǥ쥯ȥ̾ (string &),
  // Ʊե̾ (string &).  true.
  // -----
  bool processPath ( bool , const string & , const string & ,
                     string & , string & , string & ) ;
} ;

#endif /* ! ___RTSS_PATH_HH */
