// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// train.hh --- header file that defines class train and related classes
// -----
// ChangeLog:
// 2010. 1. 22
//  Moved some global variables related to class traindata to the member
//  variables of class traindata.
// 2010. 1. 19
//  Removed tracf(). Created new member function getTractiveEffort() member
//  function in class train::_ParamFunc.
//  Removed sw_dtracf member variable.
// 2010. 1. 18
//  Moved ttvi_power() so it is now member of class train::_ParamFunc.
// 2010. 1. 17
//  Created train::_ParamFunc class. Moved ttvi_brake() so it is now the
//  member function of the new class.
// 2009. 11. 26
//  Added train::trn_ess member variable.
// 2008. 1. 18
//  Added train::writeToCSV(), train::writeHeaderToCSV() functions.
// -----

#include <cstdio>
#include <cstdlib>
#include <string>

#include "nextsta.hh"
#include "elecchar.hh"


#ifndef ___TRAIN_HH
#define ___TRAIN_HH		// Ƥ2٥󥯥롼ɤƤס

using std :: string ;




// ----
// ֱư˴ؤǡȴؿ
// ֱư˴ؤǡȴؿ
// ----
class trainmotion
  : public elecchar
{

protected :
// ѿ

  // ѹʤ
  double rsc_ad ;	// 1.65
  double rsc_bd ;	// .0247
  double rsc_at ;	// .78
  double rsc_bt ;	// .028
  double rsc_cc ;	// .0358
  double rsc_cl ;	// .0078       : 񹳷(̾)
  double wdrivee ;	// ưϼּ
  double wloadd ;	// ưϼֻҲٽ
  double wtraile ;	// տּ
  double wloadt ;	// տֻҲٽ

  // ѹʤ
  double cresist ;	// 񹳷
  double wrotate ;	// ž̷
  double abh ;   	// ʿóľ®
  int setnum ;  	// ξ

  // ץѹ
  double conges ;	// 

  // ϹԻconges ˤΤ߰¸ setconges ѹ
  double vlow_p ;	// ǽʬ®١㤤
  double vhigh_p ;	// ǽʬ®١ʹ⤤
  double constf_p ;	// ȥ륯ĥ
  double ampmax_p ;	// ή

  // ֥졼conges ˤΤ߰¸ setconges ѹ
  double vlow_b ;	// ǽʬ®١㤤
  double vhigh_b ;	// ǽʬ®١ʹ⤤
  double constf_b ;	// ȥ륯ĥ
  double ampmax_b ;	// ή
  double ampmotor_b ;	// ⡼ή

  // ؿ

public :

  trainmotion () {}	// empty constructor

  void setrsc ( double rscad , double rscbd , double rscat ,
                       double rscbt , double rsccc , double rsccl )
  { // 񹳷Υå
    rsc_ad = rscad ; rsc_bd = rscbd ; rsc_at = rscat ;
    rsc_bt = rscbt ; rsc_cc = rsccc ; rsc_cl = rsccl ;
  }

  void setweight ( double wd , double wld , double wt , double wlt )
  { // ξšٽͤΥå
    wdrivee = wd ; wloadd = wld ; wtraile = wt ; wloadt = wlt ; }

  void setmres ( double cr , double wr , double ab , int stn )
  { // ¾Υå
    cresist = cr ; wrotate = wr ; abh = ab ; setnum = stn ;
  }

  double wall ( double cg )
  { return wdrivee + wtraile + cg * ( wloadd + wloadt ) ; }

  double wall () { return wall ( conges ) ; }	// 

  double wdrive ( double cg ) { return wdrivee + cg * wloadd ; }
  double wdrive () { return wdrive ( conges ) ; }	// ưϼֽ

  double wtrail ( double cg ) { return wtraile + cg * wloadt ; }
  double wtrail () { return wtrail ( conges ) ; }	// տֽ

  double eqrot () ;		// ž̷

} ;

struct pbchar
{
  double conges ;	// Ψ (ɽǤϤʤ )
  double mcurr ;	// ή
  double lowvel ;	// ΰ貼®
  double highvel ;	// ΰ®
  double tracf ;	// ȥ륯ΰĥϡtf
  double motorcurr ;	// ⡼ή (A )
} ;


// ϹԻǡ
struct powerdata
{
  pbchar pbempty ;
  pbchar pbmid ;
  pbchar pbfull ;	// ǡμʬʶֻ֡֡
  double ec ;		// żŰ
  double zerocur ;	// 0 km/h ή
  double minvol ;	// Ű
  double bminvol ;	// ѺŰ
  double maxvol ;	// ǹŰ
} ;


// ǡ
struct brakedata
{
  pbchar pbempty ;
  pbchar pbmid ;
  pbchar pbfull ;	// ǡμʬʶֻ֡֡
  double ec ;		// żŰ
  double regenoff ;	// ®
  double minvol ;	// Ű
  double bminvol ;	// ѺŰ
  double maxvol ;	// ǹŰ
  double startvol ;	// ʤ߳Ű
  double regendvol ;	// ʤ߽λŰ
  double regendantei ;	// ʤ߽λΰ경Τή
} ;


// rnotch ưѥǡ
struct autodata
{
  double minvel ;  	// Ϲή³®
  double fullvel ; 	// Ϲή¥ե¹Գ®
  double pminvol ; 	// Ϲή³Ű(V2 )
  double poffvol ; 	// ϹήȤʤ®(V1 )
  double pminvolx ; 	// V2 ν
  double poffvolx ; 	// V1 ν
  double crbvol ;  	// ƹԻϹԤϤŰ(V3 )
  double crfvol ;  	// ƹԻϹԥեȤʤŰ(V4 )
} ;


// ----
// Forward declaration of class ESS_OnBoard
// class ESS_OnBoard  forward declaration
// ----
class ESS_OnBoard ;



// ֥ǡɤ߹ѥ饹
class traindata
  : public readdata
{

public :	// Υ饹¤ struct Ʊ

  cs_command ccx ;	// ԡåΥȥե饰
  powerdata p ;		// Ϲԥǡ
  brakedata b ;		// Ϲԥǡ
  autodata a ;		// ԡåѥǡ̾ϰ̣ʤ
  double cong ;		// Ψ
  double auxcurr ;	// 䵡ήήǥ
  double wta ;		// Mֽ
  double wtb ;		// Mֲٽ
  double wtc ;		// Tֽ
  double wtd ;		// Tֲٽ
  double rca , rcb , rcc , rcd , rce , rcf ;	// 񹳷
  double mra ;		// 񹳷
  double mrb ;		// ž̷
  double mrc ;		// ʿó®
  int mrd ;		// ξ

  // ----
  // On-board energy storage system model.
  // ֺܥͥ륮֥ǥ롣
  // ----
  ESS_OnBoard * _ess ;

  //********************************************************************//
  // Variables that used to be "global" and were defined in globvar.hh. //
  //  globvar.hh ˤä֥Хѿ.                      //
  //********************************************************************//

  // ----
  // If true, give maximum system voltage independent of the regeneration
  // limiter high threshold voltage. Not referred in any other classes.
  // ʤ߽λŰǹŰȰۤʤ true. ¾Υ饹ǤϻȤ
  // Ƥʤ
  // ----
  bool sw_different_regend ;

  // ----
  // If true, auxiliary load level is specified in kilowatt rather than
  // ampere. Referred in train::ttvi_auxcurr() member function.
  // 줬 true ΤȤ䵡Ϥ A Ǥʤ kW Ϳ롣Class train 
  // дؿ train::ttvi_auxcurr() ǻȤƤ롣
  // ----
  bool sw_aux_power ;

  // ----
  // If true, use motor current to decide whether to activate regeneration
  // limiter. Referred in train::ttvi_brake() member function.
  // 줬 true ΤȤʹԤݤ⡼ήȽ̤롣
  // Class train Υдؿ train::ttvi_brake() ǻȤƤ롣
  // ----
  bool sw_torque_shibori ;

  // ----
  // If true, use INFERIOR regeneration limiter characteristics (especially
  // when the payload weight is small). Referred to in train::ttvi_brake().
  // 줬 true ΤȤä˲ٽŤȤǽ㤯ʤʹ
  // Ѥ롣Class train Υдؿ train::ttvi_brake() ǻȤƤ롣
  // ----
  bool sw_shibori_parallel ;

  // ----
  // If true, distinguish "regeneration limiting" and "regeneration failure".
  // If false, the latter is the special case of the former, i.e. regenerated
  // power is zero because of the limiter. Referred to in train::ttvi_brake().
  // 줬 true ΤȤʹȲ̤롣false ξ硤Ԥñ
  // Ԥüʾʲѥޤǹʤޤ줿֡ˤˤʤʤ롣
  // Class train Υдؿ train::ttvi_brake() ǻȤƤ롣
  // ----
  bool sw_regenoffantei ;

  // ----
  // If true, whether regeneration fails is determined based on traction
  // motor current rather than the pantograph current. Referred to in
  // train::regendead().
  // 줬 true ΤȤʹ뤫ɤϥѥήǤϤʤ⡼
  // ήˤȽꤵ롣ؿ train::regendead() ǻȤƤ롣
  // ----
  bool sw_anteimotor ;

  //********************************************************************//
  // Functions                                                          //
  // ؿ                                                               //
  //********************************************************************//

  void readfile ( FILE * , char * ) ;	// ե꡼

  // ----
  // Reading the XML-style input file.
  // XMLե꡼ɡ
  // ----
  void readfile_xml ( TiXmlNode const * , string const & ) ;

  // Constructor
  traindata ()
    : cong ( 0 ) , auxcurr ( 0 ) , wta ( 0 ) , wtb ( 0 ) , wtc ( 0 ) ,
      wtd ( 0 ) , rca ( 0 ) , rcb ( 0 ) , rcc ( 0 ) , rcd ( 0 ) , rce ( 0 ) ,
      rcf ( 0 ) , mra ( 0 ) , mrb ( 0 ) , mrc ( 0 ) , mrd ( 0 ) ,
      _ess ( 0 ) , sw_different_regend ( false ) , sw_aux_power ( false ) ,
      sw_torque_shibori ( false ) , sw_shibori_parallel ( false ) ,
      sw_regenoffantei ( false ) , sw_anteimotor ( false )
  { _ess = new No_ESS_OnBoard ; }

} ;



// ----
// Object in which parameter functions for a train are to be calculated.
// ֤Τ޲ѿѴؿα黻.
// ----
class train_ParamFunc
{
private :

  // ----
  // Well, this kind of thing might be useful...
  // ޤΤ⤢äۤǤ礦
  // ----
  int __carno ;		// ξֹ: (= csno - nss )

  // ----
  // Regenerative performance parameters.
  // ϲǡ.
  // ----
  brakedata __bd ;

  // ----
  // Acceleration performance parameters.
  // Ϲǽǡ.
  // ----
  powerdata __pd ;
    
  // ----
  // Braking performance parameters.
  // ֥졼ǽѥ᡼.
  // ----
  double __vlow_b ;	// ǽʬ®١㤤
  double __vhigh_b ;	// ǽʬ®١ʹ⤤
  double __constf_b ;	// ȥ륯ĥ
  double __ampmax_b ;	// ή
  double __ampmotor_b ;	// ⡼ή

  // ----
  // Powering performance parameters.
  // ϹԻǽѥ᡼.
  // ----
  double __vlow_p ;	// ǽʬ®١㤤
  double __vhigh_p ;	// ǽʬ®١ʹ⤤
  double __constf_p ;	// ȥ륯ĥ
  double __ampmax_p ;	// ή

  // ----
  // Parameters used by member function ttvi_brake().
  // дؿ ttvi_brake() Ѥѥ᡼.
  // ----
  double __pos ;
  double __vel ;
  double __tt ;
  double __v ;
  double __dv ;
  double __rnotch ;
  double __rnotch_for_capper ;
  double __a ;
  double __a_wo_capper ;
  double __a_main_circuit ;
  double __di ;
  double __noshibo ;
  double __dnch ;
  bool __sw_regendead ;
  bool __is_limiting_regen ;
  // bool __emccal ;
  // double __emrn ;

  // ----
  // Pointer to an on-board energy storage system.
  // ֺܥͥ륮֤ؤΥݥ󥿡
  // ----
  ESS_OnBoard * trn_ess ;

  // ----
  // Maximum tractive and braking effort. Calculated by the member function
  // prepareMaximumEffort(). Note that in function getMaxBrakingEffort(),
  // the sign of __max_braking_effort is reversed when returning the value.
  // 縣ϡ֥졼ϡдؿ prepareMaximumEffort() ˤ׻
  // 롣getMaxBrakingEffort() ؿǤ __max_braking_effort ͤ
  // ȿž뤳Ȥա
  // ----
  double __max_tractive_effort ;
  double __max_braking_effort ;

  // ----
  // If true, use motor current to decide whether to activate regeneration
  // limiter. Used to be g_sw_torque_shibori in globvar.hh.
  // 줬 true ΤȤʹԤݤ⡼ήȽ̤롣
  // ĤƤ globvar.hh  g_sw_torque_shibori ȤƤ
  // ----
  bool __sw_torque_shibori ;

  // ----
  // If true, use INFERIOR regeneration limiter characteristics.
  // Used to be g_sw_shibori_parallel in globvar.hh.
  // 줬 true ΤȤä˲ٽŤȤǽ㤯ʤʹ
  // 롣Ĥ globvar.hh  g_sw_shibori_parallel ȤƤ
  // ----
  bool __sw_shibori_parallel ;

  // ----
  // If true, distinguish "regeneration limiting" and "regeneration
  // failure". If false, the latter is the special case of the former, i.e.
  // regenerated power is zero because of the limiter. Used to be
  // g_sw_regenoffantei in globvar.hh.
  // 줬 true ΤȤʹȲ̤롣false ξ硤Ԥ
  // ñԤüʾʲѥޤǹʤޤ줿֡ˤˤʤ
  // ʤ롣Ĥ globvar.hh  g_sw_regenoffantei ȤƤ
  // ----
  bool __sw_regenoffantei ;

  // ----
  // Pointer to an nextsta data.
  // nextsta ǡʼإǡˤؤΥݥ󥿡
  // ----
  nextsta const * __nxx ;

public :

  // Constructor 
  explicit train_ParamFunc
  ( int __carno_in , brakedata const & __bd_in , powerdata const & __pd_in ,
    double __vlow_b_in , double __vhigh_b_in , double __constf_b_in ,
    double __ampmax_b_in , double __ampmotor_b_in , double __vlow_p_in ,
    double __vhigh_p_in , double __constf_p_in , double __ampmax_p_in ,
    double __pos_in , double __vel_in , double __tt_in ,
    double __v_in ,			double __dv_in ,
    double __rnotch_in , double __dnch_in , double __rnotch_for_capper_in ,
    double __a_in ,			double __a_wo_capper_in ,
    double __a_main_circuit_in , double __di_in , double __noshibo_in ,
    bool __sw_regendead_in ,		bool __is_limiting_regen_in ,
    bool __sw_torque_shibori_in ,	bool __sw_shibori_parallel_in ,
    bool __sw_regenoffantei_in ,	ESS_OnBoard * trn_ess_in ,
    nextsta const * __nxx_in ) ;

  // Copy constructor
  explicit train_ParamFunc ( train_ParamFunc const & ) ;

  // Destructor
  ~train_ParamFunc () { if ( trn_ess ) delete trn_ess ; }

  // ----
  // Subprograms of teta_vi().
  // teta_vi() Υ֥ץ.
  // ----
  void ttvi_brake () ;
  void ttvi_power () ;
  void ttvi_RegenLimiter () ;

  // ----
  // Routine around the energy storage system
  // ͥ륮֤ߤν.
  // ----
  void ttvi_ess () ;

  // ----
  // Functions related to the calculation of tractive and braking effort.
  // ϡ֥졼Ϸ׻Ϣδؿ.
  // ----
  void prepareMaximumEffort () ;
  double getTractiveEffort () const ;

  // ----
  // Setting variables.
  // ѿ򥻥åȤ롣
  // ----
  void setVelocity ( double x ) { __vel = x ; }
  void setVoltage ( double x ) { __v = x ; }
  void setNotchRate ( double x ) { __rnotch = x ; }
  void setCurrent ( double x ) { __a = x ; }
  void setCurrentWithoutLimiter ( double x ) { __noshibo = x ; }
  void set_Di_Dtheta ( double x ) { __di = x ; }
  void setCurrentWithoutCapper () { __a_wo_capper = __a ; }
  void setMainCircuitCurrent ( double x ) { __a_main_circuit = x ; }
  void setMainCircuitCurrent () { __a_main_circuit = __a ; }
  void setNotchRateForCapper ( double x ) { __rnotch_for_capper = x ; }
  
  // ----
  // Getting data and results.
  // ǡ̤롣
  // ----
  nextsta const * getNextsta () const { return __nxx ; }
  int getCarNumber () const { return __carno ; }
  double getVoltage () const { return __v ; }
  double get_dV_dTheta () const { return __dv ; }
  double getCurrent () const { return __a ; }
  double get_Di_Dtheta () const { return __di ; }
  double getCurrentWithoutLimiter () const { return __noshibo ; }
  double getCurrentWithoutCapper () const { return __a_wo_capper ; }
  double getMainCircuitCurrent () const { return __a_main_circuit ; }
  double getNotchRateForCapper () const { return __rnotch_for_capper ; }
  bool isLimitingRegen () const { return __is_limiting_regen ; }
  double getMaxTractiveEffort () const { return __max_tractive_effort ; }
  double getMaxBrakingEffort () const { return - __max_braking_effort ; }
  double getPosition () const { return __pos ; }
  double getVelocity () const { return __vel ; }
  ESS_OnBoard const & getESS () const { return * trn_ess ; }  

private :

  // ----
  // Routine around the energy storage system
  // ͥ륮֤ߤν.
  // ----
  void ttvi_ess_ProcessRegenLimiter () ;

  // ----
  // Regeneration "taper" characteristics.
  // ʹ.
  // ----
  double ttvi_brake_shibori ( double , double , double , double ) const ;

  // ttvi_power  subpr.
  void tv_p_ne ( double , double , double , double , double ) ;

  // tv_p_ne/em  subpr.
  void tv_p_tc ( double & , double , double , double ) ;
  double tv_p_tc ( double & , double , double ) const ;
} ;



// ֥ǡȴؿ
class train
  : public trainmotion
{

  // ѿ
  bool ontprec ;	// ontime ֥롼󤬺Ǹޤã true
  bool cpsww ;  	// ƹ rnotch != 0 Ȥʤä true
  bool cpsw ;   	// ƹ˰٤Ǥ cpsww == true Ȥʤä true
//	int rntrans ;	// rnotch Ѳ 1 Ѳ
  // bool emccal ; 	// ccal ｪλʤ true
  // double emrn ; 	// ccal ｪλʤȤΥΥå
  double lenrun ;	// αش֤ޤǤˤǤäΥ
  double stpos ;	// Ϥ֡ġԵΥΤѤ
  bool b_jerk ; 	// 㡼ȥ륪ΤȤ true
  int ssno ;    	// ¦Žֹ
  double sis ;  	// ¦ŽޤǤΥԡ
  bool nosss ;  	// ¦ŽʤΤȤ true
  double iss ;  	// ¦Žή
  int seno ;    	// ¦Žֹ
  double sie ;  	// ¦ŽޤǤΥԡ
  bool nosse ;  	// ¦ŽʤΤȤ true
  double ise ;  	// ¦Žή
  bool signal_changed ; // 渽Ѳ true
  bool sigchange_repower ;  	// 渽ѲκϹԻ true
  double tarr_real ;	// 
  double a_max_regen ;	// ʹʤȲꤷή䵡ޤ

  // Žǡʸѹʤ
  sschar * sc ; 	// Žǡ
  int nss ;     	// Ž
//	double ccv ;		// Cc Žή
//	double clv ;		// Cl Žή
  double prate ;	// ϹΨ
  double ptime ;	// ϹԻ
  int pfirst ;		// Ϲ 0, ʹϹ/Τ߽λ increment
  double dtracf ;	// tracf ʬ
//   bool sw_dtracf ;	// tracf ʤߤθʤȤ true
  double zerovolt ;	// ήȤʤŰ
  bool sw_regendead ;	// ΤȤ true

  // ----
  // Pointer to an on-board energy storage system.
  // ֺܥͥ륮֤ؤΥݥ󥿡
  // ----
  ESS_OnBoard * trn_ess ;

  // -----
  // If true then suppress output to CSV file.
  // ⤷ʤ CSV եؤνϤ롣
  // -----
  bool suppress_csv ;

protected :

  // ʸѹʤ
  int carno ;	// ξֹ: (= csno - nss )
  double auxcurr ;		// 䵡ήήǥ

  // ----
  // Train type key. Given to feeder::_trd map to get the necessary traindata.
  // ξʸ󡣤 feeder::_trd ޥåפϤɬפ traindata
  // 롣
  // ----
  string const * train_type_key ;

  // ----
  // If true, auxiliary load level is specified in kilowatt rather than
  // ampere. Used to be g_sw_aux_power in globvar.hh.
  // 줬 true ΤȤ䵡Ϥ A Ǥʤ kW Ϳ롣ĤƤ
  // globvar.hh  g_sw_aux_power ȤƤΡ
  // ----
  bool sw_aux_power ;

  // ǡʸѹʤ
  powerdata pdata ;	// Ϲǡ
  brakedata bdata ;	// ǡ
  autodata adata ; 	// rnotch ưѥǡ

  // ͤͿ
  nextsta const * nxx ;	// إǡ
  double pos ; 	// ְ
  double vel ; 	// ®
  car_stat stat ;	// ־
  car_stat stat_old ;	// stat θŤ
  double tdept ;	// ؽȯ
  double taudx ;	// ؽȯ٤
  //     double taudx_delay ;	// ֤٤٤ʬФ٤

  // ׻ˤ
  double cmd_aux ;	// 䵡
  double rnotch ;	// ήȥ륯ΥեΥå-1  1
  double dnch ;	// եΥåѲΨ dr/dȡʦ=tt

  // ----
  // If true, calculate mechanical acceleration / deceleration power.
  // True ǤеŪø®ѥ׻롣
  // ----
  bool _sw_mech_power ;

  // ----
  // Mechanical acceleration / deceleration power. _mech_power_motor_ratio
  // shows the ratio (0 - 1) of _mech_power provided by electric braking.
  // ----
  double _mech_power ;
  double _mech_power_motor_ratio ;

  // ----
  // Full-notch ratio when current capper is in operation. Range: 0 - 1.
  // Current capper ƯΥեΥå. 0 - 1.
  // ----
  double rnotch_for_capper ;
  
  double rnotchold ;	// rnotch θŤ

  // nxx->dpgrad ޤۥǡΰ
  nextsta :: gc_size_type pgrad ;

  station_obj const * stnobj_now ;	// ߴط station_obj ؤ
  double a_wo_capper ;	// Current capper ʤȤή
  double a_main_circuit ;	// ϩή
  double noshibo ;	// ʤߤʤή
  double shibo ;	// ʤߤή
  double shibo_old ;	// ʤߤήŤ
  double brakev ;	// ֥졼ɸ®
  bool iamconst ;	// ֥졼ո®֤ԤȤ true
  bool iamcoast ;	// ®֤ϲΤߤǻѤȤ true
  bool sw_btws ;	// شߤΤΥ֥졼 true
  bool sw_x_btws ;	// ش֤߰᤮Ƥʤ true
  bool is_limiting_regen ;	// ʤ true
  bool is_limiting_max_curr ;	// ήʹ true

  // ----
  // If true, use motor current to decide whether to activate regeneration
  // limiter. Used to be g_sw_torque_shibori in globvar.hh.
  // 줬 true ΤȤʹԤݤ⡼ήȽ̤롣
  // ĤƤ globvar.hh  g_sw_torque_shibori ȤƤ
  // ----
  bool sw_torque_shibori ;

  // ----
  // If true, use INFERIOR regeneration limiter characteristics.
  // Used to be g_sw_shibori_parallel in globvar.hh.
  // 줬 true ΤȤä˲ٽŤȤǽ㤯ʤʹ
  // 롣Ĥ globvar.hh  g_sw_shibori_parallel ȤƤ
  // ----
  bool sw_shibori_parallel ;

  // ----
  // If true, distinguish "regeneration limiting" and "regeneration failure".
  // If false, the latter is the special case of the former, i.e. regenerated
  // power is zero because of the limiter. Used to be g_sw_regenoffantei in
  // globvar.hh.
  // 줬 true ΤȤʹȲ̤롣false ξ硤Ԥñ
  // Ԥüʾʲѥޤǹʤޤ줿֡ˤˤʤʤ롣
  // Ĥ globvar.hh  g_sw_regenoffantei ȤƤ
  // ----
  bool sw_regenoffantei ;

  // ----
  // If true, whether regeneration fails is determined based on traction
  // motor current rather than the pantograph current. Used to be
  // g_sw_anteimotor in globvar.hh.
  // 줬 true ΤȤʹ뤫ɤϥѥήǤϤʤ⡼
  // ήˤȽꤵ롣Ĥ globvar.hh  g_sw_anteimotor Ȥ
  // ----
  bool sw_anteimotor ;

public :

// ؿ

private :

  // ontime ؿѥ֥ץ

  // ֥졼λ֤εջ
  // : arv, arp, k, pos, j, vp, bt
  void brake ( double , double , nextsta :: gc_size_type , double ,
               nextsta :: gc_size_type , double & , double & ) ;

  // ֥졼ϰ֤η
  void pbx ( double , double , double , double , double , double , double & ,
	     double & , bool & , double & , double & ) ;
  void pbx ( double , double , double , double , double , double , double & ,
	     double & , bool & ) ;
             	// : av , v , ap , p , ab , a , t , vb , sw

  // ®ٱư֤αưη׻
  // : v, a, lg, t, vr, sw
  void cavt ( double , double , double , double & , double & , bool & ) ;

  bool ontvlim ( double , nextsta :: gc_size_type , double , double & ,
                 nextsta :: gc_size_type & , double & ) ;
  void ontvlc ( double , nextsta :: gc_size_type , double , double ,
                double & , nextsta :: gc_size_type & , double & , double & ,
                double , nextsta :: gc_size_type , double , bool = false ) ;
  void ontconst ( double & ) ;
  void ontcm ( double & , nextsta :: gc_size_type & , double & , double & ,
               double & , double & , double & ) ;
  void ontctoc ( double , double & , nextsta :: gc_size_type , double & ,
                 double & , double & , double & , double & ) ; 
  double ontbrake ( double , nextsta :: gc_size_type , double , double ) ;
  double ontbc ( double , nextsta :: gc_size_type , double , double ) ; 


  // nextmotion ѥ֥ץ

  double ontimesub ( double , int , double , double ) ;
  double tresist ( double x , nextsta :: gc_size_type i )
  { return tresist ( x ) + gresist ( i ) ; }	// 

  void nm_power ( double ) ;	// Ϲμֱ黻
  void nm_coast ( double ) ;	// ƹμֱ黻
  void nm_regen ( double ) ;	// Τμֱ黻
  void nm_brake ( double ) ;	// ֥졼μֱ黻
  void nm_stnstop ( double ) ;	// μֱ黻
  void nm_constv ( double ) ;	// ®μֱ黻
  bool nm_nxxps () ;		// nm_constv () , nm_coast () Υ֥롼
  void nm_stnbtws ( double ) ;	// شμֱ黻

  bool vlimitbrake () ;		// ®٤θ΢֥졼
  bool nm_stnobj_brake () ;	// ϤλѲ墪֥졼
  bool nm_stnobj_power () ;	// ϤλѲ墪®


  // teta_vi ץѥ֥ץ

  void tetavisub ( double ) ;	// : rnotch
  void vset ( double ) ;	// ŰͤΥåȡtetavisub  subprogram
  void ttvi_power () ;	// teta_vi  subprogram

  // ----
  // ttvi_brake() is now member of train_ParamFunc subclass. This function
  // creates one instance of train_ParamFunc, execute ttvi_brake() , then delete
  // the instance.
  // ttvi_brake() ϻҥ饹 train_ParamFunc Υдؿ˰ưδؿϡ
  // train_ParamFunc Υ󥹥󥹤ttvi_brake() ¹Ը󥹥󥹤
  // ˴롣
  // ----
  void ttvi_brake () ;

  // 䵡ήη׻
  void ttvi_auxcurr () ;

  // ----
  // Routine around the energy storage system
  // ͥ륮֤ߤν.
  // ----
  void ttvi_ess () ;

  // ----
  // Construction of an instance of the teta_vi calculator class
  // teta_vi ׻ѥ饹󥹥󥹤
  // ----
  train_ParamFunc * getNewParamFuncCalculator () const
  { return new train_ParamFunc
      ( carno , bdata , pdata , vlow_b , vhigh_b , constf_b , ampmax_b ,
        ampmotor_b , vlow_p , vhigh_p , constf_p , ampmax_p ,
        pos , vel , tt , v , dv , rnotch , dnch , rnotch_for_capper ,
        a , a_wo_capper , a_main_circuit , di , noshibo ,
        sw_regendead , is_limiting_regen , sw_torque_shibori ,
        sw_shibori_parallel , sw_regenoffantei , trn_ess , nxx ) ; }

  // ٽ
  double cgdef ( double , double ) ;	// cg η׻
  double cgcal ( double , double , double ) ;	// cg ˤ׻


  // Сȥ륯<->ե꡼͹礻ٽ
  double velcal_mid
  ( double , double , double , double , double , double ) ;	//ٽ®
  double ampcal_mid
  ( double , double , double , double , double , double ) ;	//ٽ®



  // notchrate  subprogram

  // ϹԻ
  void nr_power ( double & , double & ) ;		// : rnotch, dnch
  void nr_power () { nr_power ( rnotch , dnch ) ; }
  void nr_regen () ;	// 
  void nr_coast () ;	// ƹԻ
  void nr_constv () ;	// ®Ի
  void nr_p_ea ( double & , double & ) ; 	// ccmd = EcautoϹԻ
  void nr_c_ea () ; 	// ccmd = EcautoƹԻ

  to_station to_station_emit () ;	// to_station ֥Ȥ
  from_station from_station_emit () ;	// from_station ֥Ȥ

  double tdept_delay () ;	// ֤νȯ֤٤ʬ

  train ( const train & ) ;         	// constructor: X ( X & ) ػ
  train & operator= ( train & ) ; 	// ػ
  explicit train () ;	// empty constructor

public :
  train ( string const * ) ;	// empty constructor
  ~train () ;                   	// destructor

  // sc ʼξŽǡˤΰ
  void newsc ( int x ) { nss = x ; sc = new sschar [ x ] ; }

  double tresist ( double ) ; 	// ֤񹳡ʰ: vel

  bool getSuppressCSVFlag () const { return suppress_csv ; }


  // ֥졼հַ׻

  //  pos, pgrad, vel, arv
  double bklen ( double , nextsta :: gc_size_type , double , double ) ;

  //  pos, pgrad, vel
  double bklen
  ( double bkpos , nextsta :: gc_size_type jgrad , double bkvel )
  { return bklen ( bkpos , jgrad , bkvel , nxx -> varrive () ) ; }

  //  nxx->varrive ()
  double bklen ( double varr )
  { return bklen ( pos , pgrad , vel , varr ) ; }

  // ʤ
  double bklen () { return bklen ( nxx -> varrive () ) ; }



  // ԥߥ졼

  // ----
  // Disable or enable mechanical power calculation.
  // Ūѥη׻⤷ϵĤ롣
  // ----
  void disableMechanicalPowerCalculation () { _sw_mech_power = false ; }
  void enableMechanicalPowerCalculation () { _sw_mech_power = true ; }

  //  pos, pgrad, vel, tracf
  void npos ( double & , nextsta :: gc_size_type & , double & , double = 0 ) ;

  //  tracf
  void npos ( double tracff = 0 )
  { npos ( pos , pgrad , vel , tracff ) ; }

  // ֥졼 pos, pgrad, vel, tracff
  void nposb ( double & , nextsta :: gc_size_type & , double & , double = 0 ) ;

  // ֥졼 tracff
  void nposb ( double tracff = 0 ) { nposb ( pos , pgrad , vel , tracff ) ; }

  // ®Ի pos, pgrad, vel, tracff
  void nposc ( double & , nextsta :: gc_size_type & , double & , double = 0 ) ;

  // ®Իʤ
  void nposc ( double tracff = 0 ) { nposc ( pos , pgrad , vel , tracff ) ; }

  double brakef () ;	// ץ֥졼ϡtfˡ֤ͤ
  double brakef ( double ) ;	// ץ֥졼ϡtfˡ֤ͤ

  // ϡ֥졼Ϥ֤ͤ
  double getTractiveEffort () const ;
  // ----
  // There used to be a "double tracf (double, double, double = -1)" function
  // here. Three arguments were velocity, voltage and notchrate.
  // ----
  

  // Υå ( _prec ٸ )
  double ontime_prec ( double , nextsta :: gc_size_type , double , double ) ;
  double ontime_prec ( double t ) {
    return ontime_prec ( pos , pgrad , vel , t ) ;
  }
  double ontime ( double , nextsta :: gc_size_type , double , double ) ;
  double ontime ( double t ) {return ontime ( pos , pgrad , vel , t ) ;}


  // ֤θ񹳡tfˡ: pgrad
  double gresist ( nextsta :: gc_size_type jgrad )
  { return egrad ( jgrad ) * wall () / 1000 ; }

  // ֤θ񹳡tfˡ: pos
  double gresist ( double grpos )
  { return egrad ( grpos ) * wall () / 1000 ; }
		
  // ֤θ񹳡tfˡ: ʤ
  double gresist ()
  { return train :: gresist ( pgrad ) ; }
       	
  double egrad ( nextsta :: gc_size_type ) ;   	// ۡʰ: pgrad
  double egrad ( double ) ; 	// ۡʰ: pos


  // äΥ
  double runlen () { return lenrun + ( pos - stpos ) * direc () ; }
  void addlen ()
  { lenrun += ( nxx -> parrive () - stpos ) * direc () ; }


  // ֤μ֤η׻
  void nextmotion ( double ) ;

  void teta_vi () ; 	// teta  volt , ampere 
  void add_to_teta ( double , bool ) ;	// teta ˲ä
  void notchrate () ; 	// եΥåη׻
  void autodreg () ;	// autodata μư ( Ea_cvauto0 ⡼ )


  // Ƚؿ
  // ʤ / ddhh, tregendead ( simulate.cc  )
  bool regendead () { return sw_regendead ; }	// sw_regendead ñ֤
  void regendead ( double , double & ) ;

  // ߤβʤΨ
  double regenrate () const ;

  // ʹʤäȲꤷή֤ͤ
  double getCurrentWithoutRegenLimiter () const { return a_max_regen ; }
  double getNotchRateForCapper () const { return rnotch_for_capper ; }

  // Getting most recent "mechanical power".
  double getMechanicalPower () const { return _mech_power ; }
  double getRatioOfElectricEffortInMechPower () const
  { return _mech_power_motor_ratio ; }

  void setconges ( double ) ;	// Ψå ,ΨΤ߰¸η׻

  // ----
  // Setting on-board ESS module.
  // ֺܥͥ륮֥ǥȤ߹ߡ
  // ----
  void setOBESS ( ESS_OnBoard * x ) { trn_ess = x -> getMyClone () ; }

  // -----
  // Calculate voltage and current of the ESD.
  // -----
  void calculateESDVoltageAndCurrent () ;

  // -----
  // Renew the electrical state variables. Does nothing here.
  // ŵŪѿ򹹿ǤϤʤˤ⤷ʤ
  // -----
  void renewElectricalStates () ;

  // -----
  // SOC-related initialisation upon start of the simulation cycle.
  // -----
  void setStartSOC () { trn_ess -> setStartSOC () ; }

  // -----
  // Typing out SOC-related data to the RES file.
  // -----
  void printSOCStoredResults
  ( ostream & x , ostringstream & y , ostringstream & z ) const
  { trn_ess -> printSOCStoredResults ( x , y , z ) ; }

  // -----
  // Output to CSV file. Boolean argument: suppress leading comma if false.
  // CSVեؤν. Ͱ: ʤ饫ޤνϤ
  // -----
  bool writeHeaderToCSV ( ostream & , bool = true ) const ;
  bool writeToCSV ( ostream & , bool = true ) const ;

  double & gva () { return a ; }	// ¦ѿή
  double & uva () { return v ; }	// ̤¦ѿŰ
  double & dgva () { return di ; }	// ¦ʬ͡ή
  double & duva () { return dv ; }	// ̤¦ʬ͡Ű

  // ʤ true ֤ؿ
  bool isLimitingRegen () const { return is_limiting_regen ; }

  // ήʤ true ֤ؿ
  bool isLimitingMaxCurrent () const { return is_limiting_max_curr ; }

  // ήʤե饰򥻥åȡ󥻥åȤؿ
  void setMaxCurrentLimitFlag () { is_limiting_max_curr = true ; }
  void unsetMaxCurrentLimitFlag () { is_limiting_max_curr = false ; }

  // ʤ߽λŰȳŰκ nrtw ʬ1
  double getRegenTaperWidth ( int nrtw ) const
  {
    if ( nrtw <= 0 )
    {
      cerr << "Error: positive integer must be given to "
           << "train::getRegenTaperWidth ()" << endl ;
      exit ( 81 ) ;
    }
    return ( bdata . regendvol - bdata . startvol ) / nrtw ;
  }

  // bool & emgc () { return emccal ; }		// emccal ؤλ
  double asibori () const { return noshibo ; }	// ʹߤʤ I
  double sibori () const { return shibo ; }	// ʹߤ I
  double position () const { return pos ; } 	// 
  double velocity () const { return vel ; } 	// ®
  double cc () const { return ccv ; }		// Cc
  double cl () const { return clv ; }		// Cl
  cs_command ccommand () const { return ccmd ; }	// ccmd
  car_stat carstat () const { return stat ; }	// ־
  car_stat carstold () const { return stat_old ; }	// ľ־
  double rnotchvl () const { return rnotch ; }	// եΥå
  double drnotchvl () const { return dnch ; }
  bool noss () const { return nosss ; }  	// ¦Ž꤬
  bool nose () const { return nosse ; }  	// ʤ true ֤
  int ssnum () const { return ssno ; }  	// ¦Žֹ֤
  int esnum () const { return seno ; }  	// ¦Žֹ֤
  double isss () const { return iss ; }		// ¦Žή
  double isse () const { return ise ; }		// ¦Žή
  nextsta const * NextSta () { return nxx ; }
  int nfline () const { return nxx -> feedlinenumber () ; }	// ֹ
  int direc () const { return nxx -> direction () ; }	// 
  nextsta :: gc_size_type gradnumber () const
  { return pgrad ; }	// 
  feedpos & feep () {		// ٹѥǡ֤
    static feedpos x ;
    x . pos = pos ; x . csno = csno ; x . sttimp = x . endimp = 0.0 ;
    return x ;
  }
  void setsc ( sschar x , int i ) { sc [ i ] = x ; }
  void setsc ( int i , sschar x ) { sc [ i ] = x ; }	// sschar ѿ
  void zlenrun () { lenrun = 0.0 ; }	// lenrun Υꥻå
  void setstpos () { stpos = pos ; }	// stpos Υå
  void resettd ( double t ) {	// tdept , tarr_real Υꥻå
    tdept -= t ;	tarr_real -= t ;
  }
  void setstatold ( car_stat x ) { stat_old = x ; }
  void dist_iamconstcoast ( FILE * td )
  { fprintf ( td , "iamconstcoast %i %i\n" , iamconst , iamcoast ) ; }
  void diststatold ( FILE * td ) 
  { fprintf ( td , "setstatold %i\n" , stat_old ) ; }
  void set_iamconstcoast ( bool cn , bool ca )
  { iamconst = cn ; iamcoast = ca ; }
  void setstatold () { setstatold ( stat ) ; }	// stat_old Υå
  void setcmdaux ( double caux ) { cmd_aux = caux ; }	// 

  // ----
  // Setting auxiliary load data.
  // 䵡٥ǡ򥻥åȤ롣
  // ----
  void setAuxiliaryLoad ( double x , bool sw )
  { auxcurr = x ; sw_aux_power = sw ; }

  // ----
  // Setting "shibori" flags (determine how regeneration limiter will work).
  // "shibori" ե饰Υåȡʲʹư
  // ----
  void setShiboriFlags ( bool _ts , bool _sp , bool _ro , bool _am )
  { sw_torque_shibori = _ts ; sw_shibori_parallel = _sp ;
    sw_regenoffantei = _ro ; sw_anteimotor = _am ; }

  void setvar ( double p , double v , car_stat s , double td ,
                double ta , double pt ) {		// ѿͥå
    pos = p ; vel = v ; stat = s ;
    tdept = td ; taudx = ta ; ptime = pt ; }
  void distvar ( FILE * td ) {		// ѿͥ
    fprintf ( td , "setvar %.12e %.12e %i %.12e %.12e %.5f\n" ,
              pos , vel , stat , tdept , taudx , ptime ) ; }
  void setcccl ( double a , double b )			// cc , cl Υå
  { ccv = a ; clv = b ; }				//  cc , cl
  void setcscomm ( cs_command c ) { ccmd = c ; }	// ccmd å

  void setcarno ( int t ) { carno = t ; }	// ξֹΥå
  int car_number () const { return carno ; }
  int cs_number () const { return csno ; }

  string const & getTrainTypeKey () const { return * train_type_key ; }

  void setssimps ( double a , int b )	// ξε¦Žޤ
  { ssno = b ; sis = a ; }		// Υԡ󥹤򥻥å
  void setssimpe ( double a , int b )	// ξν¦Žޤ
  { seno = b ; sie = a ; }		// Υԡ󥹤򥻥å
  void setnosss () { nosss = true ; }	// ¦Žʤ 򥻥å
  void setnosse () { nosse = true ; }	// ¦Žʤ 򥻥å
  void resetnos () {			// ¦ŽȤ
    nosss = nosse = false ; }			// Ȥ
  void distnxx ( FILE * td )		// nxx Υå
  { fprintf ( td , "setnxx %i %i\n" , nxx -> dptnum () , nxx -> dpttbl () ) ; }

  // nxx Υå
  void setNextstaPointer ( nextsta const * ) ;
  void setNextstaPointer_for_disttrain ( nextsta const * ) ;
			// ( for disttrain )

  // Űå. 2007. 10. 1. Moved to trteta.cc , no longer inline
  void teta_v_only () ;

  // ޲ѿκ
  double getMaximumTeta () ;
  double getMaximumTeta ( double ) ;

  // ޲ѿκǾ
  double getMinimumTeta () ;
  double getMinimumTeta ( double ) ;

  // Ű޲ѿ
  double getTetaFromVoltage () ;
  double getTetaFromVoltage ( double ) ;

  void setviold () ;
  void restorevi () ;
  void setpbdata ( powerdata , brakedata , autodata ) ;
        	// teta_vi , notchrate ؿΤΥǡΥå

  void stnobj_init () ;		// station_obj ̿򤫤ʽ
  void stnobj_comm () ;		// station_obj ̿򤫤ʤʳ

  void tell_signal_change () const {	// 渽Ѳ̿
    ( ( train * ) this ) -> signal_changed = true ;
  }

  void push_to_station_init ( to_station ) ;	//  station_obj 
  void push_from_station_init ( from_station ) ;
			// from_station ֥Ȥ station_obj 

private :
  void membercopy ( const train & x ) ;	// ܥ饹 private member copy

} ;


// teta Ű, ޤŰ teta , 
double calculateVoltageFromCarTeta ( double ) ;
double calculateCarTetaFromVoltage ( double ) ;


#endif /* ! ___TRAIN_HH */
