// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// trn_brak.cc --- class train functions on nextmotion: nm_brake
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include "matrix.hh"
#include "train.hh"
#include "StrPrintf.hh"

#define INVLIM 1e-5

//#define TIMEPRINT
//#define PRATEBUG

//#define DEBUG

// ֥졼μֱ黻
void
train :: nm_brake
( double tracff )
{
  // ----
  // NOTE: 2010. 1. 20 -- emrn no longer used.
  // ----
  // tracff *= emrn ;

  enableMechanicalPowerCalculation () ;
  nposb ( tracff ) ;	// ֱ黻
  disableMechanicalPowerCalculation () ;

  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    if ( pos * direc ()
         >= nxx -> parrive () * direc () - nxx -> out_of_station () )
    {
      // ش֤߰᤮ǧ
      sw_x_btws = false ;
    }
  }

  bool sw_last_brake = false ;	// إǡλ򼨤

  if ( brakev < - INVLIM )
  {
    // ontime ξȤ֥졼λ

    double ontx = ontimesub ( pos , pgrad , vel , t_sim ) ;

    double x_tard = 0.0 ;	// ٤ʬδ
    if ( g_sw_station_object_valid && g_sw_disttrain_ended )
    {
      // ͭΤߥå
      // **** nxx -> tarr_delay ( this ) : ̵ zero ʤΤ
      x_tard = nxx -> tarr_delay ( this ) ;	// 줬̾
      if ( g_sw_stop_between_oriented && sw_x_btws )
      {
        // ش߻ظǱش֤߰᤮Ƥʤ
        x_tard = 0.0 ;	// ٤ʤȤƥѥ
      }
    }

    if ( ontx - tdept + taudx >= nxx -> tarrive ( pfirst ) + x_tard )
    {
      iamconst = false ;
      iamcoast = true ;
      if ( tresist ( vel , pgrad ) > 0 || vel < nxx -> vlimit ( pgrad )
           || nxx -> vlimit ( pgrad ) < INVLIM )
      {
        // ontime ž
        stat = Coast ;
        rnotchold = rnotch = 0.0 ;
      }
      else
      {
        stat = Const_vel ;
      }
    }
    return ;
  }

  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    // ͭΤߥå

    if ( sw_btws && ( ! nxx -> stnobj () -> voie_occupied ( this ) ) )
    {
      // شߤΤΥ֥졼ɬʤʤä
      // شԻʬ򿮹Ϥ׵˹碌
      sw_btws = false ;
      if ( nm_stnobj_brake () )
      {
        return ;
      }
      if ( nm_stnobj_power () )
      {
        return ;
      }

      // ƹΰ
      iamconst = false ;
      iamcoast = true ;
      if ( tresist ( vel , pgrad ) > 0
           || ( vel < nxx -> vlimit ( pgrad )
                || nxx -> vlimit ( pgrad ) < INVLIM ) )
      {
        // ®٤ˤʤ
        //  -> Coast ֤
        // **** ®٤®٤㤤
        // **** ®٤®ٰʾƹԻ®٤
        stat = Coast ;
        rnotchold = rnotch = 0.0 ;
#ifdef DEBUG
        cerr << StrPrintf
          ( "Btws Brake -> Coast, vlimit = %.1f km/h" ,
            nxx -> vlimit ( pgrad ) ) << endl ;
#endif
        return ;			// ontime ž
      }
      else
      {
        // ®٤ˤҤä륱
        //  -> Const_vel ֤
        // **** ®٤®ٰʾƹԻ®٤ʤ
        stat = Const_vel ;
#ifdef DEBUG
        cerr << "Btws Brake -> Const, vlimit, vel = "
             << StrPrintf ( "%.1f, %.1f km/h" ,
                            nxx -> vlimit ( pgrad ) , vel ) << endl ;
#endif
        return ;
      }
    }
  }

  if ( pos * direc ()
       > nxx -> parrive () * direc () - DINVLIM )
  {
    // إǡλ
    sw_last_brake = true ;
  }

  if ( sw_last_brake && vel > brakev )
  {
    // pos  arp ӽФʤ褦ޤ
    pos = nxx -> parrive () - INVLIM * direc () ;
    return ;
  }

  if ( vel <= brakev )
  {
    // ֥졼λ®٤򸫤Уϣ

    // vel ˤʤʤ褦ޤ
    if ( vel < 0.0 )
    {
      vel = 0.0 ;
    }

    // ǸǤϤʤ: ®¤ˤ֥졼
    if ( ( ! sw_last_brake ) && brakev > INVLIM && vel > INVLIM )
    {
      // brakev != 0
      if ( iamconst )
      {
        // Ϲΰˤ: ®ԥ⡼ɤ˰ܹ
        stat = Const_vel ;
        iamcoast = false ;
        iamconst = true ;
        return ;
      }
      stat = Coast ;
      iamconst = false ;
      iamcoast = true ;
      rnotchold = rnotch = 0.0 ;
      return ;
    }

    if ( sw_btws )
    {
      // ǸǤϤʤ: ؿ֤ˤ
      stat = Between_stop ;	// ش־
      return ;
    }

    /*************************************
     * ޤ褿 إǡ촹 *
     *************************************/

    double tde = tdept - taudx ;	// إǡȯ٤ʬη
    taudx = t_sim - nxx -> tarrive ( true ) - tde ;	// ٤

    l_ofs << StrPrintf
      ( "car %i: pos = %.3f, direc %d(%d-%d), delay %.2f sec." ,
        carno , pos , direc () , nxx -> dptnum () , nxx -> dpttbl () ,
        taudx ) << endl ;
    cerr << StrPrintf
      ( "car %i: pos = %.3f, direc %d(%d-%d), delay %.2f sec." ,
        carno , pos , direc () , nxx -> dptnum () , nxx -> dpttbl () ,
        taudx ) << endl ;

    nxx -> setpf ( taudx , pfirst ) ;		// ٤̿

    if ( fabs ( taudx ) > ontprec_delay_set )
    {
      // ٤줬礭: ե꡼ ontprec ̤åȤʤ nfree 
      if ( g_sw_freerun_cycle && ( ! nxx -> get_ontprec () )
           && n_inc_nfree != n_simcycle )
      {
        ++ nfree ;
        l_ofs << StrPrintf ( "nfree increased to %d" , nfree ) << endl ;
        cerr << StrPrintf ( "nfree increased to %d" , nfree ) << endl ;

        // nfree 12ٹԤʤ
        n_inc_nfree = n_simcycle ;
      }
      nxx -> set_ontprec () ;			// ontprec 򥻥å
    }

    nextsta_pattern nxxpx = nxx -> nxxptn () ;

    double x_tard ;	// ٤ʬδ

    // ֻʬʬ
    switch ( nxxpx )
    {
    case Station :		// ֥⡼ɤ nxx ǤȤ
    case Pass_station :		// ̲ᢪ֥⡼ɤ nxx 
      /* double */ x_tard = 0.0 ;	// ٤ʬδ
      if ( g_sw_station_object_valid && g_sw_disttrain_ended )
      {
        // ͭΤߥå
        // **** nxx -> tarr_delay ( this ) : ̵ zero ʤΤ
        x_tard = nxx -> tarr_delay ( this ) ;	// 줬̾
        if ( g_sw_stop_between_oriented && sw_x_btws )
        {
          // ش߻ظǱش֤߰᤮Ƥʤ
          x_tard = 0.0 ;	// ٤ʤȤƥѥ
        }
      }
      if ( taudx < x_tard )
      {
        // ַֻȱؽȯ٤ʬν
        tdept = nxx -> tarrive ( true ) ;
        tdept += nxx -> stoptime () + tde ;
        tdept += x_tard ;		// ٤­ֻʬĹ
        taudx = x_tard ;
      }
      else
      {
        // ֻʬ
        tdept = t_sim + nxx -> stoptime () ;
      }
      break ;

    case Station_pass :	// ȯ֢̲⡼ɤ nxx ΤȤ
    case Pass_pass :	// ̲ᢪ֥⡼ɤ nxx 
      tdept = t_sim ;		// ֻʬ¸ߤʤ
      break ;			//  taudx 򥼥ˤǤʤ뤳Ȥʤ
    }

    // ַʬ ( 1 )
    switch ( nxxpx )
    {
    case Station :		// ֥⡼ɤ nxx ǤȤ
    case Pass_station :		// ̲ᢪ֥⡼ɤ nxx 
      if ( nxx -> stoptime () < INVLIM )
      {
        // ֻʬ: ֡Ϲԡפ
        stat = Power ;
        iamconst = true ;
        iamcoast = false ;
        ontprec = nxx -> get_ontprec () ;	// ա added 94-6-1
        rnotchold = rnotch = 1.0 ;
        pfirst = 0 ;
      }
      else
      {
        // ֻʬ non-zero: ֱ֡֡פ
        stat = Stn_stop ;
        rnotchold = rnotch = 0.0 ;
      }
      break ;

    case Station_pass :		// ȯ֢̲⡼ɤ nxx ΤȤ
    case Pass_pass:		// ̲ᢪ֥⡼ɤ nxx 
      break ;	// 촹ʤ ontimesub ׻ǤʤΤ
    }

    prate = ptime / nxx -> tarrive ( true ) ;		// ϹΨ
    nxx -> prate ( prate ) ;				// ϹΨ̿
#ifdef PRATEBUG
    cerr << StrPrintf ( "prate = %.7f" , prate ) << endl ;
#endif

    addlen () ;						// ԵΥ
    stpos = pos = nxx -> nextnxx () -> pstart () ;	// ְֹ
    setNextstaPointer ( nxx -> nextnxx () ) ;
    pgrad = nxx -> dpgrad ( pos ) ;			// إǡ
    ptime = 0.0 ;					// ϹԻֹ
    tarr_real = t_sim ;	// 򵭲ʤޤ̣ʤ
    sw_x_btws = true ;	// شְ֤Ա¦ˤ뤳Ȥˤ

    if ( g_sw_station_object_valid && g_sw_disttrain_ended )
    {
      // to_station ǡ from_station ǡ֤
      stnobj_now -> from_station_generate ( this ) ;
    }

    // ַʬ ( 2 )
    switch ( nxxpx )
    {
    case Station :	// ֥⡼ɤ nxx ǤȤ
    case Pass_station:	// ̲ᢪ֥⡼ɤ nxx 
      if ( g_sw_station_object_valid && nxx -> stoptime () < INVLIM )
      {
        // ֻ֤Ǥʤ촹
        if ( g_sw_disttrain_ended )
        {
          stnobj_now->this_train_will_depart ( this ) ;
        }
        stnobj_now = nxx -> stnobj () ;
      }
      break ;

    case Station_pass :	// ȯ֢̲⡼ɤ nxx ΤȤ
    case Pass_pass :	// ̲ᢪ֥⡼ɤ nxx 
      if ( g_sw_station_object_valid )
      {
        if ( g_sw_disttrain_ended )
        {
          // ̲
          stnobj_now -> this_train_will_depart ( this ) ;
        }
        stnobj_now = nxx -> stnobj () ;
        if ( g_sw_disttrain_ended )
        {
          // disttrain λΤ߹Ԥ
          // to_station 򿷤 station_obj ̿,
#ifdef DEBUG
          cerr << "communicate with the new station_obj" << endl ;
#endif
          stnobj_comm () ;	// ַ׻򿷤˹Ԥ
        }
      }	// 촹

      double ontx = ontimesub ( pos , pgrad , vel , t_sim ) ;
      double x_tard = 0.0 ;	// ٤ʬδ
      if ( g_sw_station_object_valid && g_sw_disttrain_ended )
      {
        // ͭΤߥå
        // **** nxx -> tarr_delay ( this ) : ̵ zero ʤΤ
        x_tard = nxx -> tarr_delay ( this ) ;	// 줬̾
        if ( g_sw_stop_between_oriented && sw_x_btws )
        {
          // ش߻ظǱش֤߰᤮Ƥʤ
          x_tard = 0.0 ;	// ٤ʤȤƥѥ
        }
      }

      if ( ontx - tdept + taudx <= nxx -> tarrive ( pfirst ) + x_tard )
      {
        // ֥졼֤ؤž
        stat = Brake ;
        brakev = - 1.0 ;	// ɸ®١ontime Brake 
        rnotchold = rnotch = - 1.0 ;
        iamcoast = true ;		// ƹΰ
        iamconst = false ;
      }
      else
      {
        // ϹԾ֤ؤž
        iamcoast = false ;			// Ϲΰ
        iamconst = true ;
        cpsw = false ;				// cpsw ꥻå
        if ( vel >= nxx -> vlimit ( pgrad )
             && nxx -> vlimit ( pgrad ) >= INVLIM
             && tresist ( vel , pgrad ) < 0 )
        {
          // ®¤ˤ  ®Ԥž
          stat = Const_vel ;
        }
        else
        {
          // ®¤ˤʤ  ϹԾ֤ž
          stat = Power ;
          rnotchold = rnotch = 1.0 ;
        }
      }
      break ;
    }
  }
}
