// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// Ref_SOC_Curve_Container.cc --- functions in class Ref_SOC_Curve_Container
// -----
// ChangeLog:
// 2010. 1. 28
//  File created.
// -----


#include "Ref_SOC_Curve_Container.hh"


using std :: cerr ;
using std :: endl ;



bool
Ref_SOC_Curve_Container :: create
( TiXmlNode const * & _n_in ,
  vector < string > const & _s_in ,
  vector < RS_Object * > const & _o_in )
{
  string xxx = getClassString ( _n_in ) ;
  string yyy = getNameString ( _n_in ) ;
  SOC_FeedForward_Data * x = FFSOC_Expander :: create ( xxx , _n_in ) ;
  ( * this ) [ yyy ] = x ;
  vector < string > :: const_iterator ii = _s_in . begin () ;
  vector < RS_Object * > :: const_iterator jj = _o_in . begin () ;
  while ( ii < _s_in . end () || jj < _o_in . end () )
  {
    if ( x -> acceptInitObject ( * ii , * jj ) )
    {
      ++ ii ;
      ++ jj ;
    }
    else
    {
      cerr << "Error: acceptInitObject failed, type = "
           << * ii << endl ;
      exit ( 1 ) ;
    }
  }
}



SOC_FeedForward_Data const *
Ref_SOC_Curve_Container :: locate
( string const & x )
  const
{
  RS_Object const * _obj = RS_ObjectContainer :: locate ( x ) ;
  if ( ! _obj )
  {
    cerr << "Error: \"" << x << "\" is not a SOC_FeedForward_Data object."
         << endl ;
    exit ( 1 ) ;
  }
  SOC_FeedForward_Data const * _ret
    = dynamic_cast < SOC_FeedForward_Data const * > ( _obj ) ;
  if ( ! _ret )
  {
    cerr << "Error: \"" << x << "\" is not a SOC_FeedForward_Data object."
         << endl ;
    exit ( 2 ) ;
  }
  return _ret ;
}



SOC_FeedForward_Data *
Ref_SOC_Curve_Container :: locate
( string const & x )
{
  RS_Object * _obj = RS_ObjectContainer :: locate ( x ) ;
  if ( ! _obj )
  {
    cerr << "Error: \"" << x << "\" is not a SOC_FeedForward_Data object."
         << endl ;
    exit ( 3 ) ;
  }
  SOC_FeedForward_Data * _ret
    = dynamic_cast < SOC_FeedForward_Data * > ( _obj ) ;
  if ( ! _ret )
  {
    cerr << "Error: \"" << x << "\" is not a SOC_FeedForward_Data object."
         << endl ;
    exit ( 4 ) ;
  }
  return _ret ;
}
