// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// readdata.cc --- class readdata functions
// -----
// ChangeLog:
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cctype>
#include <cstdarg>
#include <iostream>

using std :: cerr ;
using std :: endl ;


#include "readdata.hh"

// ǡե륢顼
void
readdata :: err_access
()
{
  cerr << "Error: data file access denied" << endl ;
  exit ( 30 ) ;
}


// ǡե륢顼
void
readdata :: err_access
( char * s )
{
  cerr << "Error: data file " << s << " access denied" << endl ;
  exit ( 30 ) ;
}


// ǡե륨顼
void
readdata :: err_eof
()
{
  cerr << "Error: data file not correct" << endl ;
  exit ( 34 ) ;
}


// ǡե륨顼
void
readdata :: err_eof
( char * s )
{
  cerr << "Error: data file " << s << " not correct" << endl ;
  exit ( 34 ) ;
}



// ǡե륨顼
void
readdata :: err_eof
( bool & sw ,
  char * s )
{
  if ( sw ) err_eof( s ) ;
  sw = true ;
}



// ȹԸ, sw = false  eof  OK
int
readdata :: comm_out
( FILE * fl ,
  bool sw /* = true */ )
{
    char c ;
    if ( (c = fgetc(fl)) == EOF ) {
	if ( sw ) err_eof() ;
	else return EOF ;
    }
  SHARP:
    if ( c == '#' ) {				// # ȯ
	while ( c != '\n' ) {			// ޤǶɤ
	    if ( (c = fgetc(fl)) == EOF ) {		// code?
		if ( sw ) err_eof() ;
		else return EOF ;
	    }
	}
	if ( (c = fgetc(fl)) == EOF ) {		// \nμɤ
	    if ( sw ) err_eof() ;
	    else return EOF ;
	}
    } else if ( ! isspace(c) ) goto ENDING ;	// ڡʳǤϽλ
    while ( isspace(c) ) {              	// ڡɤФ
	if ( (c = fgetc(fl)) == EOF ) {
	    if ( sw ) err_eof() ;
	    else return EOF ;
	}
    }

// # ȯ
//  BACK:	// -Wall warning: label defined but not used 
    if (c == '#') goto SHARP ;

// λ
  ENDING:
    ungetc(c, fl) ;				// c 򲡤᤹
    return c ;
}

// ޥ̾
int readdata::getcommand
(FILE* fl, bool sw /* = true */) {
    if ( comm_out(fl, sw) == EOF ) return EOF ;	// ȥ
    if ( fscanf(fl, "%s ", tmpch) == EOF ) {	// ɤ߹
	if ( sw ) err_eof() ;
	else return EOF ;
    }
    return 1 ;
}

// ޥ̾
int readdata::getcommand
(FILE* fl, char* flname) {
    if ( comm_out(fl, true) == EOF ) err_eof(flname) ;
    if ( fscanf(fl, "%s ", tmpch) == EOF )		// ɤ߹
	err_eof(flname) ;
    return 1 ;
}

// ޥ̾( enum )
commandvalue readdata::getcommandvalue
( FILE* fl, char* flname ) {
    if ( comm_out( fl, true ) == EOF ) {
        err_eof( flname ) ;
    }
    if ( fscanf( fl, "%s ", tmpch ) == EOF ) {		// ɤ߹
	err_eof( flname ) ;
    }

    commandlist a ;
    a.cmdname = tmpch ;
    char* bs_result ;
    bs_result = (char*) bsearch
        ( ( char* ) ( &a ), ( char* ) comlist, comnum,
          sizeof( commandlist ), sortcommands ) ;
    if ( bs_result == NULL ) {
        return END_OF_DATA ;
    } else {
        return ( ( commandlist* ) bs_result ) -> cmdval ;
    }
}

// ޥ̾( enum )
void readdata::getcommandvalue
( FILE* fl, char* flname, commandvalue com_req ) {
    commandvalue com_get = getcommandvalue( fl, flname ) ;
    if ( com_get != com_req ) {
        err_eof( flname ) ;
    }
}

int readdata::getdouble
(FILE* fl, char* fls, double& dbl) {		// ټ¿ѿ
    if ( getdouble(fl, dbl) == EOF ) err_eof(fls) ;
    return 1 ;
}

// ټ¿ѿ
int readdata::getdouble
(FILE* fl, double& dbl) {
    if ( comm_out(fl, false) == EOF ) return EOF ;
    if ( fscanf(fl, "%s ", tmpch) == EOF ) return EOF ;
    sscanf(tmpch, "%lf ", &dbl) ;
    return 1 ;
}

// ټ¿ѿ
int readdata::gettwodbls
(FILE* fl, char* fls, double& dbl, double& dbl2) {
    if ( gettwodbls(fl, dbl, dbl2) == EOF ) err_eof(fls) ;
    return 1 ;
}

// ټ¿ѿ
int readdata::gettwodbls
(FILE* fl, double& dbl, double& dbl2) {
    if ( getdouble(fl, dbl) == EOF ) return EOF ;
    if ( getdouble(fl, dbl2) == EOF ) return EOF ;
    return 1 ;
}

// ټ¿ѿ򻰤
int readdata::getthreedbls
(FILE* fl, char* fls, double& dbl,
 double& dbl2, double& dbl3) {
    if ( getthreedbls(fl, dbl, dbl2, dbl3) == EOF ) err_eof(fls) ;
    return 1 ;
}

// ټ¿ѿ򻰤
int readdata::getthreedbls
(FILE* fl, double& dbl,
 double& dbl2, double& dbl3) {
    if ( gettwodbls(fl, dbl, dbl2) == EOF ) return EOF ;
    if ( getdouble(fl, dbl3) == EOF ) return EOF ;
    return 1 ;
}

// ѿ
int readdata::getint
(FILE* fl, char* fls, int& dbl) {
    if ( getint(fl, dbl) == EOF ) err_eof(fls) ;
    return 1 ;
}

// ѿ
int readdata::getint
(FILE* fl, int& dbl) {
    if ( comm_out(fl, false) == EOF ) return EOF ;
    if ( fscanf(fl, "%s ", tmpch) == EOF ) return EOF ;
    sscanf(tmpch, "%d ", &dbl) ;
    return 1 ;
}

void readdata::setsw(bool& sw) {
    if (sw) err_eof() ;
    sw = true ;
}

// ѿ
int readdata::gettwoints
(FILE* fl, char* fls, int& itx, int& ity) {
    if ( gettwoints(fl, itx, ity) == EOF ) err_eof(fls) ;
    return 1 ;
}

// ѿ
int readdata::gettwoints
(FILE* fl, int& itx, int& ity) {
    if ( getint(fl, itx) == EOF ) return EOF ;
    if ( getint(fl, ity) == EOF ) return EOF ;
    return 1 ;
}

// ޥɤ
bool readdata::cmpcommand
(char* cmd) {
    if ( strcmp(tmpch, cmd) == 0 ) return true ;
    else return false ;
}

// ޥɤ
bool readdata::cmpcommand
(char* cmd, char* fls) {
    if ( strcmp(tmpch, cmd) != 0 ) err_eof(fls) ;
    else return true ;
    return false ;	// -Wall warning 
}

// ޥɤ
bool readdata::cmpcommand
(FILE* fl, char* cmd, char* fls, bool sw /* = false */) {
    getcommand(fl, fls) ;
    if ( strcmp(tmpch, cmd) != 0 ) {
	if (sw) return false ;
	else err_eof(fls) ;
    } else return true ;
    return false ;	// -Wall warning Τ
}
