/* {\documentstyle[ascmac,fleqn,epsf,rt0,rt1,rtraku,lab]{jarticle}%
   \pagestyle{rt}}
   {\
   \section{ƥʥ饹 {\tt NoRefTable}}
   \label{NoRefTable.hh}
   
   륪֥ȤȤƼ륳ƥʥ饹ǡ
   C++ Ρ֥ƥץ졼ȵǽפѤƵҤƤ롣
   ƥץ졼ȵǽȤط塢
   Υեˤϴؿ˵ҤƤ롣%\}

   */

#ifndef ___NOREFTABLE_HH
#define ___NOREFTABLE_HH


#include <cstdio>
#include <cstdlib>
#include <iostream>

using std :: cerr ;
using std :: endl ;

#ifndef GETMEMORYNUMBER
#define GETMEMORYNUMBER		40
#endif	/* {\tt GETMEMORYNUMBER %\}  */

template < class TP >
class NoRefTable
{

  // ____ ѿ ____

protected :
  int num ;		// ˳ǼƤ륪֥ȿ
  TP * data ;		// ؤΥݥ
  int mmax ;		// ˳ǼǽʺΥ֥ȿ

  TP * bxold ;		// ƥݥʳǼѥڡ
  int bxoldm ;		/* {\tt bxold} Ѥ˳ݤκ
                           ({\tt mmax} Ʊ) */

  // ____ ؿ ____

public :

  // 󥹥ȥ饯
  NoRefTable () ;

    virtual ~NoRefTable();			// ǥȥ饯
    NoRefTable(const NoRefTable<TP>&);		// X(X&)
    NoRefTable<TP>& operator=
    ( const NoRefTable<TP>& x);		// 

    TP operator[] ( int i ) const ;		// ǡλ

    TP last () const {return operator[]( num - 1 );}

    inline void renew();		// Ȥˤ
    void renew(int max);		/* Ʊ塢Ʊ
                                           祪֥ȿѹ */
    void setnum(int nm);		/* Ǽ֥ȿ
                                           ͤ˥åȤ */

    inline TP shift();			// {\ Perl  {\tt shift}}
    inline void unshift(TP);		// {\ Perl  {\tt unshift}}
    inline TP pop();			// {\ Perl  {\tt pop}}
    inline void push(TP);		// {\ Perl  {\tt push}}

    TP remove( int );			// int ܤΥǡ

    NoRefTable<TP>& operator+=( const TP );	// ǡä
    NoRefTable<TP>& operator+=
    ( const NoRefTable<TP>& );		// 򤯤äĤ
    NoRefTable<TP>& operator*=		// ǡƬˡײä
    ( const TP x ) {unshift( x );}
    inline int number() const
        {return num;}			// κ֤

  protected:
    void membercopy
    ( const NoRefTable<TP>& x );		// Хԡ

  private:
    virtual void error26_name() const;		/* ϰϳ
                                                   顼å */

    inline void bxold_resize();			/* {\tt bxold} Υꥵ
                                                   {\tt mmax} ͤǾŤ */
    inline void bxold_resize_core();		// Ʊ塦ʤ


    inline void num_incrementation(int);	// {\tt num} Υ󥯥
    inline bool					// {\tt num} 󥯥Ȥ
    num_incrementation_backup(int);		// ݤΥǡХåå
    inline void					// 嵭ؿǥХååפ
    num_incrementation_restore(int);		// ǡ򸵤᤹
};



// Ȥˤ
template <class TP>
inline void
NoRefTable<TP>::renew
() {
    num = 0;
    /* {\ ¤ϤäǤ롣ٳݤΰ
       ȥХإåɤ礭ʤ뤿ᡢ
       Ȥθ {\tt num}  0 Ȥ뤳Ȥǡָⲽס
       äơǼ륪֥Ȥ䤤 X(X\&) 
       Ǥ褦߷פƤɬפ롣
       %\}
       */
}

// {\tt shift} (Perl 򻲾)
// ƬǤ֤ͤ
template <class TP>
inline TP
NoRefTable<TP>::shift
() {
    bxold_resize();			// {\tt bxold} ΰ
    bxold [ 0 ] = data [ 0 ];		// Ǥ
    for ( register int i = 1;		// 1Ĥˤ餹
          i < num; i++ )
        data [ i - 1 ] = data [ i ];
    num--;
    return bxold [ 0 ];			// Ǥ {\tt return}
}

// {\tt pop} (Perl 򻲾)
// Ǥ֤ͤ
template <class TP>
inline TP
NoRefTable<TP>::pop
() {
    if ( num == 0 ) {			// {\tt num} ʤ error
        cerr << "Error: tried to pop empty table\n";
        error26_name();			// 顼åήѡ
        exit(27);			// Exit  27
    }
    return data [ --num ];		// Ǥ {\tt return}
}

// {\tt unshift} (Perl 򻲾)
// ƬǤդä롣
template <class TP>
inline void
NoRefTable<TP>::unshift
( TP x ) {
    register int i;
    if ( num_incrementation_backup( 1 ) )
        for ( i = 0; i < num; i++ )
             data[ i + 1 ] = bxold[ i ];
    else
        for ( i = num - 1; i >= 0; i-- )
             data[ i + 1 ] = data[ i ];
    num++;
    data[ 0 ] = x;
}

// {\tt push} (Perl 򻲾)
// Ǥդä롣
template <class TP>
inline void
NoRefTable<TP>::push
( TP x ) {
    operator+=( x );	// ¤˴ñ
}

// {\tt bxold} Υꥵ {\tt mmax} ͤǾŤ
template <class TP>
inline void
NoRefTable<TP>::bxold_resize
() {
    if ( bxoldm < mmax ) bxold_resize_core();
}

// {\tt bxold} Υꥵʤ
template <class TP>
inline void
NoRefTable<TP>::bxold_resize_core
() {
    if ( bxold ) delete [] bxold;
    bxold = new TP[ bxoldm = mmax + GETMEMORYNUMBER ];
}

// {\tt num} 󥯥ȤκݤΥǡХåå
template <class TP>
inline bool
NoRefTable<TP>::num_incrementation_backup
( int incr ) {
    bool ret_val = false;
    int size = num + incr;
    if ( size > mmax ) {
	if ( mmax > 0 ) {
            bxold_resize();
	    for ( register int j = 0; j < num; j++ )
		bxold[ j ] = data[ j ];
	    if ( data ) delete [] data;
            ret_val = true;
        }
        data = new TP[ mmax = size + GETMEMORYNUMBER ];
    }
    return ret_val;
}

// Хååפ {\tt data} 򸵤᤹
template <class TP>
inline void
NoRefTable<TP>::num_incrementation_restore
( int incr ) {
    if ( num_incrementation_backup( incr ) )
        for ( register int j = 0; j < num; j++ )
            data[ j ] = bxold[ j ];
}

// {\tt num} Υ󥯥
template <class TP>
inline void
NoRefTable<TP>::num_incrementation
( int incr ) {
    num_incrementation_restore( incr );
    num += incr;
}
    

// GCC 2.7.2.2 ǤϤΤ褦ʤȤ򤷤ƤϤʤ餷
/* #ifdef __MAIN_ROUTINE */
#include "NoRefTable-def.hh"
/* #endif */

#endif /* ! ___NOREFTABLE_HH */
