// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// ccal.cc --- equivalent circuit calculation routine
// -----
// ChangeLog:
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----


#include <cstdio>
#include <cstdlib>
#include <cmath>

#include "kidenrt.hh"
#include "StrPrintf.hh"

//#define DEBUG

// ----------------------------------
// globvar.hh  const ѿ
// ----------------------------------

// ccal () Υߥåȥȯ롼 FAILNUM ܶȯ.
// Default = 3
#define FAILNUM gc_ccalfail_failnum

// ccal () Υߥåȥ. Default = 1.0
#define FAILDIF gc_ccalfail_faildif

// ߥåȥȯϽ̤ FAILDIV ܤ. Default = 1.0
#define FAILDIV gc_ccalfail_faildiv

//  CIRCULATION ϩ׻¹. Default = 250
#define CIRCULATION gc_ccalfail_circ

//  CIRCULATION ϩ׻¹. Default = 0.1
#define TERMINATION_CRITERIA gc_ccal_termination

// Y 黻롼ġΩ
void
feeder :: ycal
()
{
  feedy . renew () ;

  // ֤Υǡ feedline ˤ
  for ( int i = 0 ; i < feeders ; ++ i )
    getFLN ( i ) . clearcar () ;
  for ( int i = 0 ; i < ncar ; ++ i )
    getFLN ( getCAR ( i ) . nfline () ) += getCAR ( i ) . feep () ;

  // Υȡ֥ԡ󥹷׻
  for ( int i = 0 ; i < feeders ; ++ i )
    feedy += getFLN ( i ) . sortx () ;

  // ٹη׻  
  feedy . y ( ncss , ymtx ) ;

  // ٹΣʬȹνľ
  static matrix aa , ab , ba , bb , bb_inv ;
  ymtx . quaddiv ( nss , nss , aa , ab , ba , bb ) ;
//   bb . inverse () ;
//   aa -= ab * bb * ba ;
//   ab *= bb ;
//   ba = - bb * ba ;
//   ymtx . quadjoin ( aa , ab , ba , bb ) ;
  int det = bb . decompose_LU () ;
  if ( det == 0 )
  {
    l_ofs << "THERE IS SOMETHING WRONG HERE..." << endl ;
  }
  bb . inverse ( bb_inv ) ;
  aa -= ab * bb_inv * ba ;
  ab *= bb_inv ;
  bb = ba ;
  ba = bb_inv ;
  ba *= - 1.0 ;
  ba *= bb ;
  ymtx . quadjoin ( aa , ab , ba , bb_inv ) ;
}


// ϩ黻롼
int
feeder :: ccal
()
{
  int det_xx ;
  int ncirc ;
  int lims = 0 ;
  int i ;
  int j ;
  fvec . renewmn ( ncss ) ;
  int ccm = 0 ;	// number of trials. First try = 0
  static bool ccbfzz = true ;
  static double * * ccbftt = new double * [ CIRCULATION ] ;
  if ( ccbfzz ) {
    for ( i = 0 ; i < CIRCULATION ; ++ i )
    {
      ccbftt [ i ] = new double [ ncss ] ;  // ccbftt ΰ
    }
    ccbfzz = false ;				// ϽΤ߼¹
  }

 NEWTON:
  // ˥塼ȥ󡦥ץˡ
  double ff [ CIRCULATION ] ;
  short int limcyc = 0 ;
  // settetazero () ;
  for ( ncirc = 0 ; ncirc < CIRCULATION ; ++ ncirc )
  {
    notchrate () ;
    ff [ ncirc ] = ffunc ( fvec ) ;
    l_ofs << StrPrintf ( "ff[%i] = %.2f" , ncirc , ff [ ncirc ] ) << endl ;
    if ( ff [ ncirc ] <= TERMINATION_CRITERIA )
    {
      for ( i = 0 ; i < ncss ; ++ i )
      {
	getCSD ( i ) -> teta () += fvec ( i ) / 2.0 ;
	getCSD ( i ) -> teta_vi () ;
      }
      return 1 ;
    }

    for ( i = 0 ; i < ncss ; ++ i )		// teta ѿθͤϿ
      ccbftt [ ncirc ] [ i ] = getCSD ( i ) -> teta () ;

    // «ʲϩ黻ǻߤʤ
    if ( limcyc < FAILNUM &&     		// ߥåȥȯ
	 ncirc > 0 &&				// «˸äƤʤ
	 ff [ ncirc - 1 ] < ff [ ncirc ] )	// åʤ
    {
      for ( j = lims ; j < ncirc ; ++ j )
      {
	if ( ( ccm != 3 ) && fabs ( ff [ j ] - ff [ ncirc ] ) < FAILDIF
	     || ( ccm == 3 )
	     && fabs ( ff [ j ] - ff [ ncirc ] ) < FAILDIF * FAILDIV )
	{
	  ++ limcyc ;
	  lims = j ;
	  break ;
	}
      }
    }
    if ( limcyc == FAILNUM || ncirc == CIRCULATION - 1 )
    {
      // ߥåȥȯԤ
      switch ( ccm )
      {
      case 0 :
      case 2 :
        // 1ܤ3: ʬʿѤȤ
        for ( j = 0 ; j < ncss ; ++ j )
        {
          for ( int k = lims + 1 ; k < ncirc ; ++ k )
            getCSD ( j ) -> teta () += ccbftt [ k ] [ j ] ;
          getCSD ( j ) -> teta () /= ncirc - lims ;
        }
        std :: cerr << "mean value of 1 cycle -> teta" << std :: endl ;
        break ;

      case 1 :
        // 2: ǽ餫ľ
        restorevi () ;
        std :: cerr << "restart" << std :: endl ;
        break ;

      case 3 :
      default :
        // 4: ׻ԡ¹Խλ
        return 0 ;
      }

      // 롼פȴ
      break ;
    }

    gradf () ;		// ʬͤη׻
    det_xx = gff_xx . decompose_LU () ;
    if ( det_xx == 0 )
    {
      for ( i = 0 ; i < ncss ; ++ i )
	getCSD ( i ) -> teta () += i * 5;
    }
    else
    {
      gff_xx . eqnsolve ( fvec , gamma ) ;
      for ( i = 0 ; i < ncss ; ++ i )
      {
        getCSD ( i ) -> add_to_teta ( - gamma ( i ) , ccm ) ;
      }
    }
  }
  if ( ccm == 3 ) return 0;
  ++ ccm ;
  goto NEWTON ;
}
