// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// stnobj_s.cc --- functions for class station_obj_stationstop_variation
// $Id: stnobj_s.cc,v 2.4 1994/12/27 11:49:38 rt Exp $

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include "stnobj_s.hh"
#include "train.hh"

//#define DEBUG

// constructor
station_obj_stationstop_variation::station_obj_stationstop_variation
() : station_obj() {
    d_init = 0.0;
    sw_disturb = false;
    sw_disturbance_done = false;
    sw_disturb_control = false;
    sw_delay_comm_yet = false;
    tsim_distcomm = 0.0;
    cd_type = Without_control;
    control_station_object_number = -1;
    control_station_object_value = 0.0;
    control_station_object_time = 0.0;
    tarr_delay_add = 0.0;
    tdept_delay_add = 0.0;
    tdept_delay_add_imove = 0;
}

// constructor: X(X&)
station_obj_stationstop_variation::station_obj_stationstop_variation
( const station_obj_stationstop_variation& x )
: station_obj( x ) {
    membercopy( x );
}

// 
void station_obj_stationstop_variation::membercopy
( const station_obj_stationstop_variation& x ) {
    station_obj::membercopy( x );
    d_init = x.d_init;
    sw_disturb = x.sw_disturb;
    sw_disturbance_done = x.sw_disturbance_done;
    sw_delay_comm_yet = x.sw_delay_comm_yet;
    sw_disturb_control = x.sw_disturb_control;
    tsim_distcomm = x.tsim_distcomm;
    cd_type = x.cd_type;
    control_station_object_number = x.control_station_object_number;
    control_station_object_value = x.control_station_object_value;
    control_station_object_time = x.control_station_object_time;
    tarr_delay_add = x.tarr_delay_add;
    tdept_delay_add = x.tdept_delay_add;
    tdept_delay_add_imove = x.tdept_delay_add_imove;
}

// 黻Ҥ overload
station_obj_stationstop_variation&
station_obj_stationstop_variation::operator=
( const station_obj_stationstop_variation& x ) {
    if (&x == this) return *this;
    membercopy( x );
    return *this;
}

// ֽȯ
void
station_obj_stationstop_variation::this_train_will_depart
( const train* trptr_arg ) const {
    // Ⱦ
    this_train_will_depart_aaa( trptr_arg );

    station_obj_stationstop_variation* stox
        = ( station_obj_stationstop_variation* ) this;	// const cast

    // tdept_delay_add 򥼥ꥻå
    stox->tdept_delay_add = 0.0;	// ʤΤ
    
    // Ⱦ    
    this_train_will_depart_baa( trptr_arg );
}

// ʬٱꥻå  ֻʬΥե饯奨
// ֻʬե饯奨ˤϹƳ
//
// $t_d$ : ȯֻʵΡ (tdept)
// $t_{do}$ : ֤ȯֻ (tdept_prev)
// $t_a$ :  (tarrive = temp_fs.tarrive)
// $t_h$ :  (glob_head)
// $t_S$: ֻʬ (tstop = operator[]( imove ).tstop)
// $t_{SV}$: ֻʬΤ߿Ͱ㤷ʤʬ (glob_t_sv)
//
// t_d = \dfrac{t_h * (t_a + t_{SV}) - t_{do} * (t_S - t_{SV})}
//             {t_h - t_S + t_{SV}}
//
void
station_obj_stationstop_variation::stationstop_variation_func
( from_station& temp_fs, int imove ) {

    // tarr_delay_add ꥻå
    tarr_delay_add = 0.0;

    // ֤νȯ
    double tdept_prev
        = train_departure[ temp_fs.voie ].tdept
        + train_departure[ temp_fs.voie ].tdept_delay;

    // ֤
    double tarrive = temp_fs.tarrive;

    // ֻ֤ʬ
    // operator[]( imove ).tstop ˤϥΥߥʥֻʬäƤȤ
    double tstop = operator[]( imove ).tstop;

    // ޤϴԤȯ׻
    double tdept = glob_head * ( tarrive + glob_t_sv );
    tdept -= tdept_prev * ( tstop - glob_t_sv );
    tdept /= glob_head - tstop + glob_t_sv;

    // ˾ȯФ٤򻻽
    temp_fs.tdept_delay = tdept - temp_fs.tdept;

    // ٤ʬޥʥξν
    // ֤äƤ٤: operator[]( imove ).taudx
    // temp_fs.tdept_delay < - operator[]( imove ).taudx ʤ
    // tdept_delay 򤽤ͤޤ᤹
    double x_vh = - operator[]( imove ).taudx;
    if ( temp_fs.tdept_delay < x_vh ) {
        temp_fs.tdept_delay = x_vh;
    }

    // ֻʬطλؼ
    stationstop_variation_func_delay( temp_fs, imove );
}

// train_departure[ * ].tdept_delay õƤ֤
double
station_obj_stationstop_variation::tdept_delay
( const train* trptr_arg ) const {
    station_obj_stationstop_variation* stox
        = ( station_obj_stationstop_variation* ) this;	// const cast
    int imove = stox->which_in_train_departure( trptr_arg );
    double ret_val = stox->train_departure[ imove ].tdept_delay;
    if ( imove == tdept_delay_add_imove ) {
        ret_val += tdept_delay_add;
    }
    return ret_val;
}

// operator[]( * ).tarr_delay õƤ֤
double
station_obj_stationstop_variation::tarr_delay
( const train* trptr_arg ) const {
    station_obj_stationstop_variation* stox
        = ( station_obj_stationstop_variation* ) this;	// const cast
    int imove = stox->which_in_to_station( trptr_arg );
    double ret_val = stox->operator[]( imove ).tarr_delay;
    return ret_val + tarr_delay_add;
}

// ֻʬطλؼʿƶ̡
// station_obj::from_station_generate() ؿ
// ƤФ
// ֻʬ򵯤 pickup
void
station_obj_stationstop_variation::stationstop_variation_func_delay
( from_station& temp_fs, int imove ) {

    // ٤ȯ򤽤⤽Ԥʤ
    if ( ! sw_disturb ) {
        tdept_delay_add = 0.0;
        return;
    }

    // ޤԤʤ
    if ( g_sw_freerun_cycle || ( ! g_sw_disttrain_ended ) ) {
        tdept_delay_add = 0.0;
        return;
    }

    // Ǥ٤ȯԤä
    if ( sw_disturbance_done ) {
        if ( sw_delay_comm_yet ) {
            stationstop_variation_delay_comm();	// ؤ̿
        }
        tdept_delay_add = 0.0;
        return;
    }

    // ٤ȯԤ
    stationstop_variation_func_delay_core( temp_fs, imove );
}


// ֻʬطλؼʿƶ̡
// ٤ȯۤȤ˹Ԥ롼
void
station_obj_stationstop_variation::stationstop_variation_func_delay_core
( from_station& temp_fs, int imove ) {

    // ٤
    tdept_delay_add = d_init;
}

// ַΤ̿
void
station_obj_stationstop_variation::stationstop_variation_delay_comm
() {

    switch ( cd_type ) {

      case Without_control:	// ʤˤ⤷ʤ
        sw_delay_comm_yet = false;
        return;
        break;

      case Stop_at_station:	// ޻
        // ۤȤϤ
        // ޻̤̿ʬ񤭹Ϥä
        sw_delay_comm_yet = false; // ̵ false ˤΤϤʤ
        return;
        break;

      case Slow_down_between:	// شԻʬ俭
        // ۤȤϤ
        // شԻʬ俭̤̿ʬ񤭹Ϥä
        sw_delay_comm_yet = false; // ̵ false ˤΤϤʤ
        return;
        break;

    }
}
