// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// DataInSection.hh --- template class DataInSection
// -----
// ChangeLog:
// 2007. 11. 19
//  File created.
// -----


#ifndef DataInSection_HH
#define DataInSection_HH

#include <cstdlib>
#include <string>
#include <vector>
#include <iostream>

using std :: vector ;

/******************************************************************
 * class DataInSection
 *  Parameter DS: type of the data
 *  Parameter IDS: type of the initialiser of DS
 ******************************************************************/

template < typename DS , typename IDS >
class DataInSection
{
  // -----
  // Variables ... Data and its boundaries.
  // ѿ ... ǡȤζ.
  // -----

  DS d ;
  double t1 ;
  double t2 ;

public :

  // -----
  // Functions ... Reference to data
  // ؿ ... ǡؤλ
  // -----

  const DS & getData () const { return d ; }
  double getStartOfSection () const { return t1 ; }
  double getEndOfSection () const { return t2 ; }

  // -----
  // Functions ... Within range?
  // ؿ ... ϰ⤫ɤ?
  // -----

  bool isInSection ( double tx ) const { return t1 <= tx && tx <= t2 ; }
  bool isBeforeSection ( double tx ) const { return tx < t1 ; }
  bool isAfterSection ( double tx ) const { return t2 < tx ; }

  // Constructor
  DataInSection ( double t1x , double t2x , const IDS & ids_in )
    : d ( ids_in ) , t1 ( t1x ) , t2 ( t2x ) {}  // X(X&)
  DataInSection ( const DataInSection & x )
    : d ( x . d ) , t1 ( x . t1 ) , t2 ( x . t2 ) {}

  // Operator =
  DataInSection & operator= ( const DataInSection & x )
  {
    if ( & x == this ) return * this ;
    t1 = x . t1 ;
    t2 = x . t2 ;
    d = x . d ;
    return * this ;
  }

private :

  // Default constructor prohibited
  explicit DataInSection () ;

} ;

#endif	// DataInSection_HH
