// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// NoRefTable.hh --- template class NoRefTable
// ######## NOTE ########
//  Use of this header file is strongly discouraged. This file must be
//  removed from RTSS source at some stage in the future.
// ######## NOTE ########

#ifndef ___NOREFTABLE_DEF_HH
#define ___NOREFTABLE_DEF_HH

// **** ؿ ****

// 󥹥ȥ饯
template <class TP>
NoRefTable<TP>::NoRefTable
() {
    data = bxold = 0;
    num = mmax = bxoldm = 0;
}

// Хԡ
template <class TP>
void
NoRefTable<TP>::membercopy
( const NoRefTable<TP>& x ) {
    num = x.num;
    if (num > 0) {
	if (num > mmax) {
	    if ( data ) delete [] data;
	    data = new TP[ mmax = num + GETMEMORYNUMBER ];
	    // ɤˤ
	}
	for (register int i = 0; i < num; i++)
	    data[i] = x.data[i];
    }
}

// X(X&)
template <class TP>
NoRefTable<TP>::NoRefTable
( const NoRefTable<TP>& x ) {
    data = bxold = 0;
    num = mmax = bxoldm = 0;
    membercopy(x);
}

// ǥȥ饯
template <class TP>
NoRefTable<TP>::~NoRefTable
() {
    if ( data ) delete [] data;
    if ( bxold ) delete [] bxold;
}

// 黻
template <class TP>
NoRefTable<TP>&
NoRefTable<TP>::operator=
( const NoRefTable<TP>& x ) {
    if (&x == this) return *this;
    membercopy(x);
    return *this;
}



// ǡλ
template < class TP >
TP
NoRefTable < TP > :: operator[]
( int i )
  const
{
  if ( i < 0 || i >= num )
  {		// ξϥ顼
    error26_name () ;			//   顼å
    exit ( 26 ) ;			//   Exit  26
  }
  return data [ i ] ;
}



// κѹȤϤʤǤ褤
template <class TP>
void
NoRefTable<TP>::renew
( int max ) {
    renew();
    if ( mmax < max ) {
	if ( mmax > 0 && data ) delete [] data;
	data = new TP[ mmax = max + GETMEMORYNUMBER ] ;
    }
}

// κ˾ͤ˥å
template <class TP>
void
NoRefTable<TP>::setnum
( int nm ) {
    renew( nm );
    num = nm;
}

// ǡä
template <class TP>
NoRefTable<TP>&
NoRefTable<TP>::operator+=
( const TP x ) {
    num_incrementation( 1 );
    data[ num - 1 ] = x;
    return *this;
}

// 򤯤äĤ
template <class TP>
NoRefTable<TP>&
NoRefTable<TP>::operator+=
( const NoRefTable<TP>& x ) {
    if (&x == this) return *this;
    num_incrementation_restore( x.num );
    for ( register int i = 0; i < x.num; i++ )
        data[ i + num ] = x.data[ i ];
    num += x.num;
    return *this;
}


// ϰϳȥ顼å
template <class TP>
/* virtual */ void
NoRefTable<TP>::error26_name
() const {
    cerr << "Error: subscript out of range in\n";
    cerr << "       NoRefTable object TP data call\n";
}

// Ǥս̤Ǥ֤ͤ
template <class TP>
TP
NoRefTable<TP>::remove
( int irm ) {
    bxold_resize();			// {\tt bxold} ΰ
    bxold [ 0 ] = data [ irm ];		// Ǥ
    for ( register int i = irm;		// 1Ĥˤ餹
          i < num; i++ )
        data [ i - 1 ] = data [ i ];
    num--;
    return bxold [ 0 ];			// Ǥ {\tt return}
}



#endif /* ! ___REFPOINTERTABLE_DEF_HH */
