// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// Substation_Control_VI_TS.hh
//  --- declaration of class Substation_Control_VI_TS and related classes
// -----
// ChangeLog:
// 2007. 11. 19
//  File created.
// -----


#ifndef Substation_Control_VI_TS_HH
#define Substation_Control_VI_TS_HH

#include <cstdlib>
#include <string>
#include <vector>
#include <iostream>
#include "tinyxml.h"
#include "DataInSection.hh"

using std :: vector ;
using std :: string ;


/******************************************************************
 * struct SubstationControlData_VI
 ******************************************************************/
struct SubstationControlData_VI
{

  // -----
  // Declaration of initialiser class
  // ѥ饹
  // -----

  struct Init
  {
    const TiXmlAttribute * _v ;
    const TiXmlAttribute * _i ;

    Init () { _v = _i = 0 ; }
  } ;

  double _v ;
  double _i ;

  SubstationControlData_VI () { _v = _i = 0 ; }
  SubstationControlData_VI ( const Init & ) ;
  SubstationControlData_VI ( double _v_ , double _i_ )
  { _v = _v_ ; _i = _i_ ; }

  SubstationControlData_VI ( const SubstationControlData_VI & x )
  { _v = x . _v ; _i = x . _i ; }

  SubstationControlData_VI & operator= ( const SubstationControlData_VI & x )
  { if ( & x  == this ) return * this ;
  _v = x . _v ; _i = x . _i ; return * this ; }

} ;



/******************************************************************
 * class SubstationControl_VI_TS
 ******************************************************************/

// Typedef
typedef DataInSection < SubstationControlData_VI ,
                        SubstationControlData_VI :: Init > VISection ;

class Substation_Control_VI_TS
  : public vector < VISection >
{

private :

  mutable vector < VISection > :: const_iterator _current ;
  mutable double t_ref ;
  mutable double t_cyc ;
  double t_first ;
  double t_last ;

public :

  // -----
  // Functions ... Reference to data
  // ؿ ... ǡؤλ
  // -----

  const SubstationControlData_VI & getData ( double ) const ;

  // -----
  // Functions ... Within range?
  // ؿ ... ϰ⤫ɤ?
  // -----

  bool timeIsInRegion ( double ) const ;
  bool timeIsBeforeRegion ( double ) const ;
  bool timeIsAfterRegion ( double ) const ;
  void incrementCycle ( double xc ) const { t_cyc += xc ; }
  void decrementCycle ( double xc ) const { t_cyc -= xc ; }

  // Constructor
  Substation_Control_VI_TS ( const string & ) ;

  // X(X&)
  Substation_Control_VI_TS ( const Substation_Control_VI_TS & x )
    : vector < VISection > ( x ) , _current ( x . _current ) ,
      t_ref ( x . t_ref ) , t_cyc ( x . t_cyc ) , t_first ( x . t_first ) ,
      t_last ( x . t_last ) {}

  // Operator =
  Substation_Control_VI_TS & operator= ( const Substation_Control_VI_TS & x )
  { vector < VISection > :: operator= ( x ) ; _current = x . _current ;
  t_ref = x . t_ref ; t_cyc = x . t_cyc ; t_first = x . t_first ;
  t_last = x . t_last ; return * this ; }

private :

  // Default constructor prohibited
  explicit Substation_Control_VI_TS () ;

} ;


#endif	// Substation_Control_VI_TS_HH
